# -*- coding: iso-8859-1 -*-
###############################################################################
# begin                : Sat Dec 14 2002
# copyright            : (C) 2003 by Ricardo Niederberger Cabral
# email                : nieder at mail dot ru
#
###############################################################################
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###############################################################################

""" Custom widgets module
"""

from string import *                    #TODO2: ugly. Remove this import later
import os
import traceback
import Error
import sys

try:
    from qt import *
    import qt
except:
    Error.qtImportError()

from imgSeekLib import __version__
from ImageDB import AddFilter

class DragListView(QListView):
    #TODO2: review latest drag/drop techniques on PyQT, as this widget needs some rework
    def __init__(self, *args):
        apply(QListView.__init__,(self, ) + args)
        self.setAcceptDrops(1)
        self.viewport().setAcceptDrops(1)
        self.dragids = []
        self.drobj = None
        self.dropItem = None
        self.mousePressed = 0

    def contentsDragMoveEvent(self, e):
        QListView.contentsDragMoveEvent(self, e)
        vp = self.contentsToViewport( e.pos() )
        i = self.itemAt( vp )
        if i and i.isGroup:
            e.accept()
            e.acceptAction()
            self.dropItem = i
            return
        if not i:
            e.accept()
            e.acceptAction()
            self.dropItem = -1
            return
        #is a file
        e.ignore()
        self.dropItem = None

    def contentsDragLeaveEvent(self, e):
        QListView.contentsDragLeaveEvent(self, e)
        self.dropItem = None

    def contentsMouseMoveEvent(self, e):
        if self.mousePressed:
            self.mousePressed = 0
            QDragObject(self.viewport()).drag()
        QListView.contentsMouseMoveEvent(self,e)

    def contentsMouseReleaseEvent(self, e):
        QListView.contentsMouseReleaseEvent(self, e)
        self.mousePressed = 0

    def contentsMousePressEvent(self,e):
        QListView.contentsMousePressEvent(self,e)
        if e.button() ==2:
            return
        p = self.contentsToViewport( e.pos() )
        i = self.itemAt( p )
        if  i:
            try:
                if (p.x()> (self.header().sectionPos(self.header().mapToIndex(0))+self.treeStepSize() * (i.depth()+1)+self.itemMargin())) or (p.x()<(self.header().sectionPos(self.header().mapToIndex(0)))):
                    self.presspos = e.pos()
                    self.mousePressed = 1
            except:
                self.presspos = e.pos()
                self.mousePressed = 1
            if self == self.env.wnd.BrowseCategListView:
                self.env.wnd.BrowseCategListView_clicked(i)

class ColorClickableLabel(QLabel):
    """overloaded mousePressEvent in order to catch clicks on a given point """
    def __init__(self, *args):
        apply(QLabel.__init__,(self, ) + args)
        self.color = [0,0,0]
        self.callBack = None

    def mousePressEvent (self,e ):
        rgb = self.pixmap().convertToImage().pixel(e.x(),e.y())
        self.color = [qRed(rgb),qGreen(rgb),qBlue(rgb)]
        if self.callBack: self.callBack()

class SmartComboBox(QComboBox):
    """overloaded keypress events so the Enter event can trigger a callback. The callback should be set to the cb member, which will get called without parameters"""
    def __init__(self, *args):
        apply(QComboBox.__init__,(self, ) + args)
        self.color = [0,0,0]
        self.callBack = None

    def keyPressEvent (self,e ):
        if e.key()==Qt.Key_Return:
            if self.cb: self.cb()
        QComboBox.keyPressEvent (self,e )

class Painting(QWidget):
    """subclassed so I could catch mouse move/press/release events"""
    def __init__(self, *args):
        apply(QWidget.__init__,(self, ) + args)
        self.buffer = QPixmap(128,128)
        self.buffer.fill()
        self.pen = QPen()
        self.pen.setColor(QColor(0,0,0,QColor.Rgb))
        self.dlg = None

    def paintEvent(self, ev):
        bitBlt(self, 0, 0, self.buffer)

    def heightForWidth ( self, w ):
        return int(w)

    def resizeEvent (self,e):
        self.resize(QSize(e.size().width(),self.heightForWidth(e.size().width())))
        QWidget.resizeEvent(self,e)

    def mouseMoveEvent(self, ev):
        self.p = QPainter()
        self.p.begin(self.buffer)
        self.pen.setColor(QColor(self.dlg.DrawQueryColorPixmap.color[0],self.dlg.DrawQueryColorPixmap.color[1],self.dlg.DrawQueryColorPixmap.color[2],QColor.Rgb))
        self.p.setPen( self.pen )
        w = self.pen.width()
        self.p.drawEllipse(ev.pos().x()-w/2,ev.pos().y()-w/2,w,w)
        self.p.flush()
        self.p.end()
        bitBlt(self, 0, 0, self.buffer)

    def mouseReleaseEvent(self, ev):
        self.dlg.sketchRelease()

    def mousePressEvent(self, ev):
        self.p = QPainter()
        self.p.begin(self.buffer)
        self.p.drawPoint(ev.pos())
        self.currentPos = QPoint(ev.pos())
        self.p.flush()
        self.p.end()
        bitBlt(self, 0, 0, self.buffer)

    def reset(self):
        self.buffer.fill()
        self.paintEvent(None)

class MouseMoveLabel(QLabel):
    def __init__(self, *args):
        apply(QLabel.__init__,(self, ) + args)
        self.mousePressed = 0
        self.mvCallback = None
        self.setScaledContents(0)
        self.accrotate = 0              # amount of rotation accumulated so far. (used on doRotate)
        self.initPos = [0,0]
        self.setText("\n\n\timgSeek %s\n\thttp://imgseek.sf.net/\t\n\n"%__version__)
        self.origPixmap = None            # natural size pixmap
        self.infolabel = None             # label to set when zoomed
        self.fname = None                 # filename being displayed
        self.fid = -1                     # image id being displayed (-1 if image is not on db)
        self.sview = None                 # my parent scrollview
        self.fitcb = None                 # if nonempty, tell slideview that should showimg with autofit [DEPRECATED !!!!]

    def createMenus(self):
        self.setBackgroundMode(Qt.PaletteDark)
        self.setPaletteForegroundColor(Qt.white)
        self.setCursor(QCursor(Qt.PointingHandCursor))
        self.imgmenu = QPopupMenu(self) #the popup for images
        self.imgmenu.insertItem ( "&Auto fit", self.onAutoFit,0,5)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem ( "&Fit to window", self.onFit)
        self.imgmenu.insertItem ( "&Natural size", self.onNatural)
        self.imgmenu.insertItem ( "Zoom [&+]", self.onZoomMore)
        self.imgmenu.insertItem ( "Zoom [&-]", self.onZoomLess)
        self.imgmenu.insertItem ( "&Rotate", self.onRotate)
        self.imgmenu.insertItem (self.env.wnd.globalslide.iconSet(), "F&ullscreen", self.onFullScreen)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem ( "&External program ...", self.onExec)
        if sys.platform.find('win') == -1:  # *nix platform. This option is currently only available on *NIX
            self.imgmenu.insertItem ( "Set as desktop bac&kground", self.onSetBg)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem ( self.env.wnd.fileSaveAction.iconSet(),"&Save as displayed ...", self.onSaveDisp)
        self.imgmenu.insertItem ( self.env.wnd.fileSaveAsAction.iconSet(),"&Save original to ...", self.onCopyImageMenu)
        #self.imgmenu.insertItem ( "&Move ...", self.onRotate)                #TODO5: implement one day
        #self.imgmenu.insertItem ( "&Delete", self.onRotate)
        self.imgmenu.insertSeparator()
        self.imgmenu.insertItem (self.env.wnd.findduplicatemenu.iconSet(), "&Query for similar images", self.onQuery)
        self.imgmenu.insertItem (self.env.wnd.findduplicatemenu.iconSet(), "Q&uery for similar filenames", self.onQueryFname)
        self.imgmenu.setCheckable(1)

    def onSetBg(self):
        if sys.platform.find('win') != -1:  # windows platform
            pass #TODO: port to windows, and update the method above this one (createMenus)
        else:
            from Settings import binpathfinder
            prog = binpathfinder("bsetbg")
            if prog:
                os.spawnlp(os.P_NOWAIT, prog,prog,self.fname)
                return

            prog = binpathfinder("Esetroot")
            if prog:
                os.spawnlp(os.P_NOWAIT, prog,prog,self.fname)
                return

            prog = binpathfinder("xsetbg")
            if prog:
                os.spawnlp(os.P_NOWAIT, prog,prog,self.fname)
                return

    def onSaveDisp(self):
        filename = unicode(QFileDialog.getSaveFileName(self.fname))
        if not filename:return
        try:
            ext = upper(os.path.splitext(filename)[1][1:])
            if ext in ("JPG","JPE"): ext = "JPEG"
            self.pixmap().save(filename,ext)
        except:
            self.env.wnd.showTrace()

    def onCopyImageMenu(self):
        smfname = ""
        try:
            smfname = os.path.split(self.fname)[-1]
        except:
            pass
        filename = unicode(QFileDialog.getSaveFileName(smfname))
        if not filename:return
        import shutil
        try:
            shutil.copyfile(self.fname, filename)
        except:
            self.env.wnd.showTrace()

    def onExec(self):
        text = unicode(QInputDialog.getText("imgSeek","Program name to run:" ,QLineEdit.Normal, "gimp")[0])
        if text:
            os.spawnlp(os.P_NOWAIT, text,text,self.fname)

    def onFullScreen(self):
        from SlideShowDialog import SlideShowDialog
        ds = SlideShowDialog(self,self.env)
        ds.showImg(self.fname)

    def onQuery(self):
        self.env.wnd.queryImgByFilename(self.fname)

    def onQueryFname(self):
        self.env.wnd.queryImgFilename(self.fname)

    def onAutoFit(self):
        if self.imgmenu.isItemChecked(5):
            self.imgmenu.setItemChecked(5,0)
            self.onNatural()
            self.env.options["view.autofit"] = "0"
            self.env.wnd.fitimagecheck.setChecked(0)
        else:
            self.imgmenu.setItemChecked(5,1)
            self.onFit()
            self.env.options["view.autofit"] = "1"
            self.env.wnd.fitimagecheck.setChecked(1)

    def doRotate(self,fac):
        try:
            m = QWMatrix()
            m.rotate(fac)
            aIm = self.pixmap().convertToImage().xForm(m) # temporary pixmap
            a = self.pixmap()
            del a
            aP = QPixmap()
            aP.convertFromImage(aIm)
            self.setPixmap(aP)
            self.accrotate = self.accrotate + fac
            # tell database we rotated this image
            if self.fid != -1:          # of course, only if this image is actually on db
                self.env.curdb.changedDB({"scope":"Img",
                                          "reason":"viewtransformed",
                                          "transform":str(self.accrotate),
                                          "subject":self.fid})
        except:
            traceback.print_exc()
            QMessageBox.information( self, "imgSeek","Error rotating image or invalid factor provided.")

    def onRotate(self):
        fac = QInputDialog.getInteger("imgSeek","Rotation factor (in degrees: \"90\" means Rotate Right):" ,90)
        if not fac[1]: return
        fac = fac[0]
        self.doRotate(fac)

    def showImage(self):
        #TODO4: later, some MouseMoveLabel related code that is on ImgViewScroll should stay here, and MouseMoveLabel.showImage() should be called by ImgViewScroll,showImg()
        self.accrotate = 0                # reset the "rotation-accumulator"

    def onFit(self):
        if str(self.env.options["view.smoothscale"]) == '1' or str(self.env.options["view.smoothscale"]) == 'True':
            aIm = self.pixmap().convertToImage().smoothScale ( self.sview.visibleWidth(), self.sview.visibleHeight(), QImage.ScaleMin)
        else:
            aIm = self.pixmap().convertToImage().scale ( self.sview.visibleWidth(), self.sview.visibleHeight(), QImage.ScaleMin)
        aP = QPixmap()
        aP.convertFromImage(aIm)
        a = self.pixmap()
        del a
        self.setPixmap(aP)

    def onZoomMore(self):
        aIm = self.env.curdb.openImage(self.fname).scale ( int(self.pixmap().width()*1.4), self.pixmap().height(), QImage.ScaleMax)
        a = self.pixmap()
        del a
        aP = QPixmap()
        aP.convertFromImage(aIm)
        self.setPixmap(aP)

    def onZoomLess(self):
        aIm = self.env.curdb.openImage(self.fname).smoothScale ( int(self.pixmap().width()/1.4), self.height(), QImage.ScaleMin)
        a = self.pixmap()
        del a                           # this del thing is jerky, but works
        aP = QPixmap()
        aP.convertFromImage(aIm)
        self.setPixmap(aP)

    def onNatural(self):
        self.setPixmap(self.env.curdb.openPixmap(self.fname))

    def mousePressEvent(self,e):
        if e.button()==2: #right click
            if not self.origPixmap:     # called from a slideshow
                if not hasattr(self,"slideshowDialog"): return
                self.slideshowDialog.imgmenu.popup(e.globalPos())
                return
            if self.fname: self.imgmenu.popup(e.globalPos())
            return
        self.setCursor(QCursor(Qt.SizeAllCursor))
        self.mousePressed = 1
        self.initPos = [e.x(),e.y()]

    def mouseReleaseEvent(self,e):
        self.setCursor(QCursor(Qt.PointingHandCursor))
        self.mousePressed = 0
        delta = [e.x()-self.initPos[0], e.y()-self.initPos[1]]
        if self.mvCallback:
            self.mvCallback(delta)
        else:
            print 'no mv callback set on mouse release event'

class ImgViewScroll(QScrollView):
    def __init__(self, *args):
        apply(QScrollView.__init__,(self, ) + args)
        self.pixlabel = MouseMoveLabel(self)
        self.pixlabel.sview = self
        self.pixlabel.origPixmap = 1
        self.pixlabel.mvCallback = self.onMouseDelta
        self.fitcb = []
        self.pixlabel.fitcb = self.fitcb
        self.infolabel = None
        self.MainTabWidget = None
        self.addChild(self.pixlabel)

    def showImg(self,fname,fit = 0,fid=-1):
        """if resz = 1, then the dlg will autoresize to images size
        """
        if not os.path.exists(fname):
            print "File not found:"+fname
            self.infolabel.setText("%s | File not found !" % ( fname) )
            self.pixlabel.infolabel = self.infolabel
            self.pixlabel.setPixmap(QPixmap())
            return
        if self.pixlabel.fname==fname:return # dont display image if it's already displayed
        imgDim=""                       # resolve later to image dimensions
        self.pixlabel.infolabel = self.infolabel

        if int(self.env.options["view.autofit"]):
            fit = 1
        if fit:
            aIm = self.env.curdb.openImage(fname)
            imgDim = "%dx%d" % (aIm.width(),aIm.height())
            if int(self.env.options["view.smoothscale"]):
                aIm = aIm.smoothScale ( self.visibleWidth(), self.visibleHeight(), QImage.ScaleMin)
            else:
                aIm = aIm.scale ( self.visibleWidth(), self.visibleHeight(), QImage.ScaleMin)
            a = self.pixlabel.pixmap()
            del a
            aP = QPixmap()
            aP.convertFromImage(aIm)
            self.pixlabel.setPixmap(aP)
        else:
            a = self.pixlabel.pixmap()
            del a
            aIm = self.env.curdb.openPixmap(fname)
            imgDim = "%dx%d" % (aIm.width(),aIm.height())
            self.pixlabel.setPixmap(aIm)

        self.infolabel.setText("%s | %s | %s" % ( fname, imgDim, self.env.curdb.prettysize(os.stat(fname).st_size) ) )
        self.pixlabel.fname = fname
        self.pixlabel.fid = fid
        self.pixlabel.accrotate = 0

        #TODO2: these view transforms (aka rotations) should happen before fitting image to window. That would fix bug #959344
        if fid != -1:                   # check for view transforms
            if self.env.curdb.meta.has_key(fid):
                if self.env.curdb.meta[fid].has_key("ViewRotate"):
                    self.pixlabel.doRotate(int(self.env.curdb.meta[fid]["ViewRotate"]))

    def onMouseDelta(self,delta):
        self.scrollBy(-delta[0],-delta[1])

folder_closed_xpm = [
"18 18 102 2",
"  	c None",
". 	c #44392C",
"+ 	c #093759",
"@ 	c #F9F7F7",
"# 	c #5A91A9",
"$ 	c #5B91A9",
"% 	c #183744",
"& 	c #51717E",
"* 	c #F8F5F2",
"= 	c #F7F3F0",
"- 	c #578FA8",
"; 	c #4F8094",
"> 	c #D1E2E7",
", 	c #F5F0EC",
"' 	c #F5EFEA",
") 	c #528CA7",
"! 	c #D1E2E6",
"~ 	c #CDE0E4",
"{ 	c #CADEE3",
"] 	c #F4EEE7",
"^ 	c #F3ECE5",
"/ 	c #F2EBE3",
"( 	c #CDDFE4",
"_ 	c #C9DDE2",
": 	c #C6DBE0",
"< 	c #C3D9DF",
"[ 	c #C0D7DD",
"} 	c #F1E8DF",
"| 	c #F0E7DD",
"1 	c #4D89A6",
"2 	c #4E8AA6",
"3 	c #C2D9DE",
"4 	c #BFD7DC",
"5 	c #BCD5DB",
"6 	c #B9D3D9",
"7 	c #B5D1D7",
"8 	c #B2CFD5",
"9 	c #EDE3D6",
"0 	c #4A88A5",
"a 	c #4B88A5",
"b 	c #4C89A6",
"c 	c #B8D2D8",
"d 	c #B5D0D7",
"e 	c #B1CED5",
"f 	c #AECCD3",
"g 	c #ABCAD1",
"h 	c #A8C8CF",
"i 	c #A4C6CE",
"j 	c #EBDFD0",
"k 	c #343434",
"l 	c #3B5B70",
"m 	c #4887A5",
"n 	c #4A87A5",
"o 	c #ADCCD3",
"p 	c #AACAD1",
"q 	c #A7C8CF",
"r 	c #A4C6CD",
"s 	c #A0C4CB",
"t 	c #9DC2CA",
"u 	c #E9DCCB",
"v 	c #E9DAC9",
"w 	c #F7F7F7",
"x 	c #F1F1F1",
"y 	c #4887A4",
"z 	c #4987A5",
"A 	c #A3C5CD",
"B 	c #A0C3CB",
"C 	c #9CC1C9",
"D 	c #99BFC7",
"E 	c #E8DAC9",
"F 	c #E8D9C7",
"G 	c #F4F4F4",
"H 	c #EFEFEF",
"I 	c #EAEAEA",
"J 	c #E5E5E5",
"K 	c #4585A4",
"L 	c #98BFC7",
"M 	c #95BDC5",
"N 	c #92BBC3",
"O 	c #E7D7C4",
"P 	c #ECECEC",
"Q 	c #E7E7E7",
"R 	c #E2E2E2",
"S 	c #DDDDDD",
"T 	c #D8D8D8",
"U 	c #8EB8C1",
"V 	c #E6D5C1",
"W 	c #4786A4",
"X 	c #DFDFDF",
"Y 	c #DADADA",
"Z 	c #D5D5D5",
"` 	c #BBBBBB",
" .	c #C4C4C4",
"..	c #ABABAB",
"+.	c #919191",
"@.	c #397389",
"#.	c #B3B3B3",
"$.	c #9A9A9A",
"%.	c #818181",
"&.	c #43809C",
"*.	c #6C6C6C",
" = .	c #515C63",
"                .                   ",
"        + +   . @ .                 ",
"      + # $ % & * = .               ",
"      + - ; > > & , ' .             ",
"    + ) ; ! ~ { & ] ^ / .           ",
"    + ; ( _ : < [ & & } | .         ",
"  + 1 2 ; 3 4 5 6 7 8 & & 9 .       ",
"  + 0 a b ; c d e f g h i & j .     ",
"k l l m n a ; o p q r s t & u v .   ",
"k w x l l y z ; A B C D & E F .     ",
"k G H I J l l K ; L M N & O .       ",
"k x P Q R S T l l ; U & V . W +     ",
"  k k J X Y Z Z ` l l % . W +       ",
"      k k T Z  ...+.k @.W +         ",
"          k k #.$.%.k &.+           ",
"              k k *. = .+             ",
"                  k k               ",
"                                    "]

folder_open_xpm = [
"18 18 56 1",
" 	c None",
".	c #023751",
"+	c #44392C",
"@	c #5FA6C2",
"#	c #F8F7F6",
"$	c #F8F6F4",
"%	c #F7F4F1",
"&	c #F6F3F0",
"*	c #F6F2EF",
" = 	c #F5F1EE",
"-	c #F5F1ED",
";	c #F5F0EC",
">	c #F4EFEB",
",	c #F4EFE9",
"'	c #F3EEE8",
")	c #F3EDE7",
"!	c #F2ECE6",
"~	c #F2ECE5",
"{	c #F2EBE4",
"]	c #F1EAE3",
"^	c #F1E9E2",
"/	c #F0E9E1",
"(	c #F0E8E0",
"_	c #EFE7DE",
":	c #EFE7DD",
"<	c #EFE6DC",
"[	c #EEE5DB",
"}	c #EEE4DA",
"|	c #EDE4D9",
"1	c #3A7199",
"2	c #EDE3D8",
"3	c #ECE2D7",
"4	c #ECE1D6",
"5	c #ECE1D5",
"6	c #EBE0D3",
"7	c #EBDFD2",
"8	c #EADFD1",
"9	c #EADED0",
"0	c #E9DDCF",
"a	c #E9DCCE",
"b	c #E9DCCD",
"c	c #E8DBCC",
"d	c #E8DACB",
"e	c #E7D9CA",
"f	c #E7D9C8",
"g	c #E6D8C7",
"h	c #E6D7C6",
"i	c #E6D7C5",
"j	c #E5D6C4",
"k	c #E5D5C3",
"l	c #E4D4C2",
"m	c #474747",
"n	c #E3D2BF",
"o	c #E2D1BE",
"p	c #B1B1B1",
"q	c #7E7E7E",
"    ..  ++        ",
"   .@@.+#$++      ",
"   .@@@+%&* = ++    ",
"  .@@@+ = -;>,')++  ",
"  .@@@+,')!~{]^/+ ",
"   .@+!~{]^/(_:<+ ",
"   .@+^/(_:<[}|+1.",
"  .@+_:<[}|2345+1.",
"  .@+}|2345678+1. ",
" .@+34567890ab+1. ",
" .@+7890abcde+1.  ",
".@@@++cdefghi+1.  ",
".@@@@@++ijkl+1.   ",
" ..@@@@m++no+1.   ",
"   ..@mpqm++1.    ",
"     .mqpm111.    ",
"       mm11..     ",
"         ..       "]

folder_locked = [
"16 16 81 1",
" 	c None",
".	c #141414",
"+	c #000000",
"@	c #3E3A0A",
"#	c #2E2A07",
"$	c #312D07",
"%	c #989253",
"&	c #E3E3D5",
"*	c #CFCFBC",
" = 	c #C5C5AD",
"-	c #BDBDA0",
";	c #BEBEA0",
">	c #C4C3A4",
",	c #C5C5A6",
"'	c #C7C7AB",
")	c #CACAB1",
"!	c #D3D3C1",
"~	c #E1E2D6",
"{	c #DDDDD2",
"]	c #3B3714",
"^	c #8D884D",
"/	c #D1D1BF",
"(	c #9C9C71",
"_	c #A7A782",
":	c #B3B393",
"<	c #BFBFA3",
"[	c #848265",
"}	c #949279",
"|	c #DBDBCC",
"1	c #F7F7F3",
"2	c #EBEBE5",
"3	c #CFCFBF",
"4	c #322F11",
"5	c #827D48",
"6	c #C2C3A4",
"7	c #BFBFA4",
"8	c #919078",
"9	c #28241F",
"0	c #1B1615",
"a	c #A9A898",
"b	c #EDEDE8",
"c	c #C0C0AC",
"d	c #2A270E",
"e	c #777343",
"f	c #D1D1B2",
"g	c #CBCBB4",
"h	c #BDBBA9",
"i	c #C3C2B7",
"j	c #E0E0D5",
"k	c #B2B299",
"l	c #211F0B",
"m	c #6C683D",
"n	c #D7D7BC",
"o	c #D6D6C5",
"p	c #E2E2D6",
"q	c #696557",
"r	c #A4A486",
"s	c #191708",
"t	c #615E38",
"u	c #DDDDC9",
"v	c #DCDBD7",
"w	c #AEAD9E",
"x	c #BFBFAA",
"y	c #959573",
"z	c #100F05",
"A	c #565333",
"B	c #E0DFD3",
"C	c #F9F9F7",
"D	c #807D6F",
"E	c #221D1B",
"F	c #6F6B5D",
"G	c #878760",
"H	c #080703",
"I	c #3B3715",
"J	c #A19F93",
"K	c #89877A",
"L	c #312D11",
"M	c #27240D",
"N	c #1D1B0A",
"O	c #131207",
"P	c #090903",
"     ..++..     ",
"    .++++++.    ",
"   .+.    .+.   ",
"   .+      +.   ",
"   ++      ++   ",
"  @##@@@@@@$#@  ",
" %&* = -;>,')!~{] ",
" ^/(_:<[}|12{34 ",
" 56_:7890ab{3cd ",
" ef:7gh00ij3ckl ",
" mn7gopqq{3ckrs ",
" tugopv00wxkryz ",
" ABopCDE0FkryGH ",
"  IpC2{JKkryG+  ",
"   II{3ckry++   ",
"     ]LMNOP     "]

pix_file = [
"18 18 86 1",
" 	c None",
".	c #585858",
"+	c #DEDEDE",
"@	c #BCB7B1",
"#	c #999999",
"$	c #FFFFFF",
"%	c #EAEAEA",
"&	c #6D6D6D",
"*	c #FCFCFC",
" = 	c #707070",
"-	c #CECECE",
";	c #303030",
">	c #9B9B9B",
",	c #898989",
"'	c #6B6B6B",
")	c #424242",
"!	c #F6F5F5",
"~	c #E2E0DE",
"{	c #8F8984",
"]	c #FBF9F6",
"^	c #F4F0EC",
"/	c #E7E0D9",
"(	c #BEB6AF",
"_	c #DFDFDF",
":	c #FEFEFE",
"<	c #FBF8F5",
"[	c #F8F4ED",
"}	c #F3EDE3",
"|	c #EEE7DC",
"1	c #BCAE97",
"2	c #9A9A9A",
"3	c #989794",
"4	c #97948F",
"5	c #95918B",
"6	c #948F86",
"7	c #ECE2D4",
"8	c #FDFDFC",
"9	c #FAF8F4",
"0	c #F8F3EB",
"a	c #F5EEE4",
"b	c #F3EADC",
"c	c #F1E6D4",
"d	c #ECDFCA",
"e	c #BCAB90",
"f	c #FCFCFB",
"g	c #95918A",
"h	c #948E85",
"i	c #928B80",
"j	c #91887B",
"k	c #ECDBC2",
"l	c #BCA88A",
"m	c #FAF6F2",
"n	c #F8F2EA",
"o	c #F5EEE2",
"p	c #F2E9DA",
"q	c #F0E4D2",
"r	c #EEE0C9",
"s	c #ECDCC1",
"t	c #E9D6BA",
"u	c #BCA685",
"v	c #F7F1E9",
"w	c #949089",
"x	c #938D84",
"y	c #928B7F",
"z	c #91887A",
"A	c #8F8575",
"B	c #8E8270",
"C	c #E7D1B0",
"D	c #BCA37F",
"E	c #F4EDE1",
"F	c #F2E8D8",
"G	c #F0E4D0",
"H	c #EEDEC8",
"I	c #ECDABF",
"J	c #E9D6B8",
"K	c #E5CCA7",
"L	c #BCA178",
"M	c #C6C1B6",
"N	c #C4BDAC",
"O	c #C3B8A3",
"P	c #C2B39A",
"Q	c #C0AF91",
"R	c #BFAA88",
"S	c #BEA57F",
"T	c #BDA076",
"U	c #BC9E73",
"    .........     ",
"    .+++++@.#.    ",
"    .+$$$$%&$#.   ",
"    .+$$$$* = -$#;  ",
"    .+$>>>$, = ');  ",
"    .+$$$$$!~@{;  ",
"    .+$>>>>]^/(;  ",
"    ._$$$:<[}|1;  ",
"    .+$>2345671;  ",
"    .+$890abcde;  ",
"    .+f34ghijkl;  ",
"    .+mnopqrstu;  ",
"    .+vwxyzABCD;  ",
"    .+EFGHIJCKL;  ",
"    .MMNOPQRSTU;  ",
"    .;;;;;;;;;;;  ",
"                  ",
"                  "]

folderLocked =None
folderClosed =None
folderOpen =None
fileNormal =None

hiddenDots = [] # list of [parent lvi, lvi] that have been hidden because the user chose so
hiddenNormal = [] # list of [parent lvi, lvi] that have been hidden because the user chose so

env = None

class FileItem(QListViewItem):
    def __init__(self,parent,s1,fulln):
        QListViewItem.__init__(self,parent,s1)
        self.fullName = fulln
        self.filename = fulln             # for querying
        self.isdir = 0

    def setPixmap(self,px ):
        QListViewItem.setPixmap(self,0,px)

class Directory(QListViewItem):
    itemMap = {}
    def __init__(self,parent,filename,fullname,sdo = 0, probe = 0):
        QListViewItem.__init__(self,parent,filename)
        self.isdir = 1
        self.fullName = fullname
        Directory.itemMap[fullname] = self
        self.f = filename
        self.p = None
        self.showDirsOnly = sdo
        
        if probe:
            self.readable = QDir(fullname).isReadable()
            if not self.readable:
                self.setPixmap(folderLocked )
            else:
                self.setPixmap(folderClosed )
        else:
            self.setPixmap(folderClosed)

    def setPixmap(self,px ):
         QListViewItem.setPixmap(self,0,px)

    def setOpen(self, o ):
        if ( o ):
            self.setPixmap( folderOpen )
        else:
            self.setPixmap( folderClosed )
        if o and not self.childCount():
            s = self.fullName
            thisDir = QDir( s )
            if not thisDir.isReadable():
                self.readable = 0
                self.setExpandable( 0)
                return
            for file in os.listdir(s):
                file = s+os.sep+file
                fname = rfind(file,os.sep)
                if fname==-1:
                    smfile = file
                else:
                    smfile = file[fname+1:]
                # using "options" here is ok because imgSeek set this global module var on init
                nit = None
                if os.path.islink(file): #and  not self.showDirsOnly:
                    nit = Directory(self, smfile,file)
                elif os.path.isdir(file):
                    nit = Directory(self, smfile,file)
                elif not self.showDirsOnly:
                    item = FileItem( self, smfile,file)

                    if env.extIsImg(smfile):
                        item.setPixmap(imageicon) # imageicon is set to the global scope by imgSeek:__init__
                        item.isImg = 1
                    else:
                        item.setPixmap( fileNormal )
                        item.isImg = 0
                    nit = item
                if smfile[0]=="." and not int(env.options["browse.showdotfiles"]):
                    hiddenDots.append(nit)
                    nit.setVisible(0)
                if hasattr(nit,"isImg") and not nit.isImg and not int(env.options["browse.shownormalfiles"]):
                    hiddenNormal.append(nit)
                    nit.setVisible(0)

        QListViewItem.setOpen(self, o )

    def setup(self):
        self.setExpandable( 1)
        QListViewItem.setup(self)

class DirectoryView(QListView):

    def __init__(self,parent = None,name="",sdo=0):
        QListView.__init__(self,parent,name)
        self.dirsOnly = sdo
        self.setAcceptDrops( 0 )
        self.connect( self, SIGNAL( "doubleClicked(QListViewItem*)"),self.slotFolderSelected)
        self.connect( self, SIGNAL( "returnPressed(QListViewItem*)"),self.slotFolderSelected)
        self.connect( self, SIGNAL( "mouseButtonClicked(int,QListViewItem*,const QPoint&,int)"),self.clicked)

        self.selectedItmFname = None
        self.htmllist = None
        self.cb = None                    # callback called when the user leftclicks on a file/dir
        self.addDircb = None              # callback called when the user asks for a dir to be added do dbase
        self.doDots = 0
        self.doNormal = 0

    def createMenus(self):
        self.browseDirMenu = QPopupMenu(self) #the popup for directories
        self.browseDirMenu.insertItem (self.env.wnd.fileNewAction.iconSet(), "&Add to database", self.onMenuAddDB)
        self.browseDirMenu.insertItem (self.env.wnd.editbatch.iconSet(), "Add to &batch", self.onMenuAddHTML)
        self.browseDirMenu.insertItem (self.env.wnd.folderaction.iconSet(), "Add to &bookmarks", self.onAddBookm)

    def onAddBookm(self):
        if not self.selectedItmFname: return
        self.env.curdb.addSysDirBookmark(self.selectedItmFname)

    def showDots(self,show):
        self.doDots = show
        if show:
            for it in hiddenDots:
                try:
                    hiddenDots.remove(it)
                    it.setVisible(1)
                except:
                    traceback.print_exc()
                    pass
        else:
            it = self.firstChild()
            dragids = []
            while it:
                if str(it.text(0))[0]=='.':
                    dragids.append(it)
                it = it.itemBelow()
            for it in dragids:
                hiddenDots.append(it)
                it.setVisible(0)

    def showNormalFiles(self,show):
        self.doNormal = show
        if show:
            for it in hiddenNormal:
                try:
                    hiddenNormal.remove(it)
                    it.setVisible(1)
                except:
                    traceback.print_exc()
                    pass
        else:
            it = self.firstChild()
            dragids = []
            while it:
                if hasattr(it,"isImg") and not it.isImg:
                    dragids.append(it)
                it = it.itemBelow()
            for it in dragids:
                hiddenNormal.append(it)
                it.setVisible(0)

    def onMenuAddDB(self):
        if self.addDircb:
            restr = AddFilter(self.env)
            restr.addfname = self.selectedItmFname
            self.addDircb(restr)

    def onMenuAddHTML(self):
        self.env.curdb.addItemBatch({"type":"SysDir","id":self.selectedItmFname})

    def clicked(self,but,a,p,c):
        if (not a): return
        if self.cb:
            if but==1:
                self.selectedItmFname = a.fullName
                self.cb(a.fullName)
            if but==2:
                if a.isdir:
                    self.selectedItmFname = a.fullName
                    self.browseDirMenu.popup(p)

    def slotFolderSelected(self,i ):
        """ called when user double clicks"""
        if (not i): return
        if hasattr(i,"isImg") and i.isImg:
            self.env.wnd.selectedResult = i
            self.env.wnd.onResultsMenuQuery()

    def showPath(self,path):
        parts = split(path,os.sep)
        parts[1] = os.sep + parts[1]
        for part in parts[1:]:
            if not part:
                continue
            it = self.findItem(part,0)
            if not it:# and not lastit:
                QMessageBox.information(self, "imgSeek", 'Path not found:"%s"' % path)
                return 0
            it.setOpen(1)
        self.ensureItemVisible(it)
        return 1

class DragIconView(QIconView):
    def __init__(self, *args):
        apply(QIconView.__init__,(self, ) + args)
    def dragObject(self):
        return  QTextDrag( " ",self )
