.TH "trcyk" 1 "October 2009" "Infernal 1.0.2" "Infernal Manual"

.SH NAME
.TP 
truncyk_check - check alignment under the TrCYK model

.SH SYNOPSIS
.B truncyk_check
.I [options]
.I cmfile
.I seqfile

.SH DESCRIPTION

.B trcyk
reads the covariance model (CM) in
.I cmfile
and aligns the sequences in 
.I seqfile
to that CM using the TrCYK model for incomplete data,
using both the full-memory and divide-and-conquer
approaches.  It checks that the scores from both
methods match, that the alignments from both methods
match, and that the score of each alignment matches
the score returned by the program.

.PP
Because it does use the full-memory implementation of
TrCYK it can be extremely memory intensive; checking
only the scores with the 
.I --scoreonly
option or only the divide-and-conquer approach with the
.I --smallonly
option is advised for large models and/or long sequences.

.SH OPTIONS

.TP
.B -h
show help 

.TP
.B --scoreonly
Check only the scores, not the alignments (saves memory).

.TP
.B --smallonly
Check only divide-and-conquer, not the full memory implementation
(saves memory).

.TP
.B --stringent
Require the two parsetrees to be identical.
