/**
 * Innovation3D Quake MDL Plugin
 * 		(c) 2001 Filip Van Raemdonck <mechanix@digibel.org>
 * 		mdl format declarations (c) 1996-1997 Id Software, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to: 
 * 			Free Software Foundation, Inc.
 * 			59 Temple Place - Suite 330
 * 			Boston, MA  02111-1307, USA.
 *
 * 		$Id: qmdlfile.h,v 1.1 2001/07/24 03:41:35 janders Exp $
 **/

#ifndef _QMDLFILE_H
#define _QMDLFILE_H

#include <Plugins/fileplugin.h>

#ifndef SYNCTYPE_T
#define SYNCTYPE_T
typedef enum { ST_SYNC=0, ST_RAND } synctype_t;
#endif

typedef float vec_t;
typedef vec_t vec3_t[3];

/* little-endian "IDPO" */
#define IDPOLYHEADER (('O'<<24)+('P'<<16)+('D'<<8)+'I')

typedef struct {
	int        ident;
	int        version;
	vec3_t     scale;
	vec3_t     scale_origin;
	float      boundingradius;
	vec3_t     eyeposition;
	int        numskins;
	int        skinwidth;
	int        skinheight;
	int        numverts;
	int        numtris;
	int        numframes;
	synctype_t synctype;
	int        flags;
	float      size;
} mdl_t;

typedef enum { ALIAS_SKIN_SINGLE=0, ALIAS_SKIN_GROUP } aliasskintype_t;
typedef struct {
	aliasskintype_t type;
} daliasskintype_t;

typedef struct {
	int numskins;
} daliasskingroup_t;

typedef struct {
	float interval;
} daliasskininterval_t;

typedef struct {
	int onseam;
	int s;
	int t;
} stvert_t;

typedef struct dtriangle_s {
	int facesfront;
	int vertindex[3];
} dtriangle_t;

typedef enum { ALIAS_SINGLE=0, ALIAS_GROUP } aliasframetype_t;
typedef struct {
	aliasframetype_t type;
} daliasframetype_t;

#ifndef _DEF_BYTE_
#define _DEF_BYTE_
typedef unsigned char byte;
#endif

typedef struct {
	byte v[3];
	byte lightnormalindex; /* index in table! */
} trivertx_t;

typedef struct {
	trivertx_t bboxmin;   /* lightnormal isn't used */
	trivertx_t bboxmax;   /* lightnormal isn't used */
	char       name[16];
} daliasframe_t;

typedef struct {
	int        numframes;
	trivertx_t bboxmin;   /* lightnormal isn't used */ /* this is min for the entire group */
	trivertx_t bboxmax;   /* lightnormal isn't used */ /* this is max for the entire group */
} daliasgroup_t;

typedef struct {
	float interval;
} daliasinterval_t;

class QMDLFile : public FilePlugin  {
public: 
	QMDLFile ();
	~QMDLFile ();

	void importData (ifstream&);
	void exportData (ofstream&);

protected:
	void createObject ();

	void readHeader (ifstream&);
	void writeHeader (ofstream&);

	void readFrames (int, ifstream&);
 	void readTexCoords (int, ifstream&);
 	void readTriangles (int, ifstream&);
	void readSkins (int, ifstream&);

	vector< Vector4 > uvs;
	vector< vector< Vector4 > > verts;
	vector< dtriangle_t > triangles;
	mdl_t header;
	Object *o;

private:
	void readSimpleFrame (ifstream&);

	int offsetTexCoords;
	int offsetTriangles;
	int offsetFrames;
};

#endif	/* _QMDLFILE_H */
