
#include "cmeshdlg.h"
#include <qmessagebox.h>
#include "../config.h"
#include <i3d.h>

/*
 *  Constructs a CMeshDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
CMeshDlg::CMeshDlg( QWidget* parent, const char* name, bool modal, WFlags fl )
      : ICMeshDlg( parent, name, modal, fl )
{}

/*
 *  Destroys the object and frees any allocated resources
 */
CMeshDlg::~CMeshDlg()
{
   // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void CMeshDlg::slotBrowse()
{
   QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
   QString name = QFileDialog::getOpenFileName( directory, "Images (*.png *.xpm *.jpg *.rgb)" );

   if ( !name.isNull() )
   {
      fldFile -> setText( name );
   }
}

/*
 * public slot
 */
void CMeshDlg::slotTypeChanged( int type )
{
   switch ( type )
   {
      case CUBE:
         enable( true, true, true, false );
         setLabels( "Slices", "Stacks", "Layers" );
         setValues( 1, 1, 1 );
         break;
      case SPHERE:
         enable( true, true, false, false );
         setLabels( "Radius", "Subdivides", "" );
         setValues( 1, 2, 1 );
         break;
      case HEIGHTMAP:
         enable( true, true, true, true );
         setLabels( "X Slices", "Max Height", "Z Slices" );
         setValues( 20, 5, 20 );
         break;
      case CYLINDER:
         enable( true, true, true, false );
         setLabels( "Radius Slices", "Stacks", "Radius" );
         setValues( 16, 2, 1 );
         break;
      case PLANE:
         enable( true, true, false, false );
         setLabels( "X Slices", "Z Slices", "" );
         setValues( 2, 2, 1 );
         break;
   }
}

void CMeshDlg::enable( bool a, bool b, bool c, bool d )
{
   spnA -> setEnabled( a );
   lblA -> setEnabled( a );

   spnB -> setEnabled( b );
   lblB -> setEnabled( b );

   spnC -> setEnabled( c );
   lblC -> setEnabled( c );

   fldFile -> setEnabled( d );
   btnBrowse -> setEnabled( d );

}

void CMeshDlg::setLabels( char *a, char *b, char *c )
{

   lblA -> setText( a );
   lblB -> setText( b );
   lblC -> setText( c );

}

void CMeshDlg::setValues( int a, int b, int c )
{

   spnA -> setValue( a );
   spnB -> setValue( b );
   spnC -> setValue( c );

}

void CMeshDlg::slotAccept()
{
   if ( chType -> currentItem() == HEIGHTMAP )
   {
      //make sure a valid has been picked
      QString s = fldFile -> text();

      if ( s.isNull() || s == "" )
      {
         QMessageBox::warning( 0, "Create Custom Mesh", "You must pick an image for the heightmap." );
         return ;
      }
   }

   accept();
}
