/***************************************************************************
                         surfacemodifier.cpp  -  description
                            -------------------
   begin                : Mon Apr 23 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "surfacemodifier.h"
#include <Entities/nurbssurface.h>

#include <i3d.h>
#include <i3dworkspace.h>
#include "modetoolbar.h"
#include "psurfacedlg.h"
#include "ctesselatedlg.h"
#include <Entities/mesh.h>

int SurfaceModifier::TYPE = IControl::getUID();

SurfaceModifier::SurfaceModifier() : ObjectModifier( "Surfaces", NurbsSurface::TYPE )
{
   setName( "Sur&faces" );
   m_popup -> insertSeparator();
   m_popup -> insertItem( "Tesselate", this, SLOT( slotTesselate() ) );
   m_popup -> insertSeparator(); 	
 	 m_popup -> insertItem( "Properties", this, SLOT( slotProperties() ) );
}

SurfaceModifier::~SurfaceModifier()
{}

void SurfaceModifier::activate()
{
   clearSelection();
   I3D::getWorkspace() -> setCurrentControl( this );
   I3D::setModeMsg( " Surface Mode " );
   SelectMode::set( NurbsSurface::TYPE );
   //change to select mode immediately.
   ModeToolbar::setMode( ModeToolbar::MODE_SELECT );

   updateViews();
}

void SurfaceModifier::deactivate()
{
}

void SurfaceModifier::slotTesselate()
{
	if (assertSelected(1) )
	{
		setStatus( "Tessselating surfaces..." );
		CTesselateDlg *dlg = new CTesselateDlg( 0, "Tesselate Surfaces", true );
	
		if ( dlg -> exec() )
		{
			int u = dlg -> getU();
			int v = dlg -> getV();
			SelectionIterator it = m_selection -> begin();
			TransactionCommand *tc = new TransactionCommand();
			while( it != m_selection -> end() )
			{
				NurbsSurface *sf = static_cast<NurbsSurface *>( *it );				
				
				Mesh *m = sf -> getMesh( u, v );
				
				tc -> addCommand( new DBCommand( m, ADD ) );
				++it;
			}
			tc -> execute();
			tc -> save();
			
      updateViews();
      setStatusDone();		
		}
		else
		{
      updateViews();
      setStatusDone();		
		}
	}
}

void SurfaceModifier::slotProperties()
{
if ( assertSelected( 1 ) )
   {

   setStatus( "Editing properties..." );

   /* Popup custom dialog here.
    */
   PSurfaceDlg *dlg = new PSurfaceDlg( 0, "Surface Properties", true );

   SelectionIterator it = m_selection -> begin();

   dlg -> setEnableAll( true );
   dlg -> setSurface( static_cast<NurbsSurface *>( *it ) );

   if ( dlg -> exec() )
   {
      cerr << "Done with properties " << endl;
      NurbsSurface *m = static_cast<NurbsSurface*>( *it );
      CheckPointCmd *pc = new CheckPointCmd( m );   m_popup -> insertSeparator();
      pc -> save();
      Vector4 pos = dlg -> getPosition();
      Quat ori = dlg -> getOrientation();

      m -> setName( dlg -> getName() );
      m -> setNotes( dlg -> getNotes() );
      m -> setPosition( pos );
      m -> setOrientation( ori );

      updateViews();
      setStatusDone();
   }

   else
   {
      updateViews();
      setStatusDone();
   }
  }
}

