/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  window.cc - GdkGLWindow C++ wrapper inmplementation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "window.h"
#include "private/window_p.h"
#include "private/drawable_p.h"
#include "config.h"
#include <inti/gdk/window.h>

using namespace Inti;

/*  Gdk::GL::Window
 */

Gdk::GL::Window::Window(GdkGLWindow *window, bool reference)
: Gdk::Drawable((GdkDrawable*)window, reference)
{
}

Gdk::GL::Window::~Window()
{
}

Pointer<Gdk::GL::Window>
Gdk::GL::Window::create(const Config& glconfig, const Gdk::Window& window, const int *attrib_list)
{
	return G::Object::wrap<Gdk::GL::Window>(gdk_gl_window_new(glconfig.gdk_gl_config(), window.gdk_window(), attrib_list));
}

GdkGLWindowClass*
Gdk::GL::Window::gdk_gl_window_class() const
{
	return get_class<GdkGLWindowClass>();
}

Gdk::GL::Window::operator GdkGLWindow* () const
{
	return this ? gdk_gl_window() : 0;
}

Gdk::Window*
Gdk::GL::Window::get_window() const
{
	return G::Object::wrap<Gdk::Window>(gdk_gl_window_get_window(gdk_gl_window()));
}

Gdk::GL::Window*
Gdk::GL::Window::get_gl_window(Gdk::Window& window)
{
	return G::Object::wrap<Window>(gdk_window_get_gl_window(window.gdk_window()));
}

Gdk::GL::Drawable*
Gdk::GL::Window::get_gl_drawable(Gdk::Window& window)
{
	GdkGLDrawable *drawable = gdk_window_get_gl_drawable(window.gdk_window());
	Gdk::GL::Drawable *tmp_drawable = 0;
	if (drawable)
	{
		G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(drawable));
		tmp_drawable = dynamic_cast<Gdk::GL::Drawable*>(object);
	}
	return tmp_drawable;
}

bool
Gdk::GL::Window::is_gl_capable(Gdk::Window& window)
{
	return gdk_window_is_gl_capable(window.gdk_window());
}

Pointer<Gdk::GL::Window>
Gdk::GL::Window::set_gl_capability(Gdk::Window& window, const Config& glconfig, const int *attrib_list)
{
	return G::Object::wrap<Window>(gdk_window_set_gl_capability(window.gdk_window(), glconfig.gdk_gl_config(), attrib_list));
}

void
Gdk::GL::Window::unset_gl_capability(Gdk::Window& window)
{
	gdk_window_unset_gl_capability(window.gdk_window());
}

void
Gdk::GL::Window::dispose()
{
	gdk_gl_window_destroy(gdk_gl_window());
}

/*  Gdk::GL::WindowClass
 */

void
Gdk::GL::WindowClass::init(GdkGLWindowClass *g_class)
{
	Gdk::DrawableClass::init((GdkDrawableClass*)g_class);
}

GType
Gdk::GL::WindowClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_GL_WINDOW, (GClassInitFunc)init);
		G::TypeInstance::add_interface(type, GDK_TYPE_GL_DRAWABLE, (GInterfaceInitFunc)Gdk::GL::DrawableClass::init);
	}
	return type;
}

void*
Gdk::GL::WindowClass::create()
{
	return g_object_new(get_type(), 0);
}

