// -*- C++ -*-
// --------------------------------------------------------------------
// Undo
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEUNDO_H
#define IPEUNDO_H

#include "ipepage.h"
#include "ipedoc.h"

// --------------------------------------------------------------------

class IPE_EXPORT IpeUndoItem {
 public:
  virtual ~IpeUndoItem() = 0;
  virtual IpeString Text() const = 0;
  virtual int Undo(IpeDocument *doc) = 0;
  virtual int Redo(IpeDocument *doc) = 0;
};

class IPE_EXPORT IpeUndoStack {
 public:
  IpeUndoStack();
  ~IpeUndoStack();
  void Clear();
  void Add(IpeUndoItem *item);
  int Undo(IpeDocument *doc);
  int Redo(IpeDocument *doc);
  IpeString UndoText() const;
  IpeString RedoText() const;
  //! Is an Undo action available?
  inline bool CanUndo() const { return iCur > 0; }
  //! Is a Redo action available?
  inline bool CanRedo() const { return iCur < iStack.size(); }
 private:
  std::vector<IpeUndoItem *> iStack;
  uint iCur;
};

// --------------------------------------------------------------------

class IPE_EXPORT IpeUndoPageEdit : public IpeUndoItem {
public:
  IpeUndoPageEdit(int pno, IpePage *page, IpeString text);
  ~IpeUndoPageEdit();
  virtual IpeString Text() const;
  virtual int Undo(IpeDocument *doc);
  virtual int Redo(IpeDocument *doc);
private:
  IpeString iText;
  int iPno;
  IpePage *iPage;
};

class IPE_EXPORT IpeUndoObjInsertion : public IpeUndoItem {
public:
  IpeUndoObjInsertion(int pno, IpeString text);
  virtual IpeString Text() const;
  virtual int Undo(IpeDocument *doc);
  virtual int Redo(IpeDocument *doc);
private:
  IpeString iText;
  int iPno;
  IpePgObjectSeq iObj;
};

class IPE_EXPORT IpeUndoPageIns : public IpeUndoItem {
public:
  IpeUndoPageIns(int pno, IpeString text);
  virtual IpeString Text() const;
  virtual int Undo(IpeDocument *doc);
  virtual int Redo(IpeDocument *doc);
private:
  IpeString iText;
  int iPno;
  IpePage *iPage;
};

class IPE_EXPORT IpeUndoPageDel : public IpeUndoItem {
public:
  IpeUndoPageDel(int pno, IpePage *page, IpeString text);
  ~IpeUndoPageDel();
  virtual IpeString Text() const;
  virtual int Undo(IpeDocument *doc);
  virtual int Redo(IpeDocument *doc);
private:
  IpeString iText;
  int iPno;
  IpePage *iPage;
};

class IPE_EXPORT IpeUndoViews : public IpeUndoItem {
public:
  IpeUndoViews(int pno, IpeViewSeq views, IpeString text);
  virtual IpeString Text() const;
  virtual int Undo(IpeDocument *doc);
  virtual int Redo(IpeDocument *doc);
private:
  IpeString iText;
  int iPno;
  IpeViewSeq iViews;
};

class IPE_EXPORT IpeUndoObjectEdit : public IpeUndoItem {
public:
  IpeUndoObjectEdit(int pno, IpePage::iterator it,
		    IpePage *page, const IpePgObject &obj,
		    IpeString text);
  virtual IpeString Text() const;
  virtual int Undo(IpeDocument *doc);
  virtual int Redo(IpeDocument *doc);
private:
  IpeString iText;
  int iPno;
  int iObjNum;
  IpePgObjectSeq iObject;
};

// --------------------------------------------------------------------
#endif
