#if HAVE_CONFIG_H
#  include <config.h>
#endif

#if !HAVE_RESIZE_WINDOW && HAVE_WRESIZE
#  define resize_window(w, l, c) (wresize((w), (l), (c)), (w))
#  define HAVE_RESIZE_WINDOW 1
#endif

#if !HAVE_VSNPRINTF
#include <stdarg.h>	/* for va_list */
#include <stddef.h>	/* for size_t */
int vsnprintf(char *str, size_t size, const char *format, va_list ap);
#endif

#if !HAVE_SNPRINTF
#include <stdarg.h>
#include <stddef.h>	/* for size_t */
int snprintf(char *str, size_t size, const char *format, ...);
#endif

#if !HAVE_GAI_STRERROR
#undef gai_strerror	/* in case Winsock #defined it brokenly */
const char *gai_strerror(int err);
#endif

#if !HAVE_STRUCT_ADDRINFO
#include <stddef.h>	/* for size_t */
struct addrinfo {
    int     ai_flags;
    int     ai_family;
    int     ai_socktype;
    int     ai_protocol;
    size_t  ai_addrlen;
    struct sockaddr *ai_addr;
    char   *ai_canonname;
    struct addrinfo *ai_next;
};
#endif

#if !HAVE_SOCKLEN_T
#include <stddef.h>	/* for size_t */
typedef size_t socklen_t;
#endif

#if !HAVE_GETADDRINFO
/* EAI_* nicked from GNU netdb.h */
#define EAI_BADFLAGS     -1    /* Invalid value for `ai_flags' field.  */
#define EAI_NONAME       -2    /* NAME or SERVICE is unknown.  */
#define EAI_AGAIN        -3    /* Temporary failure in name resolution.  */
#define EAI_FAIL         -4    /* Non-recoverable failure in name res.  */
#define EAI_NODATA       -5    /* No address associated with NAME.  */
#define EAI_FAMILY       -6    /* `ai_family' not supported.  */
#define EAI_SOCKTYPE     -7    /* `ai_socktype' not supported.  */
#define EAI_SERVICE      -8    /* SERVICE not supported for `ai_socktype'.  */
#define EAI_ADDRFAMILY   -9    /* Address family for NAME not supported.  */
#define EAI_MEMORY       -10   /* Memory allocation failure.  */
#define EAI_SYSTEM       -11   /* System error returned in `errno'.  */
#define EAI_OVERFLOW     -12   /* Argument buffer overflow.  */

#undef getaddrinfo	/* in case Winsock #defined it brokenly */
int getaddrinfo(const char *node, const char *service,
		const struct addrinfo *hints, struct addrinfo **res);
#endif

#if !HAVE_FREEADDRINFO
#undef freeaddrinfo	/* in case Winsock #defined it brokenly */
void freeaddrinfo(struct addrinfo *res);
#endif

#if !HAVE_GETNAMEINFO
/* NI_* nicked from GNU netdb.h */
#define NI_MAXHOST      1025
#define NI_MAXSERV      32

#define NI_NUMERICHOST 1       /* Don't try to look up hostname.  */
#define NI_NUMERICSERV 2       /* Don't convert port number to name.  */
#define NI_NOFQDN      4       /* Only return nodename portion.  */
#define NI_NAMEREQD    8       /* Don't return numeric addresses.  */
#define NI_DGRAM       16      /* Look up UDP service rather than TCP.  */

#include "autosocket.h"	/* for socklen_t */
#include <stddef.h>	/* for size_t */
#undef getnameinfo	/* in case Winsock #defined it brokenly */
int getnameinfo(const struct sockaddr *sa, socklen_t salen, char *host,
		size_t hostlen, char *serv, size_t servlen, int flags);
#endif
