(in-package :crypto-tests)


;;; standard tests

(digest-test "" "E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855")
(digest-test "a" "CA978112CA1BBDCAFAC231B39A23DC4DA786EFF8147C4E72B9807785AFEE48BB")
(digest-test "abc" "BA7816BF8F01CFEA414140DE5DAE2223B00361A396177A9CB410FF61F20015AD")
(digest-test "message digest" "F7846F55CF23E14EEBEAB5B4E1550CAD5B509E3348FBC4EFA3A1413D393CB650")
(digest-test "abcdefghijklmnopqrstuvwxyz" "71C480DF93D6AE2F1EFAD1447C66C9525E316218CF51FC8D9ED832F2DAF18B73")
(digest-test "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq" "248D6A61D20638B8E5C026930C3E6039A33CE45964FF2167F6ECEDD419DB06C1")
(digest-test "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" "DB4BFCBD4DA0CD85A60C3C37D3FBD8805C77F15FC6B1FDFE614EE0A7C8FDB4C0")
(digest-test "12345678901234567890123456789012345678901234567890123456789012345678901234567890" "F371BC4A311F2B009EEF952DD83CA80E2B60026C8E935592D0F9C308453C813E")


;;; bit-level tests from NESSIE (http://www.cryptonessie.org/)

(digest-bit-test 0 #x80 63 "A9E8913B13864096B9EA592F9548C87654AAF8DF24E3437645FAC174D1036E1C")
(digest-bit-test 0 #x40 63 "F315F3F6D33215F8777A7D5A4B809F433729D13A86FE6ADF3DA5C11137E18273")
(digest-bit-test 0 #x20 63 "AE1F446791358EEB17DEBD264614CAEB7F72558C085C73BE0DDE284B4C63A957")
(digest-bit-test 0 #x10 63 "94C41AF484FFF7964969E0BDD922F82DFF0F4BE87A60D0664CC9D1FFD3ACD650")
(digest-bit-test 0 #x08 63 "2763D88A93549AF57C701D5187E8B477D9AA99EBEFE6D1E41A3CE07BF1A1AA50")
(digest-bit-test 0 #x04 63 "D6E497B816C27A31ACD5D9F3ED670639FEF7842FEE51F044DFBFB6319C760A5F")
(digest-bit-test 0 #x02 63 "8A023A9E4AFFBB255A6B48AE85CC4A7D1A1B9E8E6809FE9E48535C01C1FC071A")
(digest-bit-test 0 #x01 63 "16ABAB341FB7F370E27E4DADCF81766DD0DFD0AE64469477BB2CF6614938B2AF")
(digest-bit-test 1 #x80 62 "5A42062C0EF5A54ECCF7B0B155C90BBF408AB2480EE939342ACBEBC24E265401")
(digest-bit-test 1 #x40 62 "B5B17E5DFF8C9A4AE35D22DE243821159C400060F0F32D8FD87914DA904AE459")
(digest-bit-test 1 #x20 62 "5CD77BAB00B0CDF152F3B0B42287F061E5DAF3AC7806B484572DB8E0A64BEE77")
(digest-bit-test 1 #x10 62 "ED5F4ED0D6617D50ABD49D4C84281E175B48A7E1EDF550A89BF2C9B5C4CE01F0")
(digest-bit-test 1 #x08 62 "D5755A80F47671E9C3E10C007865D7868432D9942CA2CE7D60510039A281CC5C")
(digest-bit-test 1 #x04 62 "335D953107E146619C0BF52F8D650C2CDBB5DAF1E1278F51437D96215AC74DB9")
(digest-bit-test 1 #x02 62 "1A2A07EA5731313C488CD126D0C118542516CF35A507F9E8AE4A81EA92E3F267")
(digest-bit-test 1 #x01 62 "4286DA436D65E3A216846042CA5E0F51AC7A192E9DA271A72A9C4097BEECD52F")
(digest-bit-test 2 #x80 61 "FE882C6CF31C7A4A93A4F5A2BC5499E443731A87F6074EB32CEFAFA3E3B8B864")
(digest-bit-test 2 #x40 61 "5B9CD7FE975B5F7894DF930EB23518029068F9BA7D2DAD3D8DA29B40E1AA2EF0")
(digest-bit-test 2 #x20 61 "36558C5A404A9748423F31D60FAD2373E643A9B5B2F145C4390AD8C80345DC14")
(digest-bit-test 2 #x10 61 "887BBFD20CB15B19D2483B1D56DFCF5BCD74B8D05ED44CC912ABE80E92D1064F")
(digest-bit-test 2 #x08 61 "5D434409283CDC8E500C72DE5591F50BD858C8377A7F5F979E5F1B446E091EC0")
(digest-bit-test 2 #x04 61 "68062FA9A8B16191F44B782CBC5C35E434965C23E7922001447B2005F5EAB033")
(digest-bit-test 2 #x02 61 "CFA4AAF2F726AD6D9726B59E8D850BA58B688490E5214187B1766963E0DC1408")
(digest-bit-test 2 #x01 61 "2F59C313EECC21D0CAE49D92EF60246E0498BCB84FF30925F2E9BC045578B1AA")
(digest-bit-test 3 #x80 60 "2E7963AF3EC7FF5CE6A4C23FF2C3D9BFA765C1A7CCF843E03E0BE147D852E91D")
(digest-bit-test 3 #x40 60 "2FF775793E4DCBAD7D20D2428BC09CEEC908628797AEFD57A958B50F3485FEA3")
(digest-bit-test 3 #x20 60 "3DAE0491CDE03D6C7FAEA715170ED25139A0F7B77F601FA20F2A6FBAF8076610")
(digest-bit-test 3 #x10 60 "63635B0197FC6C31478B85C92748372B03C4356718B5D600B677C2F7A2A45DF9")
(digest-bit-test 3 #x08 60 "C4F689A854EFE7254FE0683DFC3ED392BB5F98656B2B906437819416F43D190C")
(digest-bit-test 3 #x04 60 "F0E43B2C47EE3CF4865CAFA6C2406CADEF4C7AE461AA7FD23C9F294F88AC3E23")
(digest-bit-test 3 #x02 60 "C4A8240D8711FF7C881B00324B9FB0A8BE9D90D99E7F95525EA69EAF9F7658CB")
(digest-bit-test 3 #x01 60 "18AE4CCBDA9538839D79BB18CA09E23E24AE8C1550F56CBB3D84B05331FFF401")
(digest-bit-test 4 #x80 59 "1B19FF19DB12ED9ACC13FA3A0AF2359D7F247946306E2B4BB9C33CDAFF3AF619")
(digest-bit-test 4 #x40 59 "9FC1D2FDDC3BF79EF1CD260C4DC38F9049FE9008A30361E939FB7D3484B78913")
(digest-bit-test 4 #x20 59 "73EC741E9AAB162395254AAA253960753D7B2270648C47BCF88D6B56B4B21B6D")
(digest-bit-test 4 #x10 59 "2E65812BD89BD1145EFEB3907772D220902C3D29DDA4DCBD5C56D956DFB3798A")
(digest-bit-test 4 #x08 59 "96CBBE51E1657CEA98D8A528B326F9E12B4EC3E96DF44248472E314378E63289")
(digest-bit-test 4 #x04 59 "0AB3F00B996C2E9B364C0180CBE26663D0270E7FBD54C6B1161A0E5AECF2730B")
(digest-bit-test 4 #x02 59 "78554A3A0C8F62E32DB9906F946B2BB3AC03B88618170E9E67C011EE4F7096D1")
(digest-bit-test 4 #x01 59 "D6DAAFE3DFBC6F26CEBBFEF13DBA8216F3CE07972F0755B0A39C92ABF6858E70")
(digest-bit-test 5 #x80 58 "55FFE1A582E6C6EC8EB546943833E4B746B122597B0937E265A7E2151F8EC5F1")
(digest-bit-test 5 #x40 58 "EC44B4A96BB31BE6E90B95FFAEF0FCB1650DCA2AC3687837FE0454EBCC3CF6E2")
(digest-bit-test 5 #x20 58 "E233BA3685C62E92EAE8A6A5E876426D8C384A4F0A41DD769A2EE19156127C2B")
(digest-bit-test 5 #x10 58 "C48910BEEC85E2C9E5DD94E15FB8F93FAE049199776832E7001CDC70139B24F5")
(digest-bit-test 5 #x08 58 "E810A131AB2FE5C1B224E06FB74237C52CFC290F8BB5E7CA67704ACF26A6A8F4")
(digest-bit-test 5 #x04 58 "EB3B3D88EC46D915AF459E38EEBCFE26ECD7FF2D966E99A5760A71001D4DB287")
(digest-bit-test 5 #x02 58 "A6444DCE5DEED90C057E9BF7126BF2A7DDA65FEFD19C0C835BB6228D24319EB5")
(digest-bit-test 5 #x01 58 "384A41704D44FC9FA013A0EE0A967AC55B303D92782D0DC1B002CE1163422B5B")
(digest-bit-test 6 #x80 57 "51655DFDD09BCBB89161EE7D934CB63F65E7F0C9BE8AF2DEAD06C909165EFAC0")
(digest-bit-test 6 #x40 57 "465B47DF86D8D6601383540EDE75E40AF1C482BBED28A2FA6415256AECA035C6")
(digest-bit-test 6 #x20 57 "FAE00DD8A3EFE9AEA394489EE52871975DEA0B517BD7DD464D16DD63101CFFDF")
(digest-bit-test 6 #x10 57 "069AD6583EEF4D8D1595D8F9BCD5E56F84658BDE7399737588D3AD3E4C35BD83")
(digest-bit-test 6 #x08 57 "848E1411238E592C06A260F0EC88654BE43716670A0F2CEBF795D200EB6BD2B6")
(digest-bit-test 6 #x04 57 "B6DDE25E006907CACDBB977307FFE3ECB5C1FAABD72350D19FE635A1F68A6C63")
(digest-bit-test 6 #x02 57 "45D1133AC05424A2D9B87030B58444F494CF37AF30C0A1F3C347537A43EC909C")
(digest-bit-test 6 #x01 57 "99390D8450F4498771E12A6E19F5511A67E1FDE8034154D1CE0C6D6D1C9FA6CC")
(digest-bit-test 7 #x80 56 "FA5FF9C30BF0762E0919831B82ADB7B0F817C53F97E16E23295A6AE410A30F45")
(digest-bit-test 7 #x40 56 "101664E54D067297DEB010BFA4B349DFD0F8BB29CFB9D164D8497CA7D4B364DC")
(digest-bit-test 7 #x20 56 "8A4EE959DB604A645DC87D6059B5BD2BE618F9630BCFD0802472EFEAFE161DBF")
(digest-bit-test 7 #x10 56 "16A4790BEB5E658DB1EB41B0BE81E67905C4FB250DDA9586290DA8170A1F2C3B")
(digest-bit-test 7 #x08 56 "238366DB6F519D123C0368F079F5022CA613B098716521C63DBA487382DFD706")
(digest-bit-test 7 #x04 56 "63F9E0E3EB02BC1E5D9B9914A85CA67D15379D2770018FFDD922CBF8C8499218")
(digest-bit-test 7 #x02 56 "98D66C738C93E5FCB805317BF1933E9FB6785D755947F7BC295378825D3022D3")
(digest-bit-test 7 #x01 56 "27B0F56C18180D06A1EA825A813E7EE7F68909AB503B66ED1D30FE35DE3ED5FB")
(digest-bit-test 8 #x80 55 "87FE0A8DCC23EB80FC1DB6724320543E4E55F983D5ADA1C422587E7D0F3A0376")
(digest-bit-test 8 #x40 55 "750C89EE48ADE5764BB543E267E04C32DFA5365F8188F4383BDC9BF7DFF9E862")
(digest-bit-test 8 #x20 55 "71CEC1690D152A93F13D0C4A1A2B3CDC0460ABE8AF1800EF94CD649662627B28")
(digest-bit-test 8 #x10 55 "D1C43A7FDA45CA32D2514DBD8F50F743EAA24E5F150B083650A454DCBC3B87ED")
(digest-bit-test 8 #x08 55 "04452E812B76E6BC0FA033984651AD9EFEF0DB4D56D8886C24FF24B06981FEBB")
(digest-bit-test 8 #x04 55 "54CE27BA2B8D5643E2915B5089157AEAFD4FF4E81306452671E06D6C26BEB856")
(digest-bit-test 8 #x02 55 "D7E5AD6B662F02F8B634949B2A90B654FA9357E6095798F721C4A26D42EFF4CC")
(digest-bit-test 8 #x01 55 "6E384B20006C687FE6183A443D7F15691A4D81BE5FE39D8ACB8D9EF7A8238117")
(digest-bit-test 9 #x80 54 "9E8C093CC770B108AD5D2C028CF48D3B4652548583D83389A3CFFD8F857821A2")
(digest-bit-test 9 #x40 54 "1D867F890D163C3094B6E2BA6FE16B19D8CDE95049F5CAE0095003576CF359DC")
(digest-bit-test 9 #x20 54 "5C82EA174F7C99F20FA78E4FFCD74BE8372AD83D4DDD9CE3E0D53B99A813A93F")
(digest-bit-test 9 #x10 54 "C54CE44900EDE8FE1434A667CFDBFB998180ACD3DCCA0CD73132E32F0F0056DE")
(digest-bit-test 9 #x08 54 "D04D6AB514083027C4FA071FF0ECF988F49ED5A9496E07842944FC496CF7C685")
(digest-bit-test 9 #x04 54 "961CD2C98BB68515DA22EC681520E912C7A1E9C0F01D749715FA229648ED02D8")
(digest-bit-test 9 #x02 54 "28E0FC7EFF7AB3F7A2F800B75BF819E2424B14ADB3DE8E35BFE500AFDB2A857D")
(digest-bit-test 9 #x01 54 "68ACC3396AAABA9F0DB2CE1D7B8327FA4B3BCC8A881F8BD16C3EE9EDEDC2E088")
(digest-bit-test 10 #x80 53 "5D987E43F6368F9B33F3AA812E785006210FF192670906C2E4A3C9DAB8096B01")
(digest-bit-test 10 #x40 53 "8DAE1338F0E9A06141FFF2E76953E0FDAE888113A5950EA5D0AF728D3744D3CF")
(digest-bit-test 10 #x20 53 "385EEC3C348B1AED84CBE8015D75EB79E3F3B354CCCDE381ABBE8F5C2ADDA330")
(digest-bit-test 10 #x10 53 "8DDBDBBF787F139A25C1D40D8A9108B9CF8C008FD10379B3EBEA8FB27A3B7A4C")
(digest-bit-test 10 #x08 53 "1E633B490B9369213ED26FD9B920B79FC6EC5E6B8FF3DED091C95CD5EFF6580D")
(digest-bit-test 10 #x04 53 "C5A580DEC9773743AAA8DD054B9E0A2556F96100FB7618E761BAACB5666689D5")
(digest-bit-test 10 #x02 53 "7AF26FB0A4158771ED17824C894F872E3D9BE453EF1A60FE075BC3609731819B")
(digest-bit-test 10 #x01 53 "4BA4FC0C8C329114035A8026CEB7088F302639D1D4D4727222BD1E67C448535E")
(digest-bit-test 11 #x80 52 "1A2ACF4E303865B9E92EA408A9278510A6A6D8B2003589652EF1901691123EEF")
(digest-bit-test 11 #x40 52 "0054216AC82168CF4389850D921F3297C0EB3191FF4B59D092BEC5AFCC144B3D")
(digest-bit-test 11 #x20 52 "2ACABFC631E3E54ADCA91DFF5CC7317C993926A56A986760184D7CEEA5D99B4A")
(digest-bit-test 11 #x10 52 "4CE4CB88C6364B3B2C7FBA1496693D32DCDA14141D38EDEF6B89ADB59D592364")
(digest-bit-test 11 #x08 52 "D995A4726D4117E0C270EDF2C90A86CC92E707D58F829D550390A33EF332229F")
(digest-bit-test 11 #x04 52 "5B0932A24469CE654D4B6F9336DD2C704E76C47BCBD246769D7A11DA87226F2E")
(digest-bit-test 11 #x02 52 "22EBC262ADFC355F74DCABA5049413F91DD6DF368256400C694DF9F9387C9170")
(digest-bit-test 11 #x01 52 "8204174FEC9661937F10FDCDC0F21D22C715CEA75E8A65EA48AA5F2656ACE73C")
(digest-bit-test 12 #x80 51 "793526200C8789845B8EBF1576D81EB58968CBA1E21DC569B77CFDD44B319724")
(digest-bit-test 12 #x40 51 "9394D8EF9CB5F34520A2D915E44134243F37763AA62457562FB08F833DC15EA4")
(digest-bit-test 12 #x20 51 "1E3D1BC3E1E151B53C020F2753A310241071A8635EBE7D73B7B403FC5249549B")
(digest-bit-test 12 #x10 51 "A06F37224118DFF3AADA5F800B73E868D894A9C137ED70B1E8B11EAD10CB1025")
(digest-bit-test 12 #x08 51 "EBAB76D8BD268E025ACFFB4C3BA37838F9D31980112F9477D96EE20F6D05F9E8")
(digest-bit-test 12 #x04 51 "8171056C199703D480DA637C5172F0C57636EDBD3019AF2638434022F11E68E6")
(digest-bit-test 12 #x02 51 "07CC0BD8CEFF88F280DCF9E8DBCD5A180C6A3C56C654896E6F9D533F56E5F12D")
(digest-bit-test 12 #x01 51 "A1591A87F66ECED286A026BE194EC87BE0FE1E9479BAF3B85CAEBA29AAA5FF98")
(digest-bit-test 13 #x80 50 "E709390882728CECA49604B51FF3A5B90773E499DDE9825F9953F166B50D2171")
(digest-bit-test 13 #x40 50 "0CA4D2B8860E35EA0A6113EFDD91C75718D6722AD6DB319E1ED05F7477592E62")
(digest-bit-test 13 #x20 50 "D18C38719F01277CCF0E394AFBA357352116D2BFA238A0C8389E8B4CB6053F13")
(digest-bit-test 13 #x10 50 "0B89A41A456BD73B36B66291604F4B2700FFC121BC5E6303D523EE9EF1A5769F")
(digest-bit-test 13 #x08 50 "F7109D2565DB442291E915E10622EBFFCFF00B7EB811B35C49356B828CFF3D09")
(digest-bit-test 13 #x04 50 "6E59F3D6E44866A80A9F83F47F6551188529341B6DC3B28DC97066183E4F62EB")
(digest-bit-test 13 #x02 50 "A96C072C03E4892DEE7C06A0E53327BC0F5A2E434DA82D44510484C158576C28")
(digest-bit-test 13 #x01 50 "CF196D6069AB8CD56FB148363BC793D8FA4F82571E46C6F4C47D6CDE34D08E09")
(digest-bit-test 14 #x80 49 "FD6402909175BE39A851E90C8A9679AC28175DC1D1FEC3ED8B5D5633BA0FB29D")
(digest-bit-test 14 #x40 49 "C1D6BB03D087AC72DFA0F60BC321EED88C453DA67047E077E254A4AE42C5DCA6")
(digest-bit-test 14 #x20 49 "15C7F345247CB2C74D53BFA08A41098816C3EDCABBE35226B8FBD532F37A5B3E")
(digest-bit-test 14 #x10 49 "CDC2F7D71B79384BBDEB4C1BB523D0EAFB54D8B6534BA0BFD3EA509CAB6D5263")
(digest-bit-test 14 #x08 49 "9F7B018C867EF344141DC43286533AC255C92F52D898547400BFEC008371B739")
(digest-bit-test 14 #x04 49 "041CB84FA14B83E44998E02443D22630873EECA3235B5B6B99757241758DF4CA")
(digest-bit-test 14 #x02 49 "5048583E74D84DB87F14455B3C3BC6DF30026A70606F0211564ED13C3681E8EE")
(digest-bit-test 14 #x01 49 "6D739D8A74C3DF91A97199A7E0F5B411F90634C4390BDE23D71F72EE1DAA386E")
(digest-bit-test 15 #x80 48 "C6D5A6F68BB7D53CB7304DECD22E4E831A465DC337F077CF9207BE07A788A470")
(digest-bit-test 15 #x40 48 "928E386EA548B1922B4D284003689D5C04A26A9BCD7D876B294FFEB18062F68E")
(digest-bit-test 15 #x20 48 "28B6290B52D13B0A0D6B967B98B1921E04C55FA98D45E7E1373D093C92950CE5")
(digest-bit-test 15 #x10 48 "EAB497B1F7E1FA12E3457F9C542C7B2AA47418C4BA15E7E1F2FAFD95E9B24080")
(digest-bit-test 15 #x08 48 "8A9BA0B1B781511F4FE2B9CB9E1B779B454D13F6771F0E5C088604DF18020B13")
(digest-bit-test 15 #x04 48 "151B522B45309B70B7A740D2102A9D1AFA00EB5309985A270E72477384BD5A2A")
(digest-bit-test 15 #x02 48 "413A2D719B9ECD7DAEE9B5782EA0DC4BC7DA68A36578D52F462F07C5C7CC3EBB")
(digest-bit-test 15 #x01 48 "0BFBAA977CDBEC98D5208E6A39ED8084C49E9B3812AA08456105B591B639E500")
(digest-bit-test 16 #x80 47 "11F95D879EB9E20338049F04186D8D3BD6B84AD6D168B5CB94A81F0928F76123")
(digest-bit-test 16 #x40 47 "83E869669EF1EB86AF473C27131BC1043EE2AA098171F0CB10396838B80E2852")
(digest-bit-test 16 #x20 47 "AD3923410D65B22EBE52D9241B064AEA2E9C6B1FCC1F3B87CF4FE24B6D279C81")
(digest-bit-test 16 #x10 47 "F34D63713B41A46AB57E3D58ACC1E2FB551B1ACB1464B84844495DDF3CA31C53")
(digest-bit-test 16 #x08 47 "37C4014E1190109F6AB94757573D42969CEF35C62DB81163BCBE344F6D35952E")
(digest-bit-test 16 #x04 47 "622327209A67F4F716E21992B1AA2C2EFE291502C973B84DF66CCC594D8951B3")
(digest-bit-test 16 #x02 47 "EE022A8C4A651ADAE0C94A710342C3E34A7EB8A144C7C68DD9E28AF6F857E8AB")
(digest-bit-test 16 #x01 47 "752C03CE3316BA05CA4C9256A56F20287FFA5CA9DE120C54083422FF0AA39484")
(digest-bit-test 17 #x80 46 "62B6821AC06AE513EBD4BB6E71905C2BE2D23D7F6F91585D25FFB4F4A7EADC82")
(digest-bit-test 17 #x40 46 "4D636023B89838862F6C5E13323B7126D9992EB9DC116EA0FD49C07E55077AEF")
(digest-bit-test 17 #x20 46 "186B0115921105FDC79642B22B975D73E8BAEF39F3DFA54D899BAB19742CD08E")
(digest-bit-test 17 #x10 46 "00437FA812270E235B565E4380108CDFCE3965B7EAB947F885AC38625BCC05E6")
(digest-bit-test 17 #x08 46 "C4A82A95E933A1002A4D0F428E692775AF3DA97F26B4859DB4411851039E278E")
(digest-bit-test 17 #x04 46 "433344AD40912C81654FBB4EE5B9DFDB40EFAE5E04701902DC2CFBD61E46406C")
(digest-bit-test 17 #x02 46 "A025F9FAB4920B6E075BB27B2EDFA590CB7AAF4FBF79D6244992745C2E4CCDA7")
(digest-bit-test 17 #x01 46 "100374AB429378172246C68FCBB03FD2F0C248CA5661D22BC57C5E11089EE0B9")
(digest-bit-test 18 #x80 45 "BD61FE93A4AFC5FC18826B72E9170D0F5A90673A4DCA6029933C1E7EE9F8A994")
(digest-bit-test 18 #x40 45 "E600FAF8F2A3ECCA343E9B2C0750C1B555C70C48233E5FE1843319E14DB4CCA6")
(digest-bit-test 18 #x20 45 "74ABD7E3B63DA0C50C60285ED214D5EB5685B041C04F2A5760E16CDA326E5A26")
(digest-bit-test 18 #x10 45 "CEE269F6ED2306C50A51E8652CB16EC3F5244422E74716E7B2B496210FEC8691")
(digest-bit-test 18 #x08 45 "E111CE36766C35A4FFB51B92EC020751478FB953CFE45E4EC8F0533DE6B0E389")
(digest-bit-test 18 #x04 45 "8A9B737C2505074E365B4E93AFAE34FB5750DE584F4EA6DB410DCA4EB4A4A4B9")
(digest-bit-test 18 #x02 45 "85368C816EFFDB2AABB46BCA1A68E6BE939763A007E5D8E0C300F010E4A20950")
(digest-bit-test 18 #x01 45 "F73860746259527888883C4A156C166B1E437D9F901B20A53C9AD38CA1A79F0F")
(digest-bit-test 19 #x80 44 "1214272B5CA64919D4A5E414BE111EBAC89E38A3E7012D266FA37059E7661A56")
(digest-bit-test 19 #x40 44 "F436C8090922DC9C9125F7946DBAD989D0F30C6937797F201B4EF6D50978762D")
(digest-bit-test 19 #x20 44 "83E1655FFECBFF4B6E9ADED0A2D1312FF900036CAEAB5C8761D7CE3CA893B688")
(digest-bit-test 19 #x10 44 "D139857DD62ED86DB019D9BC802288021B718C7ACC4175E33B660E2D0A397020")
(digest-bit-test 19 #x08 44 "0843449A3FE35677DFB3816FE4CFA489A8EE1AE3E5F84AE79042B26F79B58062")
(digest-bit-test 19 #x04 44 "323B852EBB3286D88AAD0139783166B82A2BBA338B400C6D6B87E1E8D3F2EC46")
(digest-bit-test 19 #x02 44 "F54441B6A5C993833062D5F66F230FBE7C81B7BF66E7C9279F91AAD94056DB82")
(digest-bit-test 19 #x01 44 "E4FB21E08A3DDDAE736792FE342E9AEAC7DDD42BB2BDAE7E650D80B0C29095F3")
(digest-bit-test 20 #x80 43 "0091715550D08BDC74C02EF3C679EF7008FCE665F24C13CD5DED432307E1B25F")
(digest-bit-test 20 #x40 43 "E2D01443022CFF8771825D02812C3909E13642691422CCDF4197DAFE8E7A53ED")
(digest-bit-test 20 #x20 43 "831A8C1A5EC3793DD2FEBD46B2EA989653F26984B2DF508E94C913C5D8209B27")
(digest-bit-test 20 #x10 43 "5BD023733D2742D9DAFB53CB1E949B3F5EBB89DD0063E5C8B937E95C3B0378D0")
(digest-bit-test 20 #x08 43 "406AE8A0DA1864B419B7196570A3B358F5E92D49FA0F2916543428D72AF6705F")
(digest-bit-test 20 #x04 43 "5966231A1F9016C946FC89CD163D28939C28B2FA8E85FBB3071FACDD7D793B33")
(digest-bit-test 20 #x02 43 "0ADA1081AD3E0CBF690BC16623C584D5A01E5F287842D9C3A54FA05D53F57B5C")
(digest-bit-test 20 #x01 43 "20FC7056C693A040CDDA479FE23832945C771265A86A81EBB46756A0E35C8E41")
(digest-bit-test 21 #x80 42 "92B814A7A3C35BA18DF50A8D61BDA5B920872C8761E5127DA5FA5417979710FB")
(digest-bit-test 21 #x40 42 "1C0CE1582DEA18877BDA514F5EA714B5E1EFE47FC56F636661AD627ECA3A88C6")
(digest-bit-test 21 #x20 42 "63CED81AAAE244EDBE9F3061EB04880081B760151102D4E3EF96CEE066A702A4")
(digest-bit-test 21 #x10 42 "7F1B4A9181213108A725E8688E1A0C89A42D669A040E642E7C50DF293C6EB286")
(digest-bit-test 21 #x08 42 "B61A30279CB9685D26F0633B942FB92D1EDCF10125155C95CCC3E4F324127F46")
(digest-bit-test 21 #x04 42 "DA0063B8AA47894FC7C2B192DF6286A7AA8AB189A75166ABA3910523F4C7343C")
(digest-bit-test 21 #x02 42 "CF0BE9C1E8E5536A0063714709F3CE9B6C64870583273D152E1AF2E9E8826437")
(digest-bit-test 21 #x01 42 "A40F4791838B9E90624E6048BD74B355222D74123F2BE4DF87C5C53E6528EDF1")
(digest-bit-test 22 #x80 41 "47FD4A2160999C3438801AE2741044C30BFB09FA28E588339B40EB4147A0088E")
(digest-bit-test 22 #x40 41 "1633C6F7CF7DFAFC06AA6566FCF5BDBA663987DE2118BD80B90DDDC24B3E6B47")
(digest-bit-test 22 #x20 41 "48A6C26EECFE1257C905F42AD27C5AEA3E247A12D8E37168B87EC23C5A3782E7")
(digest-bit-test 22 #x10 41 "69904A58FFB51D5A523B3F7CD89B1537B9464142FC6A558165D94C4306B36486")
(digest-bit-test 22 #x08 41 "4234E0D401967DC48B8F8E7065F21061827D4D3E164F212D49E9D3E4F8D08203")
(digest-bit-test 22 #x04 41 "0D35CFC713B51EECF0C7CD174AC057598E321E59CF8BC8F66701093451CB263D")
(digest-bit-test 22 #x02 41 "8252A0DE60A97430BED19227D2601829C1A4186EF0D9EE83081B681DC62833D0")
(digest-bit-test 22 #x01 41 "12B01C4ADB167F43D5C82C5D36C20433A1999D7B697296067325150F6B42E723")
(digest-bit-test 23 #x80 40 "FE92431BD6235C3A8E6CCD5BFF3C426A384805E20957B7709805D8B250199B0D")
(digest-bit-test 23 #x40 40 "257416F289917F3747A70BA80B0F2FA456938C5EDFD8235CFE57D241489B5A36")
(digest-bit-test 23 #x20 40 "2884586F209E50323451F32AE31A622202847696CE159E7DA03F9CE652244567")
(digest-bit-test 23 #x10 40 "A7F896978FDA16AEE6A05FE0E0E0A0053C05FF8EEEB94ADC2C2D80CAA5B78EF9")
(digest-bit-test 23 #x08 40 "E671DE62E823AC67D41803B68AA2E0FF74DE70C3F9C7894C69DADEEE6B102D8B")
(digest-bit-test 23 #x04 40 "AFB4ABE7C93F3B90BB6A3CF07700A413EC4FFF9354F1B54FC8198DF227FEE29E")
(digest-bit-test 23 #x02 40 "447FF32829FAE9ACA889CB164D52DD4A92CA6A56E303926CD9760A9B7A511062")
(digest-bit-test 23 #x01 40 "19DE25609DC348DB36FC8668F42B78131E981774DE9AB5D68B7FF38FAD1855BF")
(digest-bit-test 24 #x80 39 "998E932CCE059900512CF7C87965D3CB55B8F6F57B026CBCC170EBD2FA685039")
(digest-bit-test 24 #x40 39 "6AA754752F5885684231557BD9A696281ACAAB81202E3CF242B74C4C9974E95B")
(digest-bit-test 24 #x20 39 "1660EC3919278CF063BC16C4DA6C0493B7C95187F4B1E3BE91007FCA9B258FD9")
(digest-bit-test 24 #x10 39 "D5439F4CD69F0249C5F4B669863EF07AB67059FF9F6EDF5AB8569CC5AFBD707A")
(digest-bit-test 24 #x08 39 "C4B882FEBB7E9297980D45D05E7D77FDDA4FC320D39138C389B80E3EE1F5FE93")
(digest-bit-test 24 #x04 39 "BA29EC0E1056626D9D503BE8A4180D82694BBF9E7C6F9BA84F768337F836CEA6")
(digest-bit-test 24 #x02 39 "44FFEF2CAAC31AA58C323E8D54C4969E805140A8068E54C6948106FDFCF39FFB")
(digest-bit-test 24 #x01 39 "250575D2C5AA729F3A7A67696E93CFECBB0C74F610F7DF30483FA77D6156EBBB")
(digest-bit-test 25 #x80 38 "8463946014AF993FC53521E151DD0A5FE62DC9E4BE44B25951CE5108506E81FC")
(digest-bit-test 25 #x40 38 "4210C9B91A7903E1BEDF52F002CF07E9C940101F6A2A706FA5F5C46370B69BED")
(digest-bit-test 25 #x20 38 "35BCC9DDBA586ED7741840B1CC50318CBADB7D21033D49A9E13A365BDD8CF7B2")
(digest-bit-test 25 #x10 38 "1C4E0AA5721CB3FBA9619E7D3187289FE3B73FED4976C57C6B96B3FCC787E7A8")
(digest-bit-test 25 #x08 38 "D66C48F9805CA3A23C492763E7CB0CAD4F39C2906960F70782F03D982DE658DB")
(digest-bit-test 25 #x04 38 "86E32F041164B61EA3CEA4B08CC4DE1F0B372DF8DE0C70CA8912E74416C3C56B")
(digest-bit-test 25 #x02 38 "FC980464CADC70834ED870A8805297A9A134A17CE774577929883D37986E575B")
(digest-bit-test 25 #x01 38 "A960F4A548A5082B0C7A6E81CFC267EC551FF0590E7E481DBBB49D1320DB2993")
(digest-bit-test 26 #x80 37 "EB3D05BA0DBF1E4639B508A5071E048EA9537F5061D97635C278E1A42085FC4D")
(digest-bit-test 26 #x40 37 "4721C0512921E73F152434D3758BEE3850FD781D1615C216C9B9548215971D60")
(digest-bit-test 26 #x20 37 "75D3942826ADEADB234C13620EAE3387AC3712A0011E73D4B43CDDC1D8A19A3B")
(digest-bit-test 26 #x10 37 "B1C964DC8EF1DD6C7776F80513D20E907D151CF85B9288C211C43B11622ADE9C")
(digest-bit-test 26 #x08 37 "D131B7F26B81998EC103602D4519D8CE666AB16B28DFC0BE3AC8905F89F5FCD8")
(digest-bit-test 26 #x04 37 "992D98B251D8434F949203946F08DC58B8E5DC8E9B1A2683EF6C147D02FF4AE1")
(digest-bit-test 26 #x02 37 "796F69162354BAB8808A8A5995366974B63EF0FC918F742E96669825D3C4B7B3")
(digest-bit-test 26 #x01 37 "E853183FE5C256B343660C585EE24EAF3D08E7EFB03FE37153E3EFD10139210F")
(digest-bit-test 27 #x80 36 "596E7B035AF0AE5DE70BCD5676201A2AF82A5F2FA4C9B6C816179682D26C5512")
(digest-bit-test 27 #x40 36 "1AD5B174B748974B910D09AD8C69DE4BB9048616D946E7E68EA5E7633C97E6E5")
(digest-bit-test 27 #x20 36 "467F92DB569C7931096F19DE0E29D17010CA82C3B50E85FED08CB2D85B0B8F97")
(digest-bit-test 27 #x10 36 "9E7F02E099917E00619ED5BB9F9C7EEC2811F57ED0DAD85D2C95ED8DD0E4C08E")
(digest-bit-test 27 #x08 36 "3104DDF4257DEDC2010A4705CAF03B7D504B4FCF2ED1EEC59ADCA70BCA9310D5")
(digest-bit-test 27 #x04 36 "933883E24E576162D81D93298D58D922A8329795081D7597D4CF8010D94FA8D2")
(digest-bit-test 27 #x02 36 "D739D01F7E09356921DD36B319A81E6E5DFFE1F3A4B4835763B0E0BC7AF7D54C")
(digest-bit-test 27 #x01 36 "6F9FC1387DF177C8834F70EE0935668EBADE05884B7A613354F95ECA31071D95")
(digest-bit-test 28 #x80 35 "08FDA821CDCECD8B02CDEEF208BA74581883AB871564E283A497007619F05FF8")
(digest-bit-test 28 #x40 35 "8B486B4DFF4E698B634905033D54646C1506D5E99FDE44ECD842629B5AEDFFDF")
(digest-bit-test 28 #x20 35 "046B626BF4B91DF0948C5B424EFCC4998D399ED924514B111BF3DA6CB804A044")
(digest-bit-test 28 #x10 35 "49F8604A06257AF4E62B76EB9BAA153C00F6205529661240440236E8596C18E4")
(digest-bit-test 28 #x08 35 "4876639F3A19CD4BAD75A47E729E99C9D431F3ACD8E0C675FCFACCC7268CDE9A")
(digest-bit-test 28 #x04 35 "47B47983332873578EDE4F3C872005FA65B88B723A8D63B68266187FFF24C7BC")
(digest-bit-test 28 #x02 35 "6A3B715A9D621F009D0420B210B6628E0810A9B0FC5C230F5B6CB2A1CCB32521")
(digest-bit-test 28 #x01 35 "80AA5123B8E959A78F92DD0DF9C086E7CFF95CCAE81F11EE95A9178BC97DA5C3")
(digest-bit-test 29 #x80 34 "EB2495DD75C3983B972EE86E0C44A7DCCB58BDE45AAD011868FC1A4BA174B284")
(digest-bit-test 29 #x40 34 "52E5B0C1691841DDBFDB16B15ED91D4FD0AF5A5BAFBF803948CC692AD15001A6")
(digest-bit-test 29 #x20 34 "B8DEA824DDCFAE01942B3ECED0925C56D8E8D713484C0198F133FD6876CC7E88")
(digest-bit-test 29 #x10 34 "F854548650BD2EE462A221DF3F618A507CE737946BB6111BD10DF72AA519668B")
(digest-bit-test 29 #x08 34 "CE7A1418551803A588EBF7AB1874E803918461518052667CB3E827A2C331A1B1")
(digest-bit-test 29 #x04 34 "1AAF9C4E2210C62DDF85B8A17DE97A11A8FDA73F50EF3EB091905F4725C01890")
(digest-bit-test 29 #x02 34 "8C2BC5F4A7F1A04838B8CECA0FE1B2138298CB3E9EE8E9F3D398B9386C0EA0DC")
(digest-bit-test 29 #x01 34 "883F6A2B2F5F3CE3D0719327C32BD7FDC3678F30B7C0E6C9B646E8F255B24C6F")
(digest-bit-test 30 #x80 33 "97240AF3BB1ED0F4C40909902B619CEB345EBEC32FCE1A76778582F769DE5F08")
(digest-bit-test 30 #x40 33 "2E71DCDD0C32DB17D1B1A8E6CC4DA8C09069AD7FBCE3660C038A629A54CB9E33")
(digest-bit-test 30 #x20 33 "D73D0C259438C01E5C623B1AB558AFE7E158950A3FFF48028E9054B6A294C879")
(digest-bit-test 30 #x10 33 "9F44A53FB13DE79E4F851DE224A20905A471E4D5495BCE832BE55A72A3A9859F")
(digest-bit-test 30 #x08 33 "80577CB7D412273020AEA6986F7E7B82096C2C191D4F3A2641C1AAF854E35A40")
(digest-bit-test 30 #x04 33 "DB93C3458D36F2800D2FB03957237190EE0FE64D35978EE7A822B272BA1DF978")
(digest-bit-test 30 #x02 33 "E548EFC34D2F70A0C730679057A4CD9A0DE2FC57E804F970B5919F946A61FCF0")
(digest-bit-test 30 #x01 33 "060FD02BCB60AE26536EB1A50A25571E9712C6106AD966452FE5C40602BD9186")
(digest-bit-test 31 #x80 32 "D3321F207A723107AEA06879AF488D83AB99EFC7DD6AD75D2356857CBFE4D718")
(digest-bit-test 31 #x40 32 "1E8A162B8929F27D4EE0BC6DE76C4D186EE5B7500A658EE13BFB4429F596FFE6")
(digest-bit-test 31 #x20 32 "1CCA23F135D6A051C5BCEAB95D8BBC3983A92021783FFE3540C209F682C5C93B")
(digest-bit-test 31 #x10 32 "E7125019709757B38FD5429EB0608C03E8D939FC721345643C5085822A3FF424")
(digest-bit-test 31 #x08 32 "2E65FAFD44BB10B41DA06D445673A68F2441D68DAE0CBF1BA7C62C75E9FCDD5D")
(digest-bit-test 31 #x04 32 "342B4F26D63BD11D5AA83A658B40191D6701CEF38D0F4001116B4358FACF2B58")
(digest-bit-test 31 #x02 32 "60066741365E8D416FF884AF7E3EC36CC209B6CD6CEDCE891A0B4CB88DCD1C7F")
(digest-bit-test 31 #x01 32 "58E8F2A1F78F0A591FEB75AEBECAAA81076E4290894B1C445CC32953604DB089")
(digest-bit-test 32 #x80 31 "8F6DAB338DE16AB12E496BF52B51D00EE1358741033FA19A8B6E3736A9E55357")
(digest-bit-test 32 #x40 31 "E7AE17EEBECD2650630473FAB6F5716D80DB238BE1F09FA93DC004942255C08B")
(digest-bit-test 32 #x20 31 "0B41C730A71A17718B3E8EFBF741918BE3637A981F4838835F76289C00E424B9")
(digest-bit-test 32 #x10 31 "A44A029E04493B8D2FE7893391C2B3CEEFEC1603C585AAD6203F2D14E07BFEAD")
(digest-bit-test 32 #x08 31 "5AC78D953211AA822C3AE6E9B0058E42394DD32E5992F29F9C12DA3681985130")
(digest-bit-test 32 #x04 31 "D647EB2598D33D7216256356596D29CECD31C1BA7A7FF25CCB5BE4A453410B9D")
(digest-bit-test 32 #x02 31 "1205F4789155711E2542DBA1A64D226626FE3EB43BAA854752D0B59077E010FC")
(digest-bit-test 32 #x01 31 "CB592844121D926F1CA3AD4E1D6FB9D8E260ED6E3216361F7732E975A0E8BBF6")
(digest-bit-test 33 #x80 30 "DA8358584A629196115D53EB6EE0BD6F821F5E7D8297753C5EA59767B5888EB4")
(digest-bit-test 33 #x40 30 "E16FD8C842F53FCF9167ED4153CD33194F93BC52416883CBC70107F5A5B542F5")
(digest-bit-test 33 #x20 30 "3C4FE9CBE1ECF2651A542854BFE633C83322A884B715322F0046F6A1FA4A6364")
(digest-bit-test 33 #x10 30 "9697FABFB4CFAD42B06912B49C656B820455F42B0E1A99D050857A565BB0719E")
(digest-bit-test 33 #x08 30 "7C1726D8B205E09F946FC3E7A314D07C179F99F6825846635BC166C47E00AF1E")
(digest-bit-test 33 #x04 30 "33333D249B819A6B651045B45B87793EEBFCC3EAD2C2CBD8559F8F636942D390")
(digest-bit-test 33 #x02 30 "0D75EF205E037BEDC1D5462A17F2DCDBB408250A2273B9A8987963D76067CAD9")
(digest-bit-test 33 #x01 30 "92A91D56CB5A0D8329C902C2A61D455DC11C2ACE741443069985D8A8761F0892")
(digest-bit-test 34 #x80 29 "9AF21D56439B23C2C133142C9D861AF93E56A9F5066050E84D015DB3BC9DEFBA")
(digest-bit-test 34 #x40 29 "D8EC24EC81F44E472050EC178E2B029F8E71D965F4B30D4B6BC0CE1CFBAAFA43")
(digest-bit-test 34 #x20 29 "C601F7F144E0E91FE0D81004C2CB6D12003A4D28357ED171AE2695C10EAF4367")
(digest-bit-test 34 #x10 29 "1E474F64386EB2728D754ED431DEEE8FC28634B60369187CC67069C9BAB50856")
(digest-bit-test 34 #x08 29 "CD26546D8F54998BDF990406D2DC61541D271278847D6CF7C0129B27E18821F7")
(digest-bit-test 34 #x04 29 "589F68DCFA53A2400B5BACE56DE6B945B657D42799CE5DE97535B956A9A7E434")
(digest-bit-test 34 #x02 29 "7DED0DE807F13086380A18D8AFC6F91D8B27C106A3192D1A63E5EE95999D11A5")
(digest-bit-test 34 #x01 29 "494CF88F702C3B6E60755D34D21B752F1B2DBDBAACDDCC39981EEBAE1A8445F9")
(digest-bit-test 35 #x80 28 "6A98BDF7ADDEF8AEB8C318585BFC9D0DBE218ECF02B6A58FD02F05F8B09FB865")
(digest-bit-test 35 #x40 28 "3CBF295A61FCF0DBE7DF7D672662CBDE5EAD4D1797BDD145075D0075BF8E8C27")
(digest-bit-test 35 #x20 28 "1440225FDE337167D85AE4B4799CCF5D3D2DCF9F5200F5368491B76A987A424D")
(digest-bit-test 35 #x10 28 "97FEBBCF075BA9235E9DFB80FED98C4D208FDF1E99F6DA6427343A549FA281D0")
(digest-bit-test 35 #x08 28 "35F9358538FC9370A59EA87EC7C267F574E67006C099828AC510C19C2ED39B31")
(digest-bit-test 35 #x04 28 "81F6394551E870E956AB91C8FD6D50A84CDC53809925DC78CEE6362959B7F6E8")
(digest-bit-test 35 #x02 28 "7CC54262D86AFF027845EE4758DAFA40B7809FBF46960041F6AB252403A9B603")
(digest-bit-test 35 #x01 28 "8860B1848E82659A8F8DD96561A670004B51648B517AADC8FCC4A6823C802799")
(digest-bit-test 36 #x80 27 "C648B6AF1B5F45B8A3A63EE029DC9F631B0A0A196C8F6C8F99E87310FBC271A3")
(digest-bit-test 36 #x40 27 "28F186B361C89BE6A1A5365667D49291B4F393D0900864BA55B94A3741A48C8C")
(digest-bit-test 36 #x20 27 "F6435CE4D01839ECB6673D8F2E8A194A8A42CD9E925982971104ABFA00C668CB")
(digest-bit-test 36 #x10 27 "1F53BCB0275B1C5743DD0DF57F6ADC628F154823331CF7305889ACB2EFCC1964")
(digest-bit-test 36 #x08 27 "AA90D0333AE3D6B268BB37339E2B3C9EB488819494136F9BB34B55CD5A499418")
(digest-bit-test 36 #x04 27 "A8A9CD859CD274995D1D63A8A074486D7EF03D1F2D46C90512E10D7BCE19876B")
(digest-bit-test 36 #x02 27 "4F66715E94649152F5A5FE48766BAAED641E04D18099F95078207DCB9BBB247E")
(digest-bit-test 36 #x01 27 "0FA87652EFD33C81D12AFCD1ECEC26570B5095EA17830B3A86287151D952BA1F")
(digest-bit-test 37 #x80 26 "B78517D559679DD4EDE0706F7FF6DD111E73A764809D6642BADBE2DBE0879F80")
(digest-bit-test 37 #x40 26 "A1DB1738D7FE28AF0639A2D08D788DBA39BAFFAD8A6F99EEA4CDB395C5D97BF0")
(digest-bit-test 37 #x20 26 "4CF0061C7F2059A2225AFEB31397D54FA6038CAEB09C484F998A29CA6B9D6F71")
(digest-bit-test 37 #x10 26 "50C15DE2269A9DE0BE4B4CC549D71D28C8E62ED2889B2997C959EB7320ADB02D")
(digest-bit-test 37 #x08 26 "94494316271E05F1E9BD2663E53D5F424725FCBCF661D8C280C10BA948C44E57")
(digest-bit-test 37 #x04 26 "D02CEF06B23C7C5E2D6696488CE3C389C8D671873FE25684553B6629F0F16072")
(digest-bit-test 37 #x02 26 "8010AFB151BA35E1F5C0B5EA1F0A202C017332B225F47A5872E87B1E7106AFD9")
(digest-bit-test 37 #x01 26 "7C7E1E7D7A3C48160E90DF669E05CD638046097ECF515646EC726180476F6FDD")
(digest-bit-test 38 #x80 25 "F3A7AAC9F3257C72EB287BC300F31388CBC670DD756E6121F4FAA148E5E3C283")
(digest-bit-test 38 #x40 25 "08FDAAE9628BB9AFFC502F3A3752548338C9CB644061CDF32434FB5F129BF824")
(digest-bit-test 38 #x20 25 "65913DA1B10BED73812FCF578DCBAF3E7B269F42A3E17781906C09CFD3392984")
(digest-bit-test 38 #x10 25 "A465333C4427242A63D08044D70294AD3EDA1A9C257940F2138844C54225CA4E")
(digest-bit-test 38 #x08 25 "A603EC80BD955208466738CAEDBB4025506C22616D4F2CD44F575073A1B0D821")
(digest-bit-test 38 #x04 25 "B5BBE2C5E1A5672D4C6209FE64DD62D914711C63F383FFBFAE72DC028E57B7C1")
(digest-bit-test 38 #x02 25 "90FB5D3B763D607DBD27F1C9A1031C77904FFE48F7A8262C1334C5A731BF567C")
(digest-bit-test 38 #x01 25 "D4B41E7CE54C93E9C672635478360026E43160A1CEB97C6917DEB630A541C307")
(digest-bit-test 39 #x80 24 "C1E2D0385C7067249C5B9C41ECF0426A599F362CA10190FC7223A0B144F493C6")
(digest-bit-test 39 #x40 24 "0B45FA27060C1213323C6654D9663EF4D5402D3B99403415C15D9B8D5D0567F9")
(digest-bit-test 39 #x20 24 "4C0DB82FF0359478B5C97C871B14E947F62D548F16B7AF8B9EEE76A27C1B06D6")
(digest-bit-test 39 #x10 24 "3D9A7039B8EB82E9A264C318F3CA7C8DC7DEFF95E90BE79C40323B9472711AC8")
(digest-bit-test 39 #x08 24 "B73D29485284C78F56EAF2E6F72FA354556DBF473B2AB25B1A7B842C2B662692")
(digest-bit-test 39 #x04 24 "4F9E4F76899721A86406E6B4574EB59613751CABBEE8E2928B2FA9D3341B3981")
(digest-bit-test 39 #x02 24 "5994BC49A92091DCEAF14F434F7E7F66F9DBF77BDB85615E9A6D93D6858B92C5")
(digest-bit-test 39 #x01 24 "D7272D936F77A9BF69EA39529E9A44C2C9FF052C3E495FB085B9E4AB4B917056")
(digest-bit-test 40 #x80 23 "812CFCA1E2D5C0D13E2C48B589FC64401F6B85F00F03E005D486AEEDE95079AE")
(digest-bit-test 40 #x40 23 "126A3867926080B92F0EC0F62A8AF4F8247C5DEC4B46E152C14486F66BEBF7B0")
(digest-bit-test 40 #x20 23 "24ABE02E6D5255A33125BF5FDCFF2632D671C7F009A0B85B3DAB499AF735EFEE")
(digest-bit-test 40 #x10 23 "E8DDF8BCE2F4FAB674BA59532E88E53396ADFAE195420771FE83BD97D09EEBA6")
(digest-bit-test 40 #x08 23 "722278F46850DE762138E2F2C56BF60C07827F46E0AF48C7D6E7925327799B9F")
(digest-bit-test 40 #x04 23 "28A226B83CB5316DE65E0E4CF318A836BA0620D7B35F6AB58D18EA44FF2C52A2")
(digest-bit-test 40 #x02 23 "BA4426A74EAFA3EE62AC4F45923548B9C8D4C6CE956C8FBE264EEE1FA3442C34")
(digest-bit-test 40 #x01 23 "1919C892CF10178DDE4A38102271B31BD490EC4B40F35EDB9FD80E8E1671B0F1")
(digest-bit-test 41 #x80 22 "5254CFDFD49C0F6B02B0B55D92079A3609D7430BA70DC0DD816B3784D0427910")
(digest-bit-test 41 #x40 22 "A9236785D72393A24EF215A461FF938B2D9F3B8CB27E1A6FF63805D5B138AA24")
(digest-bit-test 41 #x20 22 "D78D7D639249C7CD98FD3AD882C0F98C77976824DC4D8A590D80A26148AEE507")
(digest-bit-test 41 #x10 22 "5B632F5763688227B5DF59059F3D891F00C63D23E5A895E929DE75D8AA83D05D")
(digest-bit-test 41 #x08 22 "ED269E2FF14E828DD77F018700B0A460C15CC2D4AFBF001100BE8F38D8ADAFF3")
(digest-bit-test 41 #x04 22 "62134F47786E53679ABEBB061CF4BE743A3AAD9108B723B8ED4BEF93CCE7D253")
(digest-bit-test 41 #x02 22 "C31609F406FEB281E563F0D3BF817875D11F818CB1E38D02603DB390BF66E9BE")
(digest-bit-test 41 #x01 22 "0C242E5FD9FA0F2F5FA576955E056419F9AD77E3EB3E03C5F151256C9B4146AB")
(digest-bit-test 42 #x80 21 "213DA75407E6473CFE0EB8656ED03D6DCA533ACA4FF6D3F2F97127A0ED321C73")
(digest-bit-test 42 #x40 21 "AD111379642FFEE68C7E03C4B4BD71D73D84DAC086C961CD22BF115FF7A0E4E8")
(digest-bit-test 42 #x20 21 "06DB78D12149C22D8014A669F49192B07D011A225B874BEE0125876F1DEC3374")
(digest-bit-test 42 #x10 21 "79B5CCAC28B1D1BBD038C6EE73057471657776F147727FB3669CB4E769C683B7")
(digest-bit-test 42 #x08 21 "8AC5DA288A81F71B7531F8824DCC409AFFCB7E88215EAA398D9B4EE0A2A3FAFE")
(digest-bit-test 42 #x04 21 "2F2D4540708C98DA1CA6F1A05DC23FE66F5C3AECDF7265F76816E2337C37D3F2")
(digest-bit-test 42 #x02 21 "EC035986496596EB220AE5B82F1A2AD5BB9139F80D12259D3E19D5623AAF8487")
(digest-bit-test 42 #x01 21 "67AF511E83F23FFAE30853CEF535AEB5CFBF8EDFC0F4C7E07EA32A921DAF1269")
(digest-bit-test 43 #x80 20 "7C396CBFBD27929ED330F5ACDDF20DAD26EB6DF9D56A7066CEFFC790682B0DC5")
(digest-bit-test 43 #x40 20 "A27224D6E741AA47A7CCED9C4586658DAF47728120D00ED04EBD719B1A5B1E71")
(digest-bit-test 43 #x20 20 "784B9E6816D4558A109828B534CD41C3B464B3C3265C93D79E45F1E486780079")
(digest-bit-test 43 #x10 20 "D77673ADFAD62C3DCB3C38A2C2EB12B7FBB69FBC721B7E1F16FCFE38BA687912")
(digest-bit-test 43 #x08 20 "A48E2627C92ED81CCAE51F9DCBA5B8BB7A318A2CD41A62887BF2630AB439B2D7")
(digest-bit-test 43 #x04 20 "475B05FC929E6726C09ED9CD9B445C4DC22BFAA7D79606F72F82133D9F527215")
(digest-bit-test 43 #x02 20 "4FFC835D8AACF34C1AE717151522EAFC519E31F413A969A4D58492B73E706AC8")
(digest-bit-test 43 #x01 20 "4DD7A0B31BC12558B65CF95432F8FC74A857DB1B0B388E4A86147E5FE0708FFF")
(digest-bit-test 44 #x80 19 "A911B98D9D7C6E46639356CCAA0823B6C606F2809E6B2CAEFA55297EFAF78678")
(digest-bit-test 44 #x40 19 "5E6D6133DF09E9367F607F9469292FF688250261E8D7BED7DB369AC7BF8E5664")
(digest-bit-test 44 #x20 19 "FB10D55C127E43A07528FBDB9C0F0ED0A1AA6820AEDC869C8859D2AECF366220")
(digest-bit-test 44 #x10 19 "DC67039743BC2554E64327EB0CCC7B3FA77E7C9896E4423D54C851699E3CB121")
(digest-bit-test 44 #x08 19 "1F1644FCD09BB5E4BD2B818BAF01F4D4A38AD41524EC3A5729FFDD44929AD1E9")
(digest-bit-test 44 #x04 19 "7D42FEE879C24591600C9EA01795C34C7AFDEABD64733F1A5A0A093286370519")
(digest-bit-test 44 #x02 19 "943801FBC4B5C4BD79E8D39E4097AF6F258A6BB23657E0EBFFCD07BF2C434CDD")
(digest-bit-test 44 #x01 19 "4E05F0C58901316E1A11CED54910AA357C0F12109F23E6D1102AA1AC249EE34A")
(digest-bit-test 45 #x80 18 "A4D7A763848B6FEBDD5CC4D0EEC1E969DA0C140F2EB33AE88019F4A09D6DD1FB")
(digest-bit-test 45 #x40 18 "F6148643902CC9E2AECA25F4885256E46AD598FFBF8E0D0E8FA2DC4D5C8FE5BF")
(digest-bit-test 45 #x20 18 "CFEE5E3D7955BB67BD3E80F33FB41743020EB0BD8A86F8F47662F86A0A820ED2")
(digest-bit-test 45 #x10 18 "1F1FCDD5C3D1E625FEB61F7EBCEDE5A93DB10D1560149025830E35F0B21FCF96")
(digest-bit-test 45 #x08 18 "0EB66674FB59D6C623D8604215773FF78F888A9BF456A060D24E70F748B20FD9")
(digest-bit-test 45 #x04 18 "A8FEEC51995C47671873A600D6ECEBC756583FA2AA08FB434D0183063B9620DB")
(digest-bit-test 45 #x02 18 "ED45C4E0EF73A84A36C1B0CDCC31B739F98B3BA5ECF1306AB1C59FEFD6B02CF5")
(digest-bit-test 45 #x01 18 "C17A382B566D1665B65F6305F34AFFB956D1C076E19694301C97F561DF9F3DEA")
(digest-bit-test 46 #x80 17 "1D377A06F742A950E4063095ADD6635D4FF1177A448FE9697348A8A526B858AE")
(digest-bit-test 46 #x40 17 "71DC2BF5E3FAEA688971561A2E55B4C33CD7F63C053136BF85BBB87252622A33")
(digest-bit-test 46 #x20 17 "4786FF7DE50873721127AB8BFA27D806CE281F6C3C7751B2BDF4EDFD4890731D")
(digest-bit-test 46 #x10 17 "F28E22B8ECCBDD26D017E78ACAE4C6965793F13ADB7B27F88DD0310C1206A0F0")
(digest-bit-test 46 #x08 17 "BCAC98BA4FEDFC238B064FCF828EEBACE51492F58FD3E4E199B85EDE0D001491")
(digest-bit-test 46 #x04 17 "229192E93F7FD0D8A2521F86DC3157D2620ED8B97F0318330B884E998BEE064D")
(digest-bit-test 46 #x02 17 "C6ABF4C99CF38E7ACD75C212014B7EFEE61649609B7E513263EF110B9248B177")
(digest-bit-test 46 #x01 17 "2FFAE8AFB20273084E0539E70735D2014D1F2DB20249A713548566761308DDA0")
(digest-bit-test 47 #x80 16 "AB7DF8EA59C3590468346BC31A91ACF118B36C4A40186A3D7573A39B18C63B18")
(digest-bit-test 47 #x40 16 "3238A57E63BECA63A8A3B7C0CE1E5B44B6360D9FD4515975B7A5E4F311A9D895")
(digest-bit-test 47 #x20 16 "D75AD243CED8727D6477CE620589DD14916C8362E452874F6D9AF0E04071B614")
(digest-bit-test 47 #x10 16 "92A8041693260B1215BDD88CE79553B59CB8154859FA6A180A560056DA3F657E")
(digest-bit-test 47 #x08 16 "E4513878BE62ED738445AE3C4EF5D425F2CD623333553606F32F4AE634FE35E6")
(digest-bit-test 47 #x04 16 "D55567F34047852F30E1AC975F46947A4FB29D4FC24047CF425FC6752335DD88")
(digest-bit-test 47 #x02 16 "F278DBABBA0EEB584EF3F89C5607FA7FE10EC8C7A6E2CFE600D14E456ACD6096")
(digest-bit-test 47 #x01 16 "DE7630EFB0AEC1EFD89DDDD9E64A7A34FF13E4B800DEEB0E3C484E87BCD603DB")
(digest-bit-test 48 #x80 15 "22BB5096E785BAF84A5BE874F3D2D8B145391EED10F97BCF072B17D86FE9F826")
(digest-bit-test 48 #x40 15 "E15A3246FD61CDE5D29F964B7814AB43CFD26715C8D5BDDE9F0812522402C6B4")
(digest-bit-test 48 #x20 15 "118AA5245FE682EE6BF41D7F315312AF813E52FEFBBA752672688DC079298826")
(digest-bit-test 48 #x10 15 "FA349B2AA4A31E8B110EE18FD7B0A09816B86FD60ED1CD51FD201195D3DB2082")
(digest-bit-test 48 #x08 15 "E7DA8100F1ECFF9CB0C6E5D8859D341A621B246AD4AB6E73A6F772DAEE6105B9")
(digest-bit-test 48 #x04 15 "00CB8E080067507DE84E2155F89AAED4D65811DEA96E1B5C3CC3B220825BBA67")
(digest-bit-test 48 #x02 15 "C7369912A28787EAA421384E7526E59514244343797B53382EC3666AA8890D44")
(digest-bit-test 48 #x01 15 "A64EE51FEE0176641631EFAFDA9B15E216AF520E34864D3D56DE61484B1B2622")
(digest-bit-test 49 #x80 14 "92F95054F54A680DB4F9BF202D1594F3D13E8A765D8E325D1CF617F26F52E7F3")
(digest-bit-test 49 #x40 14 "8FFFA25B6CFB95912CEA1A1B3A279FC1BA2E6EF3CBE306931C724317CFE857C0")
(digest-bit-test 49 #x20 14 "9846ECD9BFFEA6595D453973869FE2DBAABF781D36A469C5D406DD0FE4234627")
(digest-bit-test 49 #x10 14 "4E6410AAC382596D41DB9EA85575D5BEF3627E9FE72FCD4116FCCCFCF3F960B4")
(digest-bit-test 49 #x08 14 "4BDF4C2B9E79E328A356E02DCACF42C8F76FEB61952B00F7610F065F01A7F902")
(digest-bit-test 49 #x04 14 "046A9807CF2825F157705E8344F9537633D79231DDBEE7F6026679D852F29A9F")
(digest-bit-test 49 #x02 14 "1620F6DA7BF96CDF28479D1A068331996A080AC81A957BB9BC129A61658E3A53")
(digest-bit-test 49 #x01 14 "DE7349763400FD3875C31C6B4821ED5A7C8EA4E3F9E2849B9BBE9ABD30E8DEDD")
(digest-bit-test 50 #x80 13 "24E2FF048DEDF95BE439D47BDAA89130F102378404DC2D2FDD02ECE754CF3B52")
(digest-bit-test 50 #x40 13 "47EAE793E6E32E05F8828F48DC539EB223C70630C9F8E52144DE3F951CB0A22C")
(digest-bit-test 50 #x20 13 "A5387811B871DB52E76CB69D5EFF524CD42BEDDC82711729D93F4594D7C5C4A0")
(digest-bit-test 50 #x10 13 "3C98724C667A7AC927F286F5FFE85DC351B7FD932260D6D9CA30DB690A86CD2E")
(digest-bit-test 50 #x08 13 "31E44F403C68BB77EA34FD30FB91083024CDD96CD468473D729370C0994EADEF")
(digest-bit-test 50 #x04 13 "3C9A94B82CC7275C4608D689640EFBE5EBCB1B15238B85CFF27503C0B9CD39F3")
(digest-bit-test 50 #x02 13 "9FAE95E5E0609E9B4C3B925A6BEDDE8C87A9881C59550E7223A85F1E95408033")
(digest-bit-test 50 #x01 13 "CDA993D45935655695061A1CC07D54FC65286457D08BFAF85D0CA926D7625C7E")
(digest-bit-test 51 #x80 12 "5130D53891A418323E485083E56D4A7B378EF832DB3642F762BC07BB34F836C0")
(digest-bit-test 51 #x40 12 "537F6FD91A596BE7D2EC3C702358382986EA0B05335AA53D0CCC017571A6A30F")
(digest-bit-test 51 #x20 12 "FA06E97F589D953982462FB433DB100B4040A95FCE8AA76F95DDED432EFF85D6")
(digest-bit-test 51 #x10 12 "2EC1D1A22B088C0DEEDA7195124509ADCE973FEBFA6C71A2F0B7232CFAA9AC05")
(digest-bit-test 51 #x08 12 "439E9948212A4445CA75DB98E16A2AEB0A172B725B827F039426996DB514EFA9")
(digest-bit-test 51 #x04 12 "54AF89824EBB943E84D59FBBF2A85B027201FE70FDE45894B1290A933705EB83")
(digest-bit-test 51 #x02 12 "2407BEF2180CFDEF90E12343A987E51DEBDF2C3CD0C32EB2808CCDC4B9E20F42")
(digest-bit-test 51 #x01 12 "6CA12E85BE251EEEAECBF45547E44B19132E011441B79853166D0CFA7CF7F7E0")
(digest-bit-test 52 #x80 11 "508CD52057F05CE892BD3A15802ED0FA5D99A4253E573B8D617A531DF991EB5F")
(digest-bit-test 52 #x40 11 "FD23E6436C2398DC876CD6F46B613B0C7F0D5F7CA0E6ACF30655EAF08E9060FB")
(digest-bit-test 52 #x20 11 "C207FEE5574A63EC63194FF22584D7E23106065832FBCD59D449C8A20F268C55")
(digest-bit-test 52 #x10 11 "27ECA978EB2EF8D12D6ACBD41DFAD9D4B8E1E7F853D0649D957C178D0598E15D")
(digest-bit-test 52 #x08 11 "328456E7CB682226F01A3B9F3D41DB7B8CF8676EB90F9864C2047EA7FB2832E7")
(digest-bit-test 52 #x04 11 "B1CCDAEF68845A4729D9EF7A227AF267102C99BE23F92DA1CDA8FBCF339B2DCD")
(digest-bit-test 52 #x02 11 "18BFEE62ACD1D325A51FF4FC3AE60AC8777B90A7ABA99B1AE2DA250E08E949CD")
(digest-bit-test 52 #x01 11 "88E443D409725A1CF6EFA8C464F32B1EEEB0B947C6F49B1DE41D60EBAA543BF0")
(digest-bit-test 53 #x80 10 "219FFE9FD558083698B35F6720D0B23B7A0B115ABC4339DEF7EECDB1F7D97A7F")
(digest-bit-test 53 #x40 10 "FAA5C13273BD9DAF3CF6BBAD62D86BE9B84705AF6BA677891E6049980FAA08CE")
(digest-bit-test 53 #x20 10 "D387434F43051B9423F308A48AB676BC5290BC5FA95E17C3010155139FD750C6")
(digest-bit-test 53 #x10 10 "E0B6B8F5BC740A55386609AF476150593646820D95C71B2706BF054A9B7D3C63")
(digest-bit-test 53 #x08 10 "0422011DEED253417DA288C5095FDE62C96948F62E07F13B5857A358252F4BAD")
(digest-bit-test 53 #x04 10 "232B4C03C1635E6408BA417DC91948D82409B207F26E25A0A519600EDC7E2ADB")
(digest-bit-test 53 #x02 10 "C65E004EB04929F47B1E2FA7103D2F1E230C7162192054386B02DD77182E57C6")
(digest-bit-test 53 #x01 10 "F597DFD2EFA07D8EF7588E9DD504CEF4F898EFAD18A85619C4C04163E9D1EB0D")
(digest-bit-test 54 #x80 9 "D7C0E8260510ECA4A1ECBFF9DC7A1AF7ECAF59808A1210C3B3E8F2584026FDA2")
(digest-bit-test 54 #x40 9 "70F6D9037AAEDEF997E9B66A0490F2ABC39B8BEE5A3144E6072303CA9BB187BD")
(digest-bit-test 54 #x20 9 "C4A05B60568B567234EA6F20E693C6209BD7C9FBB306A39F524622B8D7F395FE")
(digest-bit-test 54 #x10 9 "D8EF13F300E5FA1E0E22767AE7173B0153EE135EC079E04BE4809B2432FAACCE")
(digest-bit-test 54 #x08 9 "55E180F827E5F06C676E484F5F2F63DFB93435878A76323C4D0C34FD88358E3F")
(digest-bit-test 54 #x04 9 "E40DB410675118A5EBDC75A1B14CF8F0C797128C41C2166842653A4FDC29915A")
(digest-bit-test 54 #x02 9 "92DD5EC0B5EE9E18FC95EA4782DC915D14DCD14FC642332CEB5762745DD8A51E")
(digest-bit-test 54 #x01 9 "14E1C7A1DA58A7AEE509426BA26CE7C09389E2ED9823AF5B038FD1C30E8F5CDB")
(digest-bit-test 55 #x80 8 "342ABA7EE53C69E50361136EE1AEF59475C96B8ED7FAEB28A17248E5714C0C5A")
(digest-bit-test 55 #x40 8 "BBDF07F2860D530A4B76B5AC74BCCF468382530863D6948981561F7DABA4802A")
(digest-bit-test 55 #x20 8 "83E7562819609C2462DDEF13D4E8F74D8F42D4B1024E17B98309FF042A65681D")
(digest-bit-test 55 #x10 8 "B68D6416FAEBE43D60F0FAB60783EDDF0A31FE5546E007146C38E17580C998D6")
(digest-bit-test 55 #x08 8 "E7345EF688EDF71B70EAC26A766A8446CD580E38B755F9C1E041505C8EEE77A9")
(digest-bit-test 55 #x04 8 "5C5AEF56EED653B6EE2E0D6C58A8E2A231FFD07AA6DA82EFDE73B2394F299105")
(digest-bit-test 55 #x02 8 "731764E8F75664B3F84347FF7EB6CFDA709CE0F265FAFB81A3BA23F9437F737C")
(digest-bit-test 55 #x01 8 "ECDD9540F7B23A82A2CD80445660AAD39433383BF04EA8E0BDB50B4BFCABABB5")
(digest-bit-test 56 #x80 7 "AFF9039F2556751264116FB612088FB3E66640FAC1F0BC71E22BCC4F64626AC5")
(digest-bit-test 56 #x40 7 "B1858BA85A0B5DDE048EB5E258A87682BED3C112A9C6347D288F3288845DD117")
(digest-bit-test 56 #x20 7 "672D871CFFAD4A59EB5069951CEB3292E19A1EC9C5D566B0A5B98C92180C4E0A")
(digest-bit-test 56 #x10 7 "DFBFFE8649ACE8126F08EFBB7F9FCC09584EC2A2A0E75D58327F2959492F7A09")
(digest-bit-test 56 #x08 7 "F48907D7DA1A4E6F47237E9EFB9BD08E4DE0CE0A73A1377ACB6069E2770FE00E")
(digest-bit-test 56 #x04 7 "455E6801F3BE98F5277EBD80999063C5BC804401295C8241565FB328A39536D8")
(digest-bit-test 56 #x02 7 "BB50CD7276C60819B494898F3B63EA5EE44EAACD43B007A98991339A93727DB1")
(digest-bit-test 56 #x01 7 "4BEBA5E9BB868F0BDE0B9F79D3C64F482D8FD5C320DC08565768EC0480A25593")
(digest-bit-test 57 #x80 6 "1FB97BD48FABDDD8E31719FF7C09DDB2353A97327A719A76B223FF33FBBC1A70")
(digest-bit-test 57 #x40 6 "28E5FB6347D650C09F235C9DCEE735645CD41D3B3CDD81CE7E20DB1AF66C7904")
(digest-bit-test 57 #x20 6 "C524EE312054C3A68B870EC7BB9407BDDA56117DA591B4E4D97E1F53D525AF6F")
(digest-bit-test 57 #x10 6 "6805383B4845FFA3E610AD3C01D37A2FFEE55D36C134D65225F5897DB73B902E")
(digest-bit-test 57 #x08 6 "333F64A1FA700F2F471A991A8314FF0E8DE994CAFCDEA0A85A42B9180D15018E")
(digest-bit-test 57 #x04 6 "5E432F656AF89DF2E0EB02329E5470F8BCDEBFD21B629E7816CAA2CDD396CD67")
(digest-bit-test 57 #x02 6 "3FE7057CF28379E226F63C28DCF99F36BB219E2E94CB2246ECF193F6B12D676A")
(digest-bit-test 57 #x01 6 "A9094A4844DCE0EC574C6C12361375E9F2CE70FE6316D035EFDB36B3A84B8FA6")
(digest-bit-test 58 #x80 5 "2C8D11CBEEFA2CB2C51DF0D952A71933634F029BA08F42F503260122B6B3A942")
(digest-bit-test 58 #x40 5 "3E3E3873C86CF3B12459F31ABA192E825D47716EAC4063F599FC9CDDB0D5757C")
(digest-bit-test 58 #x20 5 "88F2145A165655CC7A41B2FF1E736DDA4A790ED77C1948642B1A6E1053F47697")
(digest-bit-test 58 #x10 5 "CCCC292262D66B7B90B122ECADFFA066C9101BD19AF6E361330A831F2C3C723A")
(digest-bit-test 58 #x08 5 "1895A190C644D7EC155568BBA539725711ADB9F9A17941CAC6BDC78C6440FA89")
(digest-bit-test 58 #x04 5 "293C690603FC720BBF011E5FEBFA602974585C41FCA59B009A090A348037795A")
(digest-bit-test 58 #x02 5 "B8A8839CDAC5B33F4A02FFD8F39F6EBA95BDC61B349F7E096980145F969D5DFD")
(digest-bit-test 58 #x01 5 "FCF0D9A814A86D06F64BBDA9913851C94FF6C20270256D9EEAA2C0EEF99C3BFC")
(digest-bit-test 59 #x80 4 "1ECC6DDEDFC81718E0646A86E2191E614A2CC7A54E90C38B893C61DE03016C92")
(digest-bit-test 59 #x40 4 "C9D9359E24690864B889B99B42B81DD598F4B849DBE8FF4E63FC3BF15C9F66FE")
(digest-bit-test 59 #x20 4 "9184476FEB6AE7D6B199D5C8EA8CE9C8B912CB4F24E15BF881F599335C9D306E")
(digest-bit-test 59 #x10 4 "E5AD5363B0FC4C49A93D8B3CFC90DE19D501645108A99BC90C6EA577C5E3BA3F")
(digest-bit-test 59 #x08 4 "6B605BF3FBB081A3AA39019EA4A8F72558E3E747B68080AC7ABB70DEB48EAD49")
(digest-bit-test 59 #x04 4 "1C107AE5077037B98E56F87E51461DFA8DB7808BC32FA870F85146616DD98E2F")
(digest-bit-test 59 #x02 4 "3FDD8713A8C9501E3CFDEB84F9F78F2E2030A7D0A34E98F22BC6F6A1E53934DB")
(digest-bit-test 59 #x01 4 "A054CAF60CDB866EB03A3AA45FADFE096E2E0A0C6FAC782258FF9EFE9DFBF359")
(digest-bit-test 60 #x80 3 "58D962AFA1A71EBEA20D8B5521569B9D3DDE771D269AF172AC2CC08D2FC3D9F5")
(digest-bit-test 60 #x40 3 "82C146EDD011B9E9C5B1E2EAFB88EF586249E51FF0F58DBAEAAC7C660057B352")
(digest-bit-test 60 #x20 3 "30C0A2843400EA5AC96803D99ED578959440E3385877A325D5603FBE9C12EAA5")
(digest-bit-test 60 #x10 3 "EE7B7F22E7CFFA37AB1E12C8493A95A6F287BED0430C4C1C0910C59989BC708B")
(digest-bit-test 60 #x08 3 "A085B98CEF63C444EB74B4560C0F9DBB5645CF1E31451A227FDF8E72D25EEF16")
(digest-bit-test 60 #x04 3 "41ED994FD3222CFD5648FE9068875836C10F04B34DA1B8D2053EB4EC7E5B38AE")
(digest-bit-test 60 #x02 3 "F366F82B0177478C240783195F72602E8B14B8F4F683508EF88B05682D8ED539")
(digest-bit-test 60 #x01 3 "957329CB69DD4616DA9B2483FC83AFEA169C0B95939A930E68E913B98DE4B392")
(digest-bit-test 61 #x80 2 "D6D3A64A06ABAEF3A42FD53EDCABF7B48C5B32C6D71BCEC9B2655583E03E2C98")
(digest-bit-test 61 #x40 2 "B90E5EAEBCE454B9B709B272BE8678ED28209B984092B32CE6CAF37F2496B19D")
(digest-bit-test 61 #x20 2 "B75CF8AC5F8ACBC504DCA1308B12424E149CABF654765B2C0FF1658D2F8F0810")
(digest-bit-test 61 #x10 2 "3E9397294BAF56317BA92FEC1ECA9B30BF17FA7FB63E13A47DAEB4C1AA6977D7")
(digest-bit-test 61 #x08 2 "AA968B00E653CC673E3632610627D2BD84D2334E6ACB10DC45C1CDAAA110D7A8")
(digest-bit-test 61 #x04 2 "6E15538FDE8C96C17311F4086739E5C252B9A2ED0DC9727BEAC4D6AD2DFFD81A")
(digest-bit-test 61 #x02 2 "8EE86705EA4EF1129FFD437017AAE253A4A5954CD96840C03BDC52D1DB58880A")
(digest-bit-test 61 #x01 2 "E3D77831072D9A49EBA90285BD68C35139A51DF1F63842DD0F890EC909DEDBF2")
(digest-bit-test 62 #x80 1 "C288D3BF4EC0D17C05697A8677D9D796F7173987D2F982C5F72D0E602A2C1C4C")
(digest-bit-test 62 #x40 1 "243E5739CC3C847AFD65CB07964C2AE60033905F00C7D0E9317B256C52A327AA")
(digest-bit-test 62 #x20 1 "154F8FFA5A8E603549964501A51C9697B8B87BF7F38053893CC1C1F3C4817069")
(digest-bit-test 62 #x10 1 "CF9983A26C657C3899A6BEA4E2D4D3786AFCC99E303D40124ACE80478003B9EA")
(digest-bit-test 62 #x08 1 "876ABF7FF3A779AA651BE6BB6EB634E4F1A008AD167B1C6EBE416232BE5292CF")
(digest-bit-test 62 #x04 1 "4AEAADDD52558BB08EF7DD6C2EFDCF6FE7E2A1AD932508CC7C739E3D87F3AF3E")
(digest-bit-test 62 #x02 1 "C448E03A131A247C6907735D0090F118FE56D43E645B9C24ABD2592B5D758DDA")
(digest-bit-test 62 #x01 1 "D3817E5A0D06258B73CF6D4952C64485B004B6B0F9ADCF1A6D63E6D8AD968DBA")
(digest-bit-test 63 #x80 0 "ABD41900B8BB0389958B0F05B3A97D21D626EF93015E02B66272EF55BAA4FD1B")
(digest-bit-test 63 #x40 0 "A86652085375A2978F419118AA9DD3CC3174F469921E5C2A2E2F236F16F99560")
(digest-bit-test 63 #x20 0 "4D38C43A7F2AFD6F005B5E73AC44C12F96E4279BFC627DF441B3CD0FB81E041D")
(digest-bit-test 63 #x10 0 "9B10B02AAA22E1640B1D8938C669F8EA9CA4B55D1F0A7C484E1AFE46FA0BCBFE")
(digest-bit-test 63 #x08 0 "37F4EBBB6F63191FC34003C2EE3CD27476FD40BDC50C642A55F47A578BAA2B12")
(digest-bit-test 63 #x04 0 "517B7AF2368FE450DB775DB95CC0745D9FFA7CB26CE7D5922BA01EC50A2C7000")
(digest-bit-test 63 #x02 0 "BDC9BD36AC7F258351C81A3155A19EA5837B6EF164074F0189D876A5EC17F920")
(digest-bit-test 63 #x01 0 "90F4B39548DF55AD6187A1D20D731ECEE78C545B94AFD16F42EF7592D99CD365")
