/*
 speech-events.c : speech plugin for irssi - event handling and speaking them

    Copyright (C) 1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <irssi-plugin.h>
#include "speech.h"

PLUGIN_DATA *data;

static void say(gchar *text)
{
    gchar *p;
    gchar *str;

    /* remove non alphanumeric characters.. */
    /* Might be a better way to do this :)  */
    str = g_strdup(text);;

    for (p = str; *p != '\0'; p++)
	if ( ispunct(*p) )
	{
	    if ( *p == '\'' || *p == '.' || *p == '!' || *p == '?' || *p == ',')
		; /* do nothing */
	    else
		*p = ' ';
	}

    text = str;

    str = g_strdup_printf("(SayText \"%s\")\n", text);
    write(data->handle, str, strlen(str));
    g_free(text);
    g_free(str);
}

static gboolean sig_privmsg(gchar *text, SERVER_REC *server, gchar *nick, gchar *addr)
{
    GString *data;
    gchar *params, *target, *msg;

    params = event_get_params(text, 2 | PARAM_FLAG_GETREST, &target, &msg);
    if (nick == NULL) nick = "server";

    data = g_string_new(NULL);

    if (*msg == 1)
    {
        /* ctcp requests / action */
        if (strncasecmp(msg+1, "ACTION ", 7) == 0)
            g_string_sprintf(data, "%s %s", nick, msg+8);
    }
    else if (!ischannel(*target))
    {
        /* private message */
        g_string_sprintf(data, "%s sends message: %s", nick, msg);
    }
    else
    {
        /* message in channel */
        if (ui_completion_msgtoyou(server, msg))
            g_string_sprintf(data, "%s says to you: %s", nick, msg);
        else
            g_string_sprintf(data, "%s says: %s", nick, msg);
    }

    if (data->len > 0) say(data->str);
    g_string_free(data, TRUE);

    g_free(params);
    return TRUE;
}

static gboolean sig_print(SERVER_REC *server, gchar *channel, gpointer level, gchar *str)
{
    gint loglevel;

    g_return_val_if_fail(str != NULL, FALSE);

    loglevel = GPOINTER_TO_INT(level);

    /* say only channel messages, the others are probably meaningless.. */
    if (loglevel != MSGLEVEL_PUBLIC) return TRUE;

    str = g_strdup(str);
       
    say(str);
    g_free(str);

    return TRUE;
}

static gboolean sig_notify_join(SERVER_REC *server, gchar *nick)
{
    gchar *str;

    g_return_val_if_fail(nick != NULL, FALSE);

    str = g_strdup_printf("Notify: %s has joined IRC", nick);
    say(str);
    g_free(str);

    return TRUE;
}

static gboolean sig_notify_part(SERVER_REC *server, gchar *nick)
{
    gchar *str;

    g_return_val_if_fail(nick != NULL, FALSE);

    str = g_strdup_printf("Notify: %s has left IRC", nick);
    say(str);
    g_free(str);

    return TRUE;
}

void plugin_speech_events_init(PLUGIN_REC *plugin)
{
    data = plugin->data;

    plugin_bind(plugin, "event privmsg", (SIGNAL_FUNC) sig_privmsg, FALSE);
    plugin_bind(plugin, "print text stripped", (SIGNAL_FUNC) sig_print, FALSE);
    plugin_bind(plugin, "notifylist joined", (SIGNAL_FUNC) sig_notify_join, FALSE);
    plugin_bind(plugin, "notifylist left", (SIGNAL_FUNC) sig_notify_part, FALSE);
}
