#ifndef __PLUGIN_SQL_H
#define __PLUGIN_SQL_H

typedef char **SQL_ROW;

/* Select database to use */
gboolean plugin_sql_select_db(gchar *db);

/* Makes an SQL-query. Returns the SQL-result set (NULL = Error). */
gpointer plugin_sql_query(gchar *query, ...);

/* Gets the number of fields queried. (-1 = Error) */
gint plugin_sql_numfields(gpointer res);
/* Gets the number of rows queried. (-1 = Error) */
gint plugin_sql_numrows(gpointer res);
/* Fetches the next row (NULL is error/end of list) */
SQL_ROW plugin_sql_fetchrow(gpointer res);
/* Frees the result set. */
void plugin_sql_free(gpointer res);

/* add slashes before characters '\" - you need to free the returned string */
gchar *plugin_sql_addslashes(gchar *str);

#endif
