/***** jack.udp.c - (c) rohan drape, 2003-2004 *****/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#define MAX_CHANNELS 32
#define FAILURE      exit(EXIT_FAILURE)

#include "byte-order.c"
#include "file.c"
#include "jack.c"
#include "memory.c"
#include "network.c"
#include "packet.c"

typedef struct 
{
  int buffer_size ;
  float32_t *j_buffer ;
  int fd ;
  struct sockaddr_in address ;
  int channels ;
  jack_port_t *j_port[MAX_CHANNELS] ;
  jack_ringbuffer_t *rb ;
  pthread_t c_thread;
  int pipe[2] ;
} 
jackudp_t;

#include "send.c"
#include "recv.c"

void
jackudp_usage (void)
{
  fprintf ( stderr , "Usage: jack.udp [ options ] mode\n" ) ;
  fprintf ( stderr , "   -b  Set the ring buffer size in frames (default=4096).\n" ) ;
  fprintf ( stderr , "   -p  Set the port number (default=57120).\n" ) ;
  fprintf ( stderr , "   -n  Set the number of channels (default=2).\n" ) ;
  fprintf ( stderr , "   -r  Set the remote addrress to send to (default=\"127.0.0.1\").\n" ) ;
  FAILURE ;
}

int
main (int argc, char *argv[])
{
  jackudp_t d;
  d.buffer_size = 4096;
  d.channels = 2;
  int c ;
  int port_n = 57120 ;
  char *hostname =  NULL ;
  while ( ( c = getopt ( argc , argv , "b:hn:p:r:" ) ) != -1 ) {
    switch ( c ) {
    case 'b':
      d.buffer_size = atoi ( optarg ) ;
      break;
    case 'h':
      jackudp_usage () ;
      break;
    case 'n':
      d.channels = atoi (optarg) ;
      break;
    case 'p':
      port_n = atoi (optarg) ;
      break;
    case 'r':
      hostname = optarg ;
      break ;
    default:
      printf ("jack.udp: Illegal option %c.\n" , c ) ;
      jackudp_usage () ;
      break;
    }
  }
  if (optind != argc - 1) {
    jackudp_usage () ;
  }
  if ( d.channels < 1 || d.channels > MAX_CHANNELS ) {
    fprintf ( stderr , "jack.udp: illegal number of channels: %d\n" , d.channels ) ;
    FAILURE ;
  }
  int recv_mode = strcmp ( argv[optind] , "recv" ) == 0 ;
  d.fd = socket_udp ( 0 ) ;
  if ( recv_mode ) {
    bind_inet ( d.fd , NULL , port_n ) ;
  } else {
    init_sockaddr_in ( &(d.address) , hostname ? hostname : "127.0.0.1" , port_n ) ;
  }  
  d.buffer_size *= d.channels * sizeof(float32_t) ;
  d.j_buffer = xmalloc ( d.buffer_size ) ;
  d.rb = jack_ringbuffer_create ( d.buffer_size ) ;
  xpipe ( d.pipe ) ;
  jack_client_t *client = jack_client_uniq ( "jack.udp" ) ;
  jack_set_error_function ( jack_minimal_error_handler ) ;
  jack_on_shutdown ( client , jack_minimal_shutdown_handler , 0 ) ;
  jack_set_process_callback (client, recv_mode ? jackudp_recv_process : jackudp_send_process, &d ) ;
  jack_make_standard_ports ( client , d.j_port , d.channels , recv_mode ) ;
  xjack_activate ( client ) ;
  pthread_create ( &(d.c_thread) , NULL ,recv_mode ? jackudp_recv_thread : jackudp_send_thread , &d ) ;
  pthread_join ( d.c_thread , NULL ) ;
  close ( d.fd ) ;
  jack_ringbuffer_free ( d.rb ) ;
  jack_client_close ( client ) ;
  close ( d.pipe[0]) ;
  close ( d.pipe[1]) ;
  free ( d.j_buffer) ;
  return EXIT_SUCCESS ;
}
