#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jvmpi.h>

#include <jmp.h>
#include <mvector.h>
#include <method.h>

/** Create a new mvector with can hold at least size elements. */
mvector* mvector_new (size_t size) {
    mvector* mv = malloc (sizeof (*mv));
    if (mv == NULL)
	return NULL;
    mv->methods = malloc (sizeof (method*) * size);
    if (mv->methods == NULL) {
	mvector_free (mv);
	return NULL;
    }
    mv->size = size;
    mv->load = 0;
    return mv;
}

/** Delete the given mvector. */
void mvector_free (mvector* mv) {
    if (mv == NULL)
	return;
    free (mv->methods);
    free (mv);
}

/** Get the number of methods in this vector. */
inline size_t mvector_load (mvector* mv) {
    return mv->load;
}

size_t mvector_grow (mvector* mv) {
    method** nm = realloc (mv->methods, mv->size * 2 * sizeof (method*));
    if (nm == NULL)
	return 0;
    mv->methods = nm;
    mv->size *= 2;
    return mv->size;
}

/** Add a new method to this vector. 
 * @return the load of the new vector.
 */
size_t mvector_add_method (mvector* mv, method* m) {
    if (mv->load == mv->size) {
	if (!mvector_grow (mv)) {
	    fprintf (stderr, "failed to grow mvector...\n");
	    return -1;
	}
    }
    mv->methods[mv->load] = m;
    mv->load++;
    return mv->load;
}

/** search for a method in the given vector.
 * @param mv the vector to search in.
 * @param method the method to search for.
 * @return the index of the method or -1 if not found.
 */
long mvector_search (mvector* mv, method* m) {
    long i;
    for (i = 0; i < (long)mv->load; i++) {
	if (mv->methods[i] == m)
	    return i;
    }
    return -1;
}

/** Get the i:th method. */
inline method* mvector_get (mvector* mv, size_t i) {
    if (i >= mv->load)
	return NULL;
    return (mv->methods[i]);
}


/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
