#ifndef ARENA_H__
#define ARENA_H__

#include <jvmpi.h>
#include <jmp.h>

struct arena {
    jint arena_id;
    char* arena_name;
};

/** Create a new memory area. */
arena* arena_new (jint arena_id, const char* arena_name);

/** Delete an memory area. */
void arena_free (arena* arena);

/** The hash function for arenas. */
size_t arena_jmphash_func (void* arena, size_t len);

/** are the two arenas equal? 
 * return 0 if the two arenas are equals, 
 * else return 1 if a1 is bigger, -1 if a1 is smaller.
 */
int arena_cmp_func (void* a1, void* a2);

/** print info about the arena to stdout.
 */
void arena_print (arena* arena);

/** set the arena_id
 * @param a the arena to change
 * @param new_id the new id for a
 */
void arena_set_arena_id (arena *a, jint new_id);

#endif /* ARENA_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
