#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>

#include <jmp.h>
#include <hash.h>
#include <comparators.h>
#include <stats_context.h>
#include <stats_personality.h>

#include <ui_file.h>

void dump_threads (hashtab* threads, FILE* f) {
    stats_context_t stats_context;

    stats_context_init (&stats_context, &stats_personality_jmpthread_usage);
    stats_context_set_compr (&stats_context, jmpthread_compr_name);

    /* Single pass filter, count and copy (with total) to expandable arraylist datums */
    stats_context_calc (&stats_context, threads);

    fprintf (f, "Threads\n");
    fprintf (f, "thread\tgroup\tparent\tclass\tmethod\n");
    fprintf (f, "--------------------------------------------------------------\n");
    {
        jmpthread **jmpthreadlist = (jmpthread **)stats_context.resultlist;
        int i;
        for (i = 0; i < stats_context.resultlist_count; i++) 
            dump_jmpthread_row (jmpthreadlist[i], f);	
    }

    stats_context_end (&stats_context);
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
