import unittest
import jppy
import baseclass
import types

class eventTest(baseclass.baseTest):
    def setUp(self):
        #jppy.setProvider("jpilot_t3", dateBkFeatures=False)
        baseclass.baseTest.setUp(self)
        self.calendar = self.env.calendar # use the default implementation for now
        self.e = self.calendar.new()

    def testGetValues(self):
        hits = self.calendar.records()[0:10]
        hits.sort()
        for e in hits:
            e['begin'], e['end'], e['repeatEnd']
            if e['alarm']:
                e['alarm'], e['begin'] - e['alarm']
            e['exceptions']
            e['dates'][0:50]

    def testToday(self):
        print "Today"
        for time, event in self.calendar.eventsToday():
            print event["description"]
            begin = event["begin"]
            print "\tBegin: %s" % (begin.strftime('%X %x %Z'))

    def testWeek(self):
        print "This Week"
        for time, event in self.calendar.eventsThisWeek():
            print event["description"]
            begin = event["begin"]
            print "\tBegin: %s" % (begin.strftime('%X %x %Z'))

    def testExtra(self):
        print "Repeat dates"
        for bbb in self.calendar.records(search="last tu")[0:10]:
            print bbb['description']
            dates = bbb['dates']
            for d in  dates:
                print d
                
                
def suite():
    suite = unittest.TestSuite((unittest.makeSuite(eventTest),))
    
    return suite
