/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.gnu.regexp;

import com.tonicsystems.jarjar.gnu.regexp.CharIndexedInputStream;
import com.tonicsystems.jarjar.gnu.regexp.RE;
import com.tonicsystems.jarjar.gnu.regexp.REMatch;
import java.io.FilterInputStream;
import java.io.InputStream;

public class REFilterInputStream
extends FilterInputStream {
    private RE expr;
    private String replace;
    private String buffer;
    private int bufpos;
    private int offset;
    private CharIndexedInputStream stream;

    public REFilterInputStream(InputStream inputStream, RE rE, String string) {
        super(inputStream);
        this.stream = new CharIndexedInputStream(inputStream, 0);
        this.expr = rE;
        this.replace = string;
    }

    public int read() {
        char c;
        if (this.buffer != null && this.bufpos < this.buffer.length()) {
            return this.buffer.charAt(this.bufpos++);
        }
        if (!this.stream.isValid()) {
            return -1;
        }
        REMatch rEMatch = new REMatch(this.expr.getNumSubs(), this.offset, 0);
        if (this.expr.match(this.stream, rEMatch)) {
            rEMatch.end[0] = rEMatch.index;
            rEMatch.finish(this.stream);
            this.stream.move(rEMatch.toString().length());
            this.offset += rEMatch.toString().length();
            this.buffer = rEMatch.substituteInto(this.replace);
            this.bufpos = 1;
            if (this.buffer.length() > 0) {
                return this.buffer.charAt(0);
            }
        }
        if ((c = this.stream.charAt(0)) == '\uffff') {
            return -1;
        }
        this.stream.move(1);
        ++this.offset;
        return c;
    }

    public boolean markSupported() {
        return false;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n2-- > 0) {
            int n4 = this.read();
            if (n4 == -1) {
                return n3 == 0 ? -1 : n3;
            }
            byArray[n++] = (byte)n4;
            ++n3;
        }
        return n3;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }
}

