/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import jline.Terminal;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short O_PREFIX = 79;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    private Map terminfo;
    private boolean echoEnabled;
    private String ttyConfig;
    private static String sttyCommand = System.getProperty("jline.sttyCommand", "stty");

    public void initializeTerminal() throws IOException, InterruptedException {
        this.ttyConfig = UnixTerminal.stty("-g");
        if (this.ttyConfig.length() == 0 || this.ttyConfig.indexOf("=") == -1 && this.ttyConfig.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + this.ttyConfig);
        }
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        this.echoEnabled = false;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    try {
                        UnixTerminal.this.restoreTerminal();
                    }
                    catch (Exception e) {
                        UnixTerminal.this.consumeException(e);
                    }
                }
            });
        }
        catch (AbstractMethodError ame) {
            this.consumeException(ame);
        }
    }

    public void restoreTerminal() throws Exception {
        if (this.ttyConfig != null) {
            UnixTerminal.stty(this.ttyConfig);
            this.ttyConfig = null;
        }
        UnixTerminal.resetTerminal();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (c == 27 && ((c = this.readCharacter(in)) == 91 || c == 79)) {
            c = this.readCharacter(in);
            if (c == 65) {
                return 16;
            }
            if (c == 66) {
                return 14;
            }
            if (c == 68) {
                return 2;
            }
            if (c == 67) {
                return 6;
            }
            if (c == 72) {
                return 1;
            }
            if (c == 70) {
                return 5;
            }
        }
        if (c > 128) {
            c = new InputStreamReader((InputStream)new ReplayPrefixOneCharInputStream(c, in), "UTF-8").read();
        }
        return c;
    }

    private void consumeException(Throwable e) {
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        int val = -1;
        try {
            val = UnixTerminal.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == -1) {
            val = 80;
        }
        return val;
    }

    public int getTerminalHeight() {
        int val = -1;
        try {
            val = UnixTerminal.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == -1) {
            val = 24;
        }
        return val;
    }

    private static int getTerminalProperty(String prop) throws IOException, InterruptedException {
        String props = UnixTerminal.stty("-a");
        StringTokenizer tok = new StringTokenizer(props, ";\n");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    private static String stty(String args) throws IOException, InterruptedException {
        return UnixTerminal.exec("stty " + args + " < /dev/tty").trim();
    }

    private static String exec(String cmd) throws IOException, InterruptedException {
        return UnixTerminal.exec(new String[]{"sh", "-c", cmd});
    }

    private static String exec(String[] cmd) throws IOException, InterruptedException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = p.getInputStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        in = p.getErrorStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        p.waitFor();
        String result = new String(bout.toByteArray());
        return result;
    }

    public static void setSttyCommand(String cmd) {
        sttyCommand = cmd;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }

    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void enableEcho() {
        try {
            UnixTerminal.stty("echo");
            this.echoEnabled = true;
        }
        catch (Exception e) {
            this.consumeException(e);
        }
    }

    public synchronized void disableEcho() {
        try {
            UnixTerminal.stty("-echo");
            this.echoEnabled = false;
        }
        catch (Exception e) {
            this.consumeException(e);
        }
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        final byte firstByte;
        final int byteLength;
        final InputStream wrappedStream;
        int byteRead;

        public ReplayPrefixOneCharInputStream(int recorded, InputStream wrapped) throws IOException {
            this.wrappedStream = wrapped;
            this.byteRead = 0;
            this.firstByte = (byte)recorded;
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

