
/*
 * The JTS Topology Suite is a collection of Java classes that
 * implement the fundamental operations required to validate a given
 * geo-spatial data set to a known topological specification.
 *
 * Copyright (C) 2001 Vivid Solutions
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, contact:
 *
 *     Vivid Solutions
 *     Suite #1A
 *     2328 Government Street
 *     Victoria BC  V8T 5G5
 *     Canada
 *
 *     (250)385-6040
 *     www.vividsolutions.com
 */
package com.vividsolutions.jts.noding.snapround;

import java.util.*;
import com.vividsolutions.jts.geom.*;
import com.vividsolutions.jts.noding.*;


/**
 * @version 1.6
 */
public class SimpleSegmentStringsSnapper {

  private int nSnaps = 0;

  public SimpleSegmentStringsSnapper() {
  }

  public int getNumSnaps() { return nSnaps; }

  public void computeNodes(Collection edges, SegmentSnapper ss, boolean testAllSegments)
  {
    nSnaps = 0;

    for (Iterator i0 = edges.iterator(); i0.hasNext(); ) {
      SegmentString edge0 = (SegmentString) i0.next();
      for (Iterator i1 = edges.iterator(); i1.hasNext(); ) {
        SegmentString edge1 = (SegmentString) i1.next();
        if (testAllSegments || edge0 != edge1)
          computeSnaps(edge0, edge1, ss);
      }
    }
    System.out.println("nSnaps = " + nSnaps);
  }

  /**
 * Performs a brute-force comparison of every segment in each SegmentString.
 * This has n^2 performance.
 */
  private void computeSnaps(SegmentString e0, SegmentString e1, SegmentSnapper ss)
  {
    Coordinate[] pts0 = e0.getCoordinates();
    Coordinate[] pts1 = e1.getCoordinates();
    for (int i0 = 0; i0 < pts0.length - 1; i0++) {
      for (int i1 = 0; i1 < pts1.length - 1; i1++) {
        boolean isNodeAdded = ss.addSnappedNode(pts0[i0], e1, i1);
        if (isNodeAdded) nSnaps++;
      }
    }
  }
}
