-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--  26 Jan 2002 H.-F. Vogt: simplified the task (no start/stop any longer)
--  02 Mar 2002 H.-F. Vogt: replaces Unsigned_Types by Interfaces.C
--
-------------------------------------------------------------------------------

with Interfaces.C,
     X_Lib,
     X_Toolkit,
     Xm_Widgets;
use  X_Toolkit,
     Xm_Widgets;
package Mandel_Global is

   type Real is digits 15;


   Appshell,
   The_Main, The_Menu_Bar,
   Calc_Toggle,
   The_Draw              : Widget;
   About_Dialog          : Widget := Null_Widget;
   App_Con               : Xt_App_Context;

   Display               : X_Lib.Display_Pointer;
   Screen                : X_Lib.Screen_Pointer;
   
   Pixmap                : X_Lib.Pixmap_ID;
   Colormap              : X_Lib.Colormap_ID;
   Working_Cursor        : X_Lib.Cursor_ID;


   R_Min          : constant := -2.5;
   R_Max          : constant :=  1.0;
   I_Min          : constant := -1.5;
   I_Max          : constant :=  1.5;

   Max_Iterations : constant := 200;


   -- use a color cube of 5x5x5 colors (shared)
   Cube_Side  : constant := 5;
   Num_Colors : constant := Cube_Side*Cube_Side*Cube_Side+1;

   type Pixel_Array is array (Natural range <>) of X_Lib.Pixel;
   type GC_Array is array (Natural range <>) of X_Lib.GC_Pointer;
   type Cube_Int_Type is range 1 .. Cube_Side;

   Shift_Count : Natural := Interfaces.C.unsigned_short'Size
                            - Cube_Int_Type'Size;

   Color_Table : Pixel_Array (1 .. Num_Colors);
   GC_Table    : GC_Array (1 .. Num_Colors);

   GC_Copy     : X_Lib.GC_Pointer;

   Argl        : Arg_List := Null_Arg_List;



   -- ordinal number of our tasks
   type Our_Task_ID is new Natural;

   task type Calculate_Mandel (Task_ID : Our_Task_ID; Offset, Jump : X_Lib.Dimension) is
   end Calculate_Mandel;

   type Calculate_Mandel_Access is access Calculate_Mandel;

   type Calculate_Mandel_List is
      array (Our_Task_ID range <>) of Calculate_Mandel_Access;

   -- use 10 tasks to calculate the mandelbrot set
   Num_Tasks : constant Our_Task_ID := 10;

   -- static list of tasks
   Task_List : Calculate_Mandel_List (1 .. Num_Tasks) := (others => null);


   procedure Set_Size (Width, Height : in X_Lib.Dimension);


   procedure Calculate_CB (W         : in Widget;
                           Closure   : in Xt_Pointer;
                           Call_Data : in Xt_Pointer);
   pragma Convention (C, Calculate_CB);


   procedure About_CB (W         : in Widget;
                       Closure   : in Xt_Pointer;
                       Call_Data : in Xt_Pointer);
   pragma Convention (C, About_CB);


   procedure Quit_CB (W         : in Widget;
                      Closure   : in Xt_Pointer;
                      Call_Data : in Xt_Pointer);
   pragma Convention (C, Quit_CB);


   procedure Expose_CB (W         : in Widget;
                        Closure   : in Xt_Pointer;
                        Call_Data : in Xt_Pointer);
   pragma Convention (C, Expose_CB);


   procedure Resize_CB (W         : in Widget;
                        Closure   : in Xt_Pointer;
                        Call_Data : in Xt_Pointer);
   pragma Convention (C, Resize_CB);


   procedure Initialize_Threads;

end Mandel_Global;
