// pair.i - SWIG interface
%module Buffy

%include std_string.i
%include std_vector.i

//%feature("director");

%exception {
	try { $action }
	catch (...) { SWIG_fail; }
}

%{
#include <buffy/mailfolder.h>
#include <buffy/config/config.h>
%}

%ignore buffy::SmartPointer;
%ignore buffy::SmartPointerItem;

// Parse the original header file
%include <buffy/utils/smartpointer.h>
%include <buffy/utils/consumer.h>
%include <buffy/config/config.h>

// Instantiate the base class needed for MailFolder, but dont wrap it
%template() buffy::SmartPointer<buffy::MailFolderImpl>;
%template(MailFolderVector) std::vector<buffy::MailFolder>;
%template(MailProgramInfoVector) std::vector<buffy::config::MailProgramInfo>;
%template(StringVector) std::vector<std::string>;

%ignore MailFolderImpl;
%include <buffy/mailfolder.h>

// TODO:
// Rename the static method to be called as MailFolder.enumerateFolders
// (or even as Buffy.enumerateFolders?)
