/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferOverflowException;
import org.apache.commons.collections.BufferUnderflowException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BoundedFifoBuffer
extends AbstractCollection
implements Buffer,
BoundedCollection,
Serializable {
    private static final long serialVersionUID = 5603722811189451017L;
    private transient Object[] elements;
    private transient int start;
    private transient int end;
    private transient boolean full;
    private final int maxElements;

    private final void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.size());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            out.writeObject(it.next());
        }
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.elements = new Object[this.maxElements];
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.elements[i] = in.readObject();
            ++i;
        }
        this.start = 0;
        this.end = size;
        boolean bl = false;
        if (size == this.maxElements) {
            bl = true;
        }
        this.full = bl;
    }

    public int size() {
        int size = 0;
        if (this.end < this.start) {
            size = this.maxElements - this.start + this.end;
        } else if (this.end == this.start) {
            int n = 0;
            if (this.full) {
                n = this.maxElements;
            }
            size = n;
        } else {
            size = this.end - this.start;
        }
        return size;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isFull() {
        boolean bl = false;
        if (this.size() == this.maxElements) {
            bl = true;
        }
        return bl;
    }

    public int maxSize() {
        return this.maxElements;
    }

    public void clear() {
        this.full = false;
        this.start = 0;
        this.end = 0;
        Arrays.fill(this.elements, null);
    }

    public boolean add(Object element) {
        if (element == null) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.full) {
            throw new BufferOverflowException("The buffer cannot hold more than " + this.maxElements + " objects.");
        }
        this.elements[this.end++] = element;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        return true;
    }

    public Object get() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        return this.elements[this.start];
    }

    public Object remove() {
        if (this.isEmpty()) {
            throw new BufferUnderflowException("The buffer is already empty");
        }
        Object element = this.elements[this.start];
        if (element != null) {
            this.elements[this.start++] = null;
            if (this.start >= this.maxElements) {
                this.start = 0;
            }
            this.full = false;
        }
        return element;
    }

    private final int increment(int index) {
        if (++index >= this.maxElements) {
            index = 0;
        }
        return index;
    }

    private final int decrement(int index) {
        if (--index < 0) {
            index = this.maxElements - 1;
        }
        return index;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;

            public final boolean hasNext() {
                boolean bl = false;
                if (this.isFirst || this.index != BoundedFifoBuffer.this.end) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = BoundedFifoBuffer.this.increment(this.index);
                return BoundedFifoBuffer.this.elements[this.lastReturnedIndex];
            }

            public final void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == BoundedFifoBuffer.this.start) {
                    BoundedFifoBuffer.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int i = this.lastReturnedIndex + 1;
                while (i != BoundedFifoBuffer.this.end) {
                    if (i >= BoundedFifoBuffer.this.maxElements) {
                        ((BoundedFifoBuffer)BoundedFifoBuffer.this).elements[i - 1] = BoundedFifoBuffer.this.elements[0];
                        i = 0;
                        continue;
                    }
                    ((BoundedFifoBuffer)BoundedFifoBuffer.this).elements[i - 1] = BoundedFifoBuffer.this.elements[i];
                    ++i;
                }
                this.lastReturnedIndex = -1;
                BoundedFifoBuffer.this.end = BoundedFifoBuffer.this.decrement(BoundedFifoBuffer.this.end);
                ((BoundedFifoBuffer)BoundedFifoBuffer.this).elements[((BoundedFifoBuffer)BoundedFifoBuffer.this).end] = null;
                BoundedFifoBuffer.this.full = false;
                this.index = BoundedFifoBuffer.this.decrement(this.index);
            }

            private final /* synthetic */ void this() {
                this.index = BoundedFifoBuffer.this.start;
                this.lastReturnedIndex = -1;
                this.isFirst = BoundedFifoBuffer.this.full;
            }
            {
                this.this();
            }
        };
    }

    private final /* synthetic */ void this() {
        this.start = 0;
        this.end = 0;
        this.full = false;
    }

    public BoundedFifoBuffer() {
        this(32);
    }

    public BoundedFifoBuffer(int size) {
        this.this();
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new Object[size];
        this.maxElements = this.elements.length;
    }

    public BoundedFifoBuffer(Collection coll) {
        this(coll.size());
        this.addAll(coll);
    }
}

