/*

    Decimation filter for rate 8
    Copyright (C) 2001 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Low pass FIR filter derived using FFT method with Kaiser window (983 terms).
    Generated by SYSTOLIX Filter Synthesis at 23:26:21 on 10/12/00.
    Specification:
    F1 = 0.05625
    F2 = 0.0625
    Passband Ripple = 0.1dB
    Stopband Ripple = 96dB

*/


static const long lDec8FilterLen = 983l;

static const float fDec8FilterGain = 1.0f;
static const float fpDec8FilterCoeffs[] = {
2.70639034212053E-07,
2.01351459602907E-07,
8.49817716965743E-08,
-6.76234050964983E-08,
-2.37504991269846E-07,
-3.99597583523033E-07,
-5.26079730218235E-07,
-5.90668045320343E-07,
-5.73244610122679E-07,
-4.64076997412264E-07,
-2.66870732007077E-07,
1.25050114646284E-19,
3.04510633982239E-07,
6.04357989381113E-07,
8.5241492690151E-07,
1.00362629802479E-06,
1.02239883552017E-06,
8.89353634796607E-07,
6.06289736655381E-07,
1.98370617343691E-07,
-2.87116068393308E-07,
-7.85598524238963E-07,
-1.22328174524335E-06,
-1.52750390721205E-06,
-1.63800882593761E-06,
-1.51747429669633E-06,
-1.15958891767196E-06,
-5.93185436087314E-07,
1.18592940073892E-07,
8.84445658410112E-07,
1.59595217530494E-06,
2.14226637087327E-06,
2.4265668494047E-06,
2.38192047628147E-06,
1.98409581556021E-06,
1.25910934981589E-06,
2.83893882261604E-07,
-8.20617243789598E-07,
-1.90360795339674E-06,
-2.80419521935052E-06,
-3.37445165567494E-06,
-3.50245253815809E-06,
-3.13189826940181E-06,
-2.27509565413663E-06,
-1.01681698511848E-06,
4.92276761248059E-07,
2.05250581851155E-06,
3.44064312835751E-06,
4.44088091423356E-06,
4.87712700808741E-06,
4.64194862787723E-06,
3.71762397289947E-06,
2.18559179199389E-06,
2.22032466885817E-07,
-1.92079953080519E-06,
-3.94579180761263E-06,
-5.55106060503894E-06,
-6.47365455537816E-06,
-6.53071314121403E-06,
-5.65185521699453E-06,
-3.89742603295352E-06,
-1.45893630544178E-06,
1.35960991351478E-06,
4.1780850447611E-06,
6.59019890782765E-06,
8.2206737618549E-06,
8.78177134532773E-06,
8.12088053986182E-06,
6.25163322125318E-06,
3.36292871186793E-06,
-1.96892460297949E-07,
-3.96003616098453E-06,
-7.39914569264886E-06,
-9.99966533275195E-06,
-1.1334957570072E-05,
-1.11334427268262E-05,
-9.32751967562066E-06,
-6.07603986154002E-06,
-1.755442935305E-06,
3.08108561011534E-06,
7.77247135539935E-06,
1.16383550577206E-05,
1.40758168023092E-05,
1.46507227131957E-05,
1.3170175777295E-05,
9.72449209096751E-06,
4.69085635836895E-06,
-1.30410295953303E-06,
-7.4597987590294E-06,
-1.2906537170283E-05,
-1.68263047333366E-05,
-1.8572996784738E-05,
-1.77747436042285E-05,
-1.44026012984174E-05,
-8.79384784098326E-06,
-1.62401633009144E-06,
6.17113984502989E-06,
1.35152791159095E-05,
1.93377808802932E-05,
2.27271651042756E-05,
2.30699802626788E-05,
2.01544494085141E-05,
1.42221284529392E-05,
5.95741541329559E-06,
-3.58685763507087E-06,
-1.31204323375135E-05,
-2.12874084982815E-05,
-2.68563118997257E-05,
-2.89021718327769E-05,
-2.69541356747723E-05,
-2.10857407116039E-05,
-1.19320228896534E-05,
-6.27327506288419E-07,
1.13312627646264E-05,
2.22790714648524E-05,
3.06125641894454E-05,
3.50206577332626E-05,
3.46856929282726E-05,
2.94238932117317E-05,
1.97423172153628E-05,
6.80013886700161E-06,
-7.72482458218882E-06,
-2.18498351140942E-05,
-3.35545527251889E-05,
-4.10663797013568E-05,
-4.31240089116464E-05,
-3.91805966243044E-05,
-2.95147933879603E-05,
-1.52295343371269E-05,
1.8664318742817E-06,
1.94828078422555E-05,
3.51507318463052E-05,
4.65649543704191E-05,
5.19183008163504E-05,
5.01804944071552E-05,
4.12791825984052E-05,
2.61530487844698E-05,
6.66375917468808E-06,
-1.4627000999393E-05,
-3.47896739784477E-05,
-5.09257666481726E-05,
-6.05798314305743E-05,
-6.21065481450979E-05,
-5.49388356717745E-05,
-3.9714657316401E-05,
-1.82384478203426E-05,
6.72443981365172E-06,
3.17982144875475E-05,
5.34484794112982E-05,
6.84756079255122E-05,
7.44814402797141E-05,
7.02420102036588E-05,
5.59295431395782E-05,
3.31460026848978E-05,
4.7556420637874E-06,
-2.5467984520173E-05,
-5.33381451101319E-05,
-7.48297525443307E-05,
-8.66546730526919E-05,
-8.67560728798208E-05,
-7.46485477653863E-05,
-5.15496953873815E-05,
-2.02761708177472E-05,
1.50904411052927E-05,
4.97297845993242E-05,
7.87340664196268E-05,
9.77973515185642E-05,
1.03846816448779E-04,
9.55244265184472E-05,
7.34451167653242E-05,
4.01863251750255E-05,
-1.24974292591403E-17,
-4.17228728569098E-05,
-7.91690177589482E-05,
-1.06906524744823E-04,
-1.20665171308218E-04,
-1.17982299645665E-04,
-9.86179605708049E-05,
-6.46720386817375E-05,
-2.03756807416958E-05,
2.84256528067166E-05,
7.50359753680417E-05,
1.12820713184441E-04,
1.36143544850398E-04,
1.41196851232961E-04,
1.26604712130384E-04,
9.37050964538412E-05,
4.64598017669452E-05,
-9.00860743338057E-06,
-6.52009876641903E-05,
-1.14247869516208E-04,
-1.49003833647015E-04,
-1.64078860553058E-04,
-1.56659031498342E-04,
-1.26993453059979E-04,
-7.84670193015943E-05,
-1.72342158531402E-05,
4.85497940435002E-05,
1.09806511292115E-04,
1.57778817760822E-04,
1.85273534814301E-04,
1.87726743697292E-04,
1.63935747273559E-04,
1.16343181536173E-04,
5.0817982564791E-05,
-2.40530758614038E-05,
-9.80801417766793E-05,
-1.60848165186646E-04,
-2.03172837294367E-04,
-2.18432319257862E-04,
-2.03583213055366E-04,
-1.59707298843403E-04,
-9.19965255995954E-05,
-9.15975821871071E-06,
7.76843646459958E-05,
1.56489659407524E-04,
2.15943568100234E-04,
2.47079529960234E-04,
2.44612255732378E-04,
2.07799174149416E-04,
1.40691606354803E-04,
5.17206638455526E-05,
-4.73453313469569E-05,
-1.42945535853372E-04,
-2.21572363814603E-04,
-2.71668589756301E-04,
-2.85310855832106E-04,
-2.5943629929267E-04,
-1.96425557611601E-04,
-1.03939997241003E-04,
5.98737671314108E-06,
1.18503004685571E-04,
2.17928055100981E-04,
2.89931541820499E-04,
3.23581666861154E-04,
3.12983622176095E-04,
2.58261181301674E-04,
1.65724125253915E-04,
4.71730558132857E-05,
-8.15871873422214E-05,
-2.02840986461803E-04,
-2.99386943136434E-04,
-3.56964184169226E-04,
-3.66339587933783E-04,
-3.24752890336934E-04,
-2.36497660687798E-04,
-1.12530774712562E-04,
3.08638492011521E-05,
1.74197998111331E-04,
2.97414052949701E-04,
3.82677688055996E-04,
4.16941445196458E-04,
3.9391299077263E-04,
3.15134616764208E-04,
1.89996611860625E-04,
3.46514779644928E-05,
-1.30050843199307E-04,
-2.8134578678958E-04,
-3.97685825660641E-04,
-4.61792187381064E-04,
-4.63196681079599E-04,
-3.99902802346903E-04,
-2.78908105705903E-04,
-1.15482068358686E-04,
6.87349179378608E-05,
2.48578699554928E-04,
3.98782725122552E-04,
4.97510682711069E-04,
5.29508792839924E-04,
4.88425566536746E-04,
3.77950755495156E-04,
2.11580868059378E-04,
1.10056245437018E-05,
-1.96697263696188E-04,
-3.82699475448963E-04,
-5.20405561983555E-04,
-5.89234517710961E-04,
-5.77664531708087E-04,
-4.85094411858208E-04,
-3.22228551986478E-04,
-1.0989096382914E-04,
1.23608772355624E-04,
3.46228709697739E-04,
5.26572318575171E-04,
6.38295377675774E-04,
6.63926223881484E-04,
5.97548995798903E-04,
4.4594370733283E-04,
2.27981942908793E-04,
-2.76843867874344E-05,
-2.86363958486617E-04,
-5.1201188014785E-04,
-6.72230530196114E-04,
-7.4289452633773E-04,
-7.1174306918644E-04,
-5.8040981693425E-04,
-3.64564864249216E-04,
-9.20987718978435E-05,
2.00449461823926E-04,
4.72767693875644E-04,
6.86302198252146E-04,
8.09689665472748E-04,
8.23327808826452E-04,
7.22423123421664E-04,
5.18049847260559E-04,
2.36019949871175E-04,
-8.63353089168098E-05,
-4.05077190456727E-04,
-6.75622626610777E-04,
-8.58953014740143E-04,
-9.27207665177607E-04,
-8.67864507707879E-04,
-6.8588735328546E-04,
-4.03487014498753E-04,
-5.74678126226969E-05,
3.05532422864237E-04,
6.35298543173917E-04,
8.8495540541048E-04,
1.01759742236571E-03,
1.01169719336117E-03,
8.64506589099036E-04,
5.92923808542458E-04,
2.3164026685512E-04,
-1.71243778691548E-04,
-5.60587699629134E-04,
-8.81724892076456E-04,
-1.08810352237393E-03,
-1.14799036889531E-03,
-1.04927815365608E-03,
-8.01677003414065E-04,
-4.35917453197038E-04,
6.73651467961997E-17,
4.47060721834969E-04,
8.43188054484108E-04,
1.13182536272566E-03,
1.26996666524349E-03,
1.23450143672891E-03,
1.02594556586662E-03,
6.68971552343222E-04,
2.09582637058272E-04,
-2.90760241645274E-04,
-7.63316915729398E-04,
-1.14146977912046E-03,
-1.3700687619675E-03,
-1.41341482110589E-03,
-1.26073406663517E-03,
-9.28315451955142E-04,
-4.57929189953721E-04,
8.83480992132562E-05,
6.3627135791613E-04,
1.10946897110666E-03,
1.44003707697217E-03,
1.57822352396809E-03,
1.49982843036808E-03,
1.21023165743118E-03,
7.44399885243357E-04,
1.62769766342333E-04,
-4.56524364181527E-04,
-1.02808848611882E-03,
-1.47098623830897E-03,
-1.72013565014222E-03,
-1.73578911146473E-03,
-1.50972663418752E-03,
-1.06721520290386E-03,
-4.64352436893358E-04,
2.18954189645867E-04,
8.89507089210233E-04,
1.45346230931119E-03,
1.82939118854419E-03,
1.9599516436124E-03,
1.82050767266156E-03,
1.42341751075681E-03,
8.17280623242333E-04,
8.11169531158409E-05,
-6.85843550781793E-04,
-1.37745453932516E-03,
-1.89526027242526E-03,
-2.16241724232075E-03,
-2.13497455707513E-03,
-1.80887326053324E-03,
-1.22157707703712E-03,
-4.4796507774034E-04,
4.09094959763563E-04,
1.23232285582884E-03,
1.90597417220536E-03,
2.33200510473162E-03,
2.44421117780879E-03,
2.21831820642064E-03,
1.67651215031394E-03,
8.85626489358165E-04,
-5.09340152525104E-05,
-1.00658177924774E-03,
-1.84853158352114E-03,
-2.45612026639196E-03,
-2.73795103123611E-03,
-2.64544636001263E-03,
-2.18082523746657E-03,
-1.39823933547739E-03,
-3.9771722323014E-04,
6.87445770101163E-04,
1.70828661942009E-03,
2.52046035544681E-03,
3.00447179835971E-03,
3.08304153038701E-03,
2.73311094043778E-03,
1.99066251737422E-03,
9.47474873210927E-04,
-2.59975479385774E-04,
-1.46815860481347E-03,
-2.50842882488357E-03,
-3.23034048528246E-03,
-3.52314840190129E-03,
-3.33245476834755E-03,
-2.66954432398372E-03,
-1.6118869514361E-03,
-2.94462877219987E-04,
1.10717481179012E-03,
2.4000137587329E-03,
3.39986551410508E-03,
3.95727826749137E-03,
3.97947742893398E-03,
3.44516564940355E-03,
2.40989793434425E-03,
1.00097485779471E-03,
-5.97790419950096E-04,
-2.16966589918375E-03,
-3.49397687176031E-03,
-4.37664285416116E-03,
-4.67810810258065E-03,
-4.3347142055033E-03,
-3.37032935900761E-03,
-1.89627885892007E-03,
-9.91623029082733E-05,
1.78220531781318E-03,
3.48795111779727E-03,
4.77240823741387E-03,
5.4387822750602E-03,
5.36842231760534E-03,
4.54045715799949E-03,
3.03871565072771E-03,
1.0444724974958E-03,
-1.1845564680136E-03,
-3.34664823676569E-03,
-5.13595972027127E-03,
-6.28471267299159E-03,
-6.60199515663682E-03,
-6.00372165761825E-03,
-4.52926563093268E-03,
-2.34189655738352E-03,
2.8777354006817E-04,
3.01386195440827E-03,
5.45916781369691E-03,
7.26559748589238E-03,
8.14453303245361E-03,
7.92031609213706E-03,
6.56062005143147E-03,
4.18894028034484E-03,
1.07658925612552E-03,
-2.38581395599681E-03,
-5.73464514414122E-03,
-8.49215656123235E-03,
-0.010230797066696,
-0.010634739267889,
-9.55031116577643E-03,
-7.01803130396698E-03,
-3.28093818831188E-03,
1.23332539781857E-03,
5.95598425521235E-03,
1.02421732883107E-02,
1.34506138812121E-02,
1.50287669265973E-02,
0.014593123851104,
1.19943438870389E-02,
7.35826442001907E-03,
1.09628880094799E-03,
-6.1179668662734E-03,
-1.34049881128972E-02,
-1.97638923117862E-02,
-2.41768727328898E-02,
-2.57225472165507E-02,
-2.36856945878861E-02,
-0.017650769295814,
-7.56795851761788E-03,
6.21673618018707E-03,
2.29721333519621E-02,
4.16335426580064E-02,
6.08912288870691E-02,
7.93072439759969E-02,
9.54488913735069E-02,
0.108025041242608,
0.116010984904701,
0.118748579794539,
0.116010984904701,
0.108025041242608,
9.54488913735069E-02,
7.93072439759969E-02,
6.08912288870691E-02,
4.16335426580064E-02,
2.29721333519621E-02,
6.21673618018707E-03,
-7.56795851761788E-03,
-0.017650769295814,
-2.36856945878861E-02,
-2.57225472165507E-02,
-2.41768727328898E-02,
-1.97638923117862E-02,
-1.34049881128972E-02,
-6.1179668662734E-03,
1.09628880094799E-03,
7.35826442001907E-03,
1.19943438870389E-02,
0.014593123851104,
1.50287669265973E-02,
1.34506138812121E-02,
1.02421732883107E-02,
5.95598425521235E-03,
1.23332539781857E-03,
-3.28093818831188E-03,
-7.01803130396698E-03,
-9.55031116577643E-03,
-0.010634739267889,
-0.010230797066696,
-8.49215656123235E-03,
-5.73464514414122E-03,
-2.38581395599681E-03,
1.07658925612552E-03,
4.18894028034484E-03,
6.56062005143147E-03,
7.92031609213706E-03,
8.14453303245361E-03,
7.26559748589238E-03,
5.45916781369691E-03,
3.01386195440827E-03,
2.8777354006817E-04,
-2.34189655738352E-03,
-4.52926563093268E-03,
-6.00372165761825E-03,
-6.60199515663682E-03,
-6.28471267299159E-03,
-5.13595972027127E-03,
-3.34664823676569E-03,
-1.1845564680136E-03,
1.0444724974958E-03,
3.03871565072771E-03,
4.54045715799949E-03,
5.36842231760534E-03,
5.4387822750602E-03,
4.77240823741387E-03,
3.48795111779727E-03,
1.78220531781318E-03,
-9.91623029082733E-05,
-1.89627885892007E-03,
-3.37032935900761E-03,
-4.3347142055033E-03,
-4.67810810258065E-03,
-4.37664285416116E-03,
-3.49397687176031E-03,
-2.16966589918375E-03,
-5.97790419950096E-04,
1.00097485779471E-03,
2.40989793434425E-03,
3.44516564940355E-03,
3.97947742893398E-03,
3.95727826749137E-03,
3.39986551410508E-03,
2.4000137587329E-03,
1.10717481179012E-03,
-2.94462877219987E-04,
-1.6118869514361E-03,
-2.66954432398372E-03,
-3.33245476834755E-03,
-3.52314840190129E-03,
-3.23034048528246E-03,
-2.50842882488357E-03,
-1.46815860481347E-03,
-2.59975479385774E-04,
9.47474873210927E-04,
1.99066251737422E-03,
2.73311094043778E-03,
3.08304153038701E-03,
3.00447179835971E-03,
2.52046035544681E-03,
1.70828661942009E-03,
6.87445770101163E-04,
-3.9771722323014E-04,
-1.39823933547739E-03,
-2.18082523746657E-03,
-2.64544636001263E-03,
-2.73795103123611E-03,
-2.45612026639196E-03,
-1.84853158352114E-03,
-1.00658177924774E-03,
-5.09340152525104E-05,
8.85626489358165E-04,
1.67651215031394E-03,
2.21831820642064E-03,
2.44421117780879E-03,
2.33200510473162E-03,
1.90597417220536E-03,
1.23232285582884E-03,
4.09094959763563E-04,
-4.4796507774034E-04,
-1.22157707703712E-03,
-1.80887326053324E-03,
-2.13497455707513E-03,
-2.16241724232075E-03,
-1.89526027242526E-03,
-1.37745453932516E-03,
-6.85843550781793E-04,
8.11169531158409E-05,
8.17280623242333E-04,
1.42341751075681E-03,
1.82050767266156E-03,
1.9599516436124E-03,
1.82939118854419E-03,
1.45346230931119E-03,
8.89507089210233E-04,
2.18954189645867E-04,
-4.64352436893358E-04,
-1.06721520290386E-03,
-1.50972663418752E-03,
-1.73578911146473E-03,
-1.72013565014222E-03,
-1.47098623830897E-03,
-1.02808848611882E-03,
-4.56524364181527E-04,
1.62769766342333E-04,
7.44399885243357E-04,
1.21023165743118E-03,
1.49982843036808E-03,
1.57822352396809E-03,
1.44003707697217E-03,
1.10946897110666E-03,
6.3627135791613E-04,
8.83480992132562E-05,
-4.57929189953721E-04,
-9.28315451955142E-04,
-1.26073406663517E-03,
-1.41341482110589E-03,
-1.3700687619675E-03,
-1.14146977912046E-03,
-7.63316915729398E-04,
-2.90760241645274E-04,
2.09582637058272E-04,
6.68971552343222E-04,
1.02594556586662E-03,
1.23450143672891E-03,
1.26996666524349E-03,
1.13182536272566E-03,
8.43188054484108E-04,
4.47060721834969E-04,
6.73651467961997E-17,
-4.35917453197038E-04,
-8.01677003414065E-04,
-1.04927815365608E-03,
-1.14799036889531E-03,
-1.08810352237393E-03,
-8.81724892076456E-04,
-5.60587699629134E-04,
-1.71243778691548E-04,
2.3164026685512E-04,
5.92923808542458E-04,
8.64506589099036E-04,
1.01169719336117E-03,
1.01759742236571E-03,
8.8495540541048E-04,
6.35298543173917E-04,
3.05532422864237E-04,
-5.74678126226969E-05,
-4.03487014498753E-04,
-6.8588735328546E-04,
-8.67864507707879E-04,
-9.27207665177607E-04,
-8.58953014740143E-04,
-6.75622626610777E-04,
-4.05077190456727E-04,
-8.63353089168098E-05,
2.36019949871175E-04,
5.18049847260559E-04,
7.22423123421664E-04,
8.23327808826452E-04,
8.09689665472748E-04,
6.86302198252146E-04,
4.72767693875644E-04,
2.00449461823926E-04,
-9.20987718978435E-05,
-3.64564864249216E-04,
-5.8040981693425E-04,
-7.1174306918644E-04,
-7.4289452633773E-04,
-6.72230530196114E-04,
-5.1201188014785E-04,
-2.86363958486617E-04,
-2.76843867874344E-05,
2.27981942908793E-04,
4.4594370733283E-04,
5.97548995798903E-04,
6.63926223881484E-04,
6.38295377675774E-04,
5.26572318575171E-04,
3.46228709697739E-04,
1.23608772355624E-04,
-1.0989096382914E-04,
-3.22228551986478E-04,
-4.85094411858208E-04,
-5.77664531708087E-04,
-5.89234517710961E-04,
-5.20405561983555E-04,
-3.82699475448963E-04,
-1.96697263696188E-04,
1.10056245437018E-05,
2.11580868059378E-04,
3.77950755495156E-04,
4.88425566536746E-04,
5.29508792839924E-04,
4.97510682711069E-04,
3.98782725122552E-04,
2.48578699554928E-04,
6.87349179378608E-05,
-1.15482068358686E-04,
-2.78908105705903E-04,
-3.99902802346903E-04,
-4.63196681079599E-04,
-4.61792187381064E-04,
-3.97685825660641E-04,
-2.8134578678958E-04,
-1.30050843199307E-04,
3.46514779644928E-05,
1.89996611860625E-04,
3.15134616764208E-04,
3.9391299077263E-04,
4.16941445196458E-04,
3.82677688055996E-04,
2.97414052949701E-04,
1.74197998111331E-04,
3.08638492011521E-05,
-1.12530774712562E-04,
-2.36497660687798E-04,
-3.24752890336934E-04,
-3.66339587933783E-04,
-3.56964184169226E-04,
-2.99386943136434E-04,
-2.02840986461803E-04,
-8.15871873422214E-05,
4.71730558132857E-05,
1.65724125253915E-04,
2.58261181301674E-04,
3.12983622176095E-04,
3.23581666861154E-04,
2.89931541820499E-04,
2.17928055100981E-04,
1.18503004685571E-04,
5.98737671314108E-06,
-1.03939997241003E-04,
-1.96425557611601E-04,
-2.5943629929267E-04,
-2.85310855832106E-04,
-2.71668589756301E-04,
-2.21572363814603E-04,
-1.42945535853372E-04,
-4.73453313469569E-05,
5.17206638455526E-05,
1.40691606354803E-04,
2.07799174149416E-04,
2.44612255732378E-04,
2.47079529960234E-04,
2.15943568100234E-04,
1.56489659407524E-04,
7.76843646459958E-05,
-9.15975821871071E-06,
-9.19965255995954E-05,
-1.59707298843403E-04,
-2.03583213055366E-04,
-2.18432319257862E-04,
-2.03172837294367E-04,
-1.60848165186646E-04,
-9.80801417766793E-05,
-2.40530758614038E-05,
5.0817982564791E-05,
1.16343181536173E-04,
1.63935747273559E-04,
1.87726743697292E-04,
1.85273534814301E-04,
1.57778817760822E-04,
1.09806511292115E-04,
4.85497940435002E-05,
-1.72342158531402E-05,
-7.84670193015943E-05,
-1.26993453059979E-04,
-1.56659031498342E-04,
-1.64078860553058E-04,
-1.49003833647015E-04,
-1.14247869516208E-04,
-6.52009876641903E-05,
-9.00860743338057E-06,
4.64598017669452E-05,
9.37050964538412E-05,
1.26604712130384E-04,
1.41196851232961E-04,
1.36143544850398E-04,
1.12820713184441E-04,
7.50359753680417E-05,
2.84256528067166E-05,
-2.03756807416958E-05,
-6.46720386817375E-05,
-9.86179605708049E-05,
-1.17982299645665E-04,
-1.20665171308218E-04,
-1.06906524744823E-04,
-7.91690177589482E-05,
-4.17228728569098E-05,
-1.24974292591403E-17,
4.01863251750255E-05,
7.34451167653242E-05,
9.55244265184472E-05,
1.03846816448779E-04,
9.77973515185642E-05,
7.87340664196268E-05,
4.97297845993242E-05,
1.50904411052927E-05,
-2.02761708177472E-05,
-5.15496953873815E-05,
-7.46485477653863E-05,
-8.67560728798208E-05,
-8.66546730526919E-05,
-7.48297525443307E-05,
-5.33381451101319E-05,
-2.5467984520173E-05,
4.7556420637874E-06,
3.31460026848978E-05,
5.59295431395782E-05,
7.02420102036588E-05,
7.44814402797141E-05,
6.84756079255122E-05,
5.34484794112982E-05,
3.17982144875475E-05,
6.72443981365172E-06,
-1.82384478203426E-05,
-3.9714657316401E-05,
-5.49388356717745E-05,
-6.21065481450979E-05,
-6.05798314305743E-05,
-5.09257666481726E-05,
-3.47896739784477E-05,
-1.4627000999393E-05,
6.66375917468808E-06,
2.61530487844698E-05,
4.12791825984052E-05,
5.01804944071552E-05,
5.19183008163504E-05,
4.65649543704191E-05,
3.51507318463052E-05,
1.94828078422555E-05,
1.8664318742817E-06,
-1.52295343371269E-05,
-2.95147933879603E-05,
-3.91805966243044E-05,
-4.31240089116464E-05,
-4.10663797013568E-05,
-3.35545527251889E-05,
-2.18498351140942E-05,
-7.72482458218882E-06,
6.80013886700161E-06,
1.97423172153628E-05,
2.94238932117317E-05,
3.46856929282726E-05,
3.50206577332626E-05,
3.06125641894454E-05,
2.22790714648524E-05,
1.13312627646264E-05,
-6.27327506288419E-07,
-1.19320228896534E-05,
-2.10857407116039E-05,
-2.69541356747723E-05,
-2.89021718327769E-05,
-2.68563118997257E-05,
-2.12874084982815E-05,
-1.31204323375135E-05,
-3.58685763507087E-06,
5.95741541329559E-06,
1.42221284529392E-05,
2.01544494085141E-05,
2.30699802626788E-05,
2.27271651042756E-05,
1.93377808802932E-05,
1.35152791159095E-05,
6.17113984502989E-06,
-1.62401633009144E-06,
-8.79384784098326E-06,
-1.44026012984174E-05,
-1.77747436042285E-05,
-1.8572996784738E-05,
-1.68263047333366E-05,
-1.2906537170283E-05,
-7.4597987590294E-06,
-1.30410295953303E-06,
4.69085635836895E-06,
9.72449209096751E-06,
1.3170175777295E-05,
1.46507227131957E-05,
1.40758168023092E-05,
1.16383550577206E-05,
7.77247135539935E-06,
3.08108561011534E-06,
-1.755442935305E-06,
-6.07603986154002E-06,
-9.32751967562066E-06,
-1.11334427268262E-05,
-1.1334957570072E-05,
-9.99966533275195E-06,
-7.39914569264886E-06,
-3.96003616098453E-06,
-1.96892460297949E-07,
3.36292871186793E-06,
6.25163322125318E-06,
8.12088053986182E-06,
8.78177134532773E-06,
8.2206737618549E-06,
6.59019890782765E-06,
4.1780850447611E-06,
1.35960991351478E-06,
-1.45893630544178E-06,
-3.89742603295352E-06,
-5.65185521699453E-06,
-6.53071314121403E-06,
-6.47365455537816E-06,
-5.55106060503894E-06,
-3.94579180761263E-06,
-1.92079953080519E-06,
2.22032466885817E-07,
2.18559179199389E-06,
3.71762397289947E-06,
4.64194862787723E-06,
4.87712700808741E-06,
4.44088091423356E-06,
3.44064312835751E-06,
2.05250581851155E-06,
4.92276761248059E-07,
-1.01681698511848E-06,
-2.27509565413663E-06,
-3.13189826940181E-06,
-3.50245253815809E-06,
-3.37445165567494E-06,
-2.80419521935052E-06,
-1.90360795339674E-06,
-8.20617243789598E-07,
2.83893882261604E-07,
1.25910934981589E-06,
1.98409581556021E-06,
2.38192047628147E-06,
2.4265668494047E-06,
2.14226637087327E-06,
1.59595217530494E-06,
8.84445658410112E-07,
1.18592940073892E-07,
-5.93185436087314E-07,
-1.15958891767196E-06,
-1.51747429669633E-06,
-1.63800882593761E-06,
-1.52750390721205E-06,
-1.22328174524335E-06,
-7.85598524238963E-07,
-2.87116068393308E-07,
1.98370617343691E-07,
6.06289736655381E-07,
8.89353634796607E-07,
1.02239883552017E-06,
1.00362629802479E-06,
8.5241492690151E-07,
6.04357989381113E-07,
3.04510633982239E-07,
1.25050114646284E-19,
-2.66870732007077E-07,
-4.64076997412264E-07,
-5.73244610122679E-07,
-5.90668045320343E-07,
-5.26079730218235E-07,
-3.99597583523033E-07,
-2.37504991269846E-07,
-6.76234050964983E-08,
8.49817716965743E-08,
2.01351459602907E-07,
2.70639034212053E-07
};

static const double dDec8FilterGain = 1.0;
static const double dpDec8FilterCoeffs[] = {
2.70639034212053E-07,
2.01351459602907E-07,
8.49817716965743E-08,
-6.76234050964983E-08,
-2.37504991269846E-07,
-3.99597583523033E-07,
-5.26079730218235E-07,
-5.90668045320343E-07,
-5.73244610122679E-07,
-4.64076997412264E-07,
-2.66870732007077E-07,
1.25050114646284E-19,
3.04510633982239E-07,
6.04357989381113E-07,
8.5241492690151E-07,
1.00362629802479E-06,
1.02239883552017E-06,
8.89353634796607E-07,
6.06289736655381E-07,
1.98370617343691E-07,
-2.87116068393308E-07,
-7.85598524238963E-07,
-1.22328174524335E-06,
-1.52750390721205E-06,
-1.63800882593761E-06,
-1.51747429669633E-06,
-1.15958891767196E-06,
-5.93185436087314E-07,
1.18592940073892E-07,
8.84445658410112E-07,
1.59595217530494E-06,
2.14226637087327E-06,
2.4265668494047E-06,
2.38192047628147E-06,
1.98409581556021E-06,
1.25910934981589E-06,
2.83893882261604E-07,
-8.20617243789598E-07,
-1.90360795339674E-06,
-2.80419521935052E-06,
-3.37445165567494E-06,
-3.50245253815809E-06,
-3.13189826940181E-06,
-2.27509565413663E-06,
-1.01681698511848E-06,
4.92276761248059E-07,
2.05250581851155E-06,
3.44064312835751E-06,
4.44088091423356E-06,
4.87712700808741E-06,
4.64194862787723E-06,
3.71762397289947E-06,
2.18559179199389E-06,
2.22032466885817E-07,
-1.92079953080519E-06,
-3.94579180761263E-06,
-5.55106060503894E-06,
-6.47365455537816E-06,
-6.53071314121403E-06,
-5.65185521699453E-06,
-3.89742603295352E-06,
-1.45893630544178E-06,
1.35960991351478E-06,
4.1780850447611E-06,
6.59019890782765E-06,
8.2206737618549E-06,
8.78177134532773E-06,
8.12088053986182E-06,
6.25163322125318E-06,
3.36292871186793E-06,
-1.96892460297949E-07,
-3.96003616098453E-06,
-7.39914569264886E-06,
-9.99966533275195E-06,
-1.1334957570072E-05,
-1.11334427268262E-05,
-9.32751967562066E-06,
-6.07603986154002E-06,
-1.755442935305E-06,
3.08108561011534E-06,
7.77247135539935E-06,
1.16383550577206E-05,
1.40758168023092E-05,
1.46507227131957E-05,
1.3170175777295E-05,
9.72449209096751E-06,
4.69085635836895E-06,
-1.30410295953303E-06,
-7.4597987590294E-06,
-1.2906537170283E-05,
-1.68263047333366E-05,
-1.8572996784738E-05,
-1.77747436042285E-05,
-1.44026012984174E-05,
-8.79384784098326E-06,
-1.62401633009144E-06,
6.17113984502989E-06,
1.35152791159095E-05,
1.93377808802932E-05,
2.27271651042756E-05,
2.30699802626788E-05,
2.01544494085141E-05,
1.42221284529392E-05,
5.95741541329559E-06,
-3.58685763507087E-06,
-1.31204323375135E-05,
-2.12874084982815E-05,
-2.68563118997257E-05,
-2.89021718327769E-05,
-2.69541356747723E-05,
-2.10857407116039E-05,
-1.19320228896534E-05,
-6.27327506288419E-07,
1.13312627646264E-05,
2.22790714648524E-05,
3.06125641894454E-05,
3.50206577332626E-05,
3.46856929282726E-05,
2.94238932117317E-05,
1.97423172153628E-05,
6.80013886700161E-06,
-7.72482458218882E-06,
-2.18498351140942E-05,
-3.35545527251889E-05,
-4.10663797013568E-05,
-4.31240089116464E-05,
-3.91805966243044E-05,
-2.95147933879603E-05,
-1.52295343371269E-05,
1.8664318742817E-06,
1.94828078422555E-05,
3.51507318463052E-05,
4.65649543704191E-05,
5.19183008163504E-05,
5.01804944071552E-05,
4.12791825984052E-05,
2.61530487844698E-05,
6.66375917468808E-06,
-1.4627000999393E-05,
-3.47896739784477E-05,
-5.09257666481726E-05,
-6.05798314305743E-05,
-6.21065481450979E-05,
-5.49388356717745E-05,
-3.9714657316401E-05,
-1.82384478203426E-05,
6.72443981365172E-06,
3.17982144875475E-05,
5.34484794112982E-05,
6.84756079255122E-05,
7.44814402797141E-05,
7.02420102036588E-05,
5.59295431395782E-05,
3.31460026848978E-05,
4.7556420637874E-06,
-2.5467984520173E-05,
-5.33381451101319E-05,
-7.48297525443307E-05,
-8.66546730526919E-05,
-8.67560728798208E-05,
-7.46485477653863E-05,
-5.15496953873815E-05,
-2.02761708177472E-05,
1.50904411052927E-05,
4.97297845993242E-05,
7.87340664196268E-05,
9.77973515185642E-05,
1.03846816448779E-04,
9.55244265184472E-05,
7.34451167653242E-05,
4.01863251750255E-05,
-1.24974292591403E-17,
-4.17228728569098E-05,
-7.91690177589482E-05,
-1.06906524744823E-04,
-1.20665171308218E-04,
-1.17982299645665E-04,
-9.86179605708049E-05,
-6.46720386817375E-05,
-2.03756807416958E-05,
2.84256528067166E-05,
7.50359753680417E-05,
1.12820713184441E-04,
1.36143544850398E-04,
1.41196851232961E-04,
1.26604712130384E-04,
9.37050964538412E-05,
4.64598017669452E-05,
-9.00860743338057E-06,
-6.52009876641903E-05,
-1.14247869516208E-04,
-1.49003833647015E-04,
-1.64078860553058E-04,
-1.56659031498342E-04,
-1.26993453059979E-04,
-7.84670193015943E-05,
-1.72342158531402E-05,
4.85497940435002E-05,
1.09806511292115E-04,
1.57778817760822E-04,
1.85273534814301E-04,
1.87726743697292E-04,
1.63935747273559E-04,
1.16343181536173E-04,
5.0817982564791E-05,
-2.40530758614038E-05,
-9.80801417766793E-05,
-1.60848165186646E-04,
-2.03172837294367E-04,
-2.18432319257862E-04,
-2.03583213055366E-04,
-1.59707298843403E-04,
-9.19965255995954E-05,
-9.15975821871071E-06,
7.76843646459958E-05,
1.56489659407524E-04,
2.15943568100234E-04,
2.47079529960234E-04,
2.44612255732378E-04,
2.07799174149416E-04,
1.40691606354803E-04,
5.17206638455526E-05,
-4.73453313469569E-05,
-1.42945535853372E-04,
-2.21572363814603E-04,
-2.71668589756301E-04,
-2.85310855832106E-04,
-2.5943629929267E-04,
-1.96425557611601E-04,
-1.03939997241003E-04,
5.98737671314108E-06,
1.18503004685571E-04,
2.17928055100981E-04,
2.89931541820499E-04,
3.23581666861154E-04,
3.12983622176095E-04,
2.58261181301674E-04,
1.65724125253915E-04,
4.71730558132857E-05,
-8.15871873422214E-05,
-2.02840986461803E-04,
-2.99386943136434E-04,
-3.56964184169226E-04,
-3.66339587933783E-04,
-3.24752890336934E-04,
-2.36497660687798E-04,
-1.12530774712562E-04,
3.08638492011521E-05,
1.74197998111331E-04,
2.97414052949701E-04,
3.82677688055996E-04,
4.16941445196458E-04,
3.9391299077263E-04,
3.15134616764208E-04,
1.89996611860625E-04,
3.46514779644928E-05,
-1.30050843199307E-04,
-2.8134578678958E-04,
-3.97685825660641E-04,
-4.61792187381064E-04,
-4.63196681079599E-04,
-3.99902802346903E-04,
-2.78908105705903E-04,
-1.15482068358686E-04,
6.87349179378608E-05,
2.48578699554928E-04,
3.98782725122552E-04,
4.97510682711069E-04,
5.29508792839924E-04,
4.88425566536746E-04,
3.77950755495156E-04,
2.11580868059378E-04,
1.10056245437018E-05,
-1.96697263696188E-04,
-3.82699475448963E-04,
-5.20405561983555E-04,
-5.89234517710961E-04,
-5.77664531708087E-04,
-4.85094411858208E-04,
-3.22228551986478E-04,
-1.0989096382914E-04,
1.23608772355624E-04,
3.46228709697739E-04,
5.26572318575171E-04,
6.38295377675774E-04,
6.63926223881484E-04,
5.97548995798903E-04,
4.4594370733283E-04,
2.27981942908793E-04,
-2.76843867874344E-05,
-2.86363958486617E-04,
-5.1201188014785E-04,
-6.72230530196114E-04,
-7.4289452633773E-04,
-7.1174306918644E-04,
-5.8040981693425E-04,
-3.64564864249216E-04,
-9.20987718978435E-05,
2.00449461823926E-04,
4.72767693875644E-04,
6.86302198252146E-04,
8.09689665472748E-04,
8.23327808826452E-04,
7.22423123421664E-04,
5.18049847260559E-04,
2.36019949871175E-04,
-8.63353089168098E-05,
-4.05077190456727E-04,
-6.75622626610777E-04,
-8.58953014740143E-04,
-9.27207665177607E-04,
-8.67864507707879E-04,
-6.8588735328546E-04,
-4.03487014498753E-04,
-5.74678126226969E-05,
3.05532422864237E-04,
6.35298543173917E-04,
8.8495540541048E-04,
1.01759742236571E-03,
1.01169719336117E-03,
8.64506589099036E-04,
5.92923808542458E-04,
2.3164026685512E-04,
-1.71243778691548E-04,
-5.60587699629134E-04,
-8.81724892076456E-04,
-1.08810352237393E-03,
-1.14799036889531E-03,
-1.04927815365608E-03,
-8.01677003414065E-04,
-4.35917453197038E-04,
6.73651467961997E-17,
4.47060721834969E-04,
8.43188054484108E-04,
1.13182536272566E-03,
1.26996666524349E-03,
1.23450143672891E-03,
1.02594556586662E-03,
6.68971552343222E-04,
2.09582637058272E-04,
-2.90760241645274E-04,
-7.63316915729398E-04,
-1.14146977912046E-03,
-1.3700687619675E-03,
-1.41341482110589E-03,
-1.26073406663517E-03,
-9.28315451955142E-04,
-4.57929189953721E-04,
8.83480992132562E-05,
6.3627135791613E-04,
1.10946897110666E-03,
1.44003707697217E-03,
1.57822352396809E-03,
1.49982843036808E-03,
1.21023165743118E-03,
7.44399885243357E-04,
1.62769766342333E-04,
-4.56524364181527E-04,
-1.02808848611882E-03,
-1.47098623830897E-03,
-1.72013565014222E-03,
-1.73578911146473E-03,
-1.50972663418752E-03,
-1.06721520290386E-03,
-4.64352436893358E-04,
2.18954189645867E-04,
8.89507089210233E-04,
1.45346230931119E-03,
1.82939118854419E-03,
1.9599516436124E-03,
1.82050767266156E-03,
1.42341751075681E-03,
8.17280623242333E-04,
8.11169531158409E-05,
-6.85843550781793E-04,
-1.37745453932516E-03,
-1.89526027242526E-03,
-2.16241724232075E-03,
-2.13497455707513E-03,
-1.80887326053324E-03,
-1.22157707703712E-03,
-4.4796507774034E-04,
4.09094959763563E-04,
1.23232285582884E-03,
1.90597417220536E-03,
2.33200510473162E-03,
2.44421117780879E-03,
2.21831820642064E-03,
1.67651215031394E-03,
8.85626489358165E-04,
-5.09340152525104E-05,
-1.00658177924774E-03,
-1.84853158352114E-03,
-2.45612026639196E-03,
-2.73795103123611E-03,
-2.64544636001263E-03,
-2.18082523746657E-03,
-1.39823933547739E-03,
-3.9771722323014E-04,
6.87445770101163E-04,
1.70828661942009E-03,
2.52046035544681E-03,
3.00447179835971E-03,
3.08304153038701E-03,
2.73311094043778E-03,
1.99066251737422E-03,
9.47474873210927E-04,
-2.59975479385774E-04,
-1.46815860481347E-03,
-2.50842882488357E-03,
-3.23034048528246E-03,
-3.52314840190129E-03,
-3.33245476834755E-03,
-2.66954432398372E-03,
-1.6118869514361E-03,
-2.94462877219987E-04,
1.10717481179012E-03,
2.4000137587329E-03,
3.39986551410508E-03,
3.95727826749137E-03,
3.97947742893398E-03,
3.44516564940355E-03,
2.40989793434425E-03,
1.00097485779471E-03,
-5.97790419950096E-04,
-2.16966589918375E-03,
-3.49397687176031E-03,
-4.37664285416116E-03,
-4.67810810258065E-03,
-4.3347142055033E-03,
-3.37032935900761E-03,
-1.89627885892007E-03,
-9.91623029082733E-05,
1.78220531781318E-03,
3.48795111779727E-03,
4.77240823741387E-03,
5.4387822750602E-03,
5.36842231760534E-03,
4.54045715799949E-03,
3.03871565072771E-03,
1.0444724974958E-03,
-1.1845564680136E-03,
-3.34664823676569E-03,
-5.13595972027127E-03,
-6.28471267299159E-03,
-6.60199515663682E-03,
-6.00372165761825E-03,
-4.52926563093268E-03,
-2.34189655738352E-03,
2.8777354006817E-04,
3.01386195440827E-03,
5.45916781369691E-03,
7.26559748589238E-03,
8.14453303245361E-03,
7.92031609213706E-03,
6.56062005143147E-03,
4.18894028034484E-03,
1.07658925612552E-03,
-2.38581395599681E-03,
-5.73464514414122E-03,
-8.49215656123235E-03,
-0.010230797066696,
-0.010634739267889,
-9.55031116577643E-03,
-7.01803130396698E-03,
-3.28093818831188E-03,
1.23332539781857E-03,
5.95598425521235E-03,
1.02421732883107E-02,
1.34506138812121E-02,
1.50287669265973E-02,
0.014593123851104,
1.19943438870389E-02,
7.35826442001907E-03,
1.09628880094799E-03,
-6.1179668662734E-03,
-1.34049881128972E-02,
-1.97638923117862E-02,
-2.41768727328898E-02,
-2.57225472165507E-02,
-2.36856945878861E-02,
-0.017650769295814,
-7.56795851761788E-03,
6.21673618018707E-03,
2.29721333519621E-02,
4.16335426580064E-02,
6.08912288870691E-02,
7.93072439759969E-02,
9.54488913735069E-02,
0.108025041242608,
0.116010984904701,
0.118748579794539,
0.116010984904701,
0.108025041242608,
9.54488913735069E-02,
7.93072439759969E-02,
6.08912288870691E-02,
4.16335426580064E-02,
2.29721333519621E-02,
6.21673618018707E-03,
-7.56795851761788E-03,
-0.017650769295814,
-2.36856945878861E-02,
-2.57225472165507E-02,
-2.41768727328898E-02,
-1.97638923117862E-02,
-1.34049881128972E-02,
-6.1179668662734E-03,
1.09628880094799E-03,
7.35826442001907E-03,
1.19943438870389E-02,
0.014593123851104,
1.50287669265973E-02,
1.34506138812121E-02,
1.02421732883107E-02,
5.95598425521235E-03,
1.23332539781857E-03,
-3.28093818831188E-03,
-7.01803130396698E-03,
-9.55031116577643E-03,
-0.010634739267889,
-0.010230797066696,
-8.49215656123235E-03,
-5.73464514414122E-03,
-2.38581395599681E-03,
1.07658925612552E-03,
4.18894028034484E-03,
6.56062005143147E-03,
7.92031609213706E-03,
8.14453303245361E-03,
7.26559748589238E-03,
5.45916781369691E-03,
3.01386195440827E-03,
2.8777354006817E-04,
-2.34189655738352E-03,
-4.52926563093268E-03,
-6.00372165761825E-03,
-6.60199515663682E-03,
-6.28471267299159E-03,
-5.13595972027127E-03,
-3.34664823676569E-03,
-1.1845564680136E-03,
1.0444724974958E-03,
3.03871565072771E-03,
4.54045715799949E-03,
5.36842231760534E-03,
5.4387822750602E-03,
4.77240823741387E-03,
3.48795111779727E-03,
1.78220531781318E-03,
-9.91623029082733E-05,
-1.89627885892007E-03,
-3.37032935900761E-03,
-4.3347142055033E-03,
-4.67810810258065E-03,
-4.37664285416116E-03,
-3.49397687176031E-03,
-2.16966589918375E-03,
-5.97790419950096E-04,
1.00097485779471E-03,
2.40989793434425E-03,
3.44516564940355E-03,
3.97947742893398E-03,
3.95727826749137E-03,
3.39986551410508E-03,
2.4000137587329E-03,
1.10717481179012E-03,
-2.94462877219987E-04,
-1.6118869514361E-03,
-2.66954432398372E-03,
-3.33245476834755E-03,
-3.52314840190129E-03,
-3.23034048528246E-03,
-2.50842882488357E-03,
-1.46815860481347E-03,
-2.59975479385774E-04,
9.47474873210927E-04,
1.99066251737422E-03,
2.73311094043778E-03,
3.08304153038701E-03,
3.00447179835971E-03,
2.52046035544681E-03,
1.70828661942009E-03,
6.87445770101163E-04,
-3.9771722323014E-04,
-1.39823933547739E-03,
-2.18082523746657E-03,
-2.64544636001263E-03,
-2.73795103123611E-03,
-2.45612026639196E-03,
-1.84853158352114E-03,
-1.00658177924774E-03,
-5.09340152525104E-05,
8.85626489358165E-04,
1.67651215031394E-03,
2.21831820642064E-03,
2.44421117780879E-03,
2.33200510473162E-03,
1.90597417220536E-03,
1.23232285582884E-03,
4.09094959763563E-04,
-4.4796507774034E-04,
-1.22157707703712E-03,
-1.80887326053324E-03,
-2.13497455707513E-03,
-2.16241724232075E-03,
-1.89526027242526E-03,
-1.37745453932516E-03,
-6.85843550781793E-04,
8.11169531158409E-05,
8.17280623242333E-04,
1.42341751075681E-03,
1.82050767266156E-03,
1.9599516436124E-03,
1.82939118854419E-03,
1.45346230931119E-03,
8.89507089210233E-04,
2.18954189645867E-04,
-4.64352436893358E-04,
-1.06721520290386E-03,
-1.50972663418752E-03,
-1.73578911146473E-03,
-1.72013565014222E-03,
-1.47098623830897E-03,
-1.02808848611882E-03,
-4.56524364181527E-04,
1.62769766342333E-04,
7.44399885243357E-04,
1.21023165743118E-03,
1.49982843036808E-03,
1.57822352396809E-03,
1.44003707697217E-03,
1.10946897110666E-03,
6.3627135791613E-04,
8.83480992132562E-05,
-4.57929189953721E-04,
-9.28315451955142E-04,
-1.26073406663517E-03,
-1.41341482110589E-03,
-1.3700687619675E-03,
-1.14146977912046E-03,
-7.63316915729398E-04,
-2.90760241645274E-04,
2.09582637058272E-04,
6.68971552343222E-04,
1.02594556586662E-03,
1.23450143672891E-03,
1.26996666524349E-03,
1.13182536272566E-03,
8.43188054484108E-04,
4.47060721834969E-04,
6.73651467961997E-17,
-4.35917453197038E-04,
-8.01677003414065E-04,
-1.04927815365608E-03,
-1.14799036889531E-03,
-1.08810352237393E-03,
-8.81724892076456E-04,
-5.60587699629134E-04,
-1.71243778691548E-04,
2.3164026685512E-04,
5.92923808542458E-04,
8.64506589099036E-04,
1.01169719336117E-03,
1.01759742236571E-03,
8.8495540541048E-04,
6.35298543173917E-04,
3.05532422864237E-04,
-5.74678126226969E-05,
-4.03487014498753E-04,
-6.8588735328546E-04,
-8.67864507707879E-04,
-9.27207665177607E-04,
-8.58953014740143E-04,
-6.75622626610777E-04,
-4.05077190456727E-04,
-8.63353089168098E-05,
2.36019949871175E-04,
5.18049847260559E-04,
7.22423123421664E-04,
8.23327808826452E-04,
8.09689665472748E-04,
6.86302198252146E-04,
4.72767693875644E-04,
2.00449461823926E-04,
-9.20987718978435E-05,
-3.64564864249216E-04,
-5.8040981693425E-04,
-7.1174306918644E-04,
-7.4289452633773E-04,
-6.72230530196114E-04,
-5.1201188014785E-04,
-2.86363958486617E-04,
-2.76843867874344E-05,
2.27981942908793E-04,
4.4594370733283E-04,
5.97548995798903E-04,
6.63926223881484E-04,
6.38295377675774E-04,
5.26572318575171E-04,
3.46228709697739E-04,
1.23608772355624E-04,
-1.0989096382914E-04,
-3.22228551986478E-04,
-4.85094411858208E-04,
-5.77664531708087E-04,
-5.89234517710961E-04,
-5.20405561983555E-04,
-3.82699475448963E-04,
-1.96697263696188E-04,
1.10056245437018E-05,
2.11580868059378E-04,
3.77950755495156E-04,
4.88425566536746E-04,
5.29508792839924E-04,
4.97510682711069E-04,
3.98782725122552E-04,
2.48578699554928E-04,
6.87349179378608E-05,
-1.15482068358686E-04,
-2.78908105705903E-04,
-3.99902802346903E-04,
-4.63196681079599E-04,
-4.61792187381064E-04,
-3.97685825660641E-04,
-2.8134578678958E-04,
-1.30050843199307E-04,
3.46514779644928E-05,
1.89996611860625E-04,
3.15134616764208E-04,
3.9391299077263E-04,
4.16941445196458E-04,
3.82677688055996E-04,
2.97414052949701E-04,
1.74197998111331E-04,
3.08638492011521E-05,
-1.12530774712562E-04,
-2.36497660687798E-04,
-3.24752890336934E-04,
-3.66339587933783E-04,
-3.56964184169226E-04,
-2.99386943136434E-04,
-2.02840986461803E-04,
-8.15871873422214E-05,
4.71730558132857E-05,
1.65724125253915E-04,
2.58261181301674E-04,
3.12983622176095E-04,
3.23581666861154E-04,
2.89931541820499E-04,
2.17928055100981E-04,
1.18503004685571E-04,
5.98737671314108E-06,
-1.03939997241003E-04,
-1.96425557611601E-04,
-2.5943629929267E-04,
-2.85310855832106E-04,
-2.71668589756301E-04,
-2.21572363814603E-04,
-1.42945535853372E-04,
-4.73453313469569E-05,
5.17206638455526E-05,
1.40691606354803E-04,
2.07799174149416E-04,
2.44612255732378E-04,
2.47079529960234E-04,
2.15943568100234E-04,
1.56489659407524E-04,
7.76843646459958E-05,
-9.15975821871071E-06,
-9.19965255995954E-05,
-1.59707298843403E-04,
-2.03583213055366E-04,
-2.18432319257862E-04,
-2.03172837294367E-04,
-1.60848165186646E-04,
-9.80801417766793E-05,
-2.40530758614038E-05,
5.0817982564791E-05,
1.16343181536173E-04,
1.63935747273559E-04,
1.87726743697292E-04,
1.85273534814301E-04,
1.57778817760822E-04,
1.09806511292115E-04,
4.85497940435002E-05,
-1.72342158531402E-05,
-7.84670193015943E-05,
-1.26993453059979E-04,
-1.56659031498342E-04,
-1.64078860553058E-04,
-1.49003833647015E-04,
-1.14247869516208E-04,
-6.52009876641903E-05,
-9.00860743338057E-06,
4.64598017669452E-05,
9.37050964538412E-05,
1.26604712130384E-04,
1.41196851232961E-04,
1.36143544850398E-04,
1.12820713184441E-04,
7.50359753680417E-05,
2.84256528067166E-05,
-2.03756807416958E-05,
-6.46720386817375E-05,
-9.86179605708049E-05,
-1.17982299645665E-04,
-1.20665171308218E-04,
-1.06906524744823E-04,
-7.91690177589482E-05,
-4.17228728569098E-05,
-1.24974292591403E-17,
4.01863251750255E-05,
7.34451167653242E-05,
9.55244265184472E-05,
1.03846816448779E-04,
9.77973515185642E-05,
7.87340664196268E-05,
4.97297845993242E-05,
1.50904411052927E-05,
-2.02761708177472E-05,
-5.15496953873815E-05,
-7.46485477653863E-05,
-8.67560728798208E-05,
-8.66546730526919E-05,
-7.48297525443307E-05,
-5.33381451101319E-05,
-2.5467984520173E-05,
4.7556420637874E-06,
3.31460026848978E-05,
5.59295431395782E-05,
7.02420102036588E-05,
7.44814402797141E-05,
6.84756079255122E-05,
5.34484794112982E-05,
3.17982144875475E-05,
6.72443981365172E-06,
-1.82384478203426E-05,
-3.9714657316401E-05,
-5.49388356717745E-05,
-6.21065481450979E-05,
-6.05798314305743E-05,
-5.09257666481726E-05,
-3.47896739784477E-05,
-1.4627000999393E-05,
6.66375917468808E-06,
2.61530487844698E-05,
4.12791825984052E-05,
5.01804944071552E-05,
5.19183008163504E-05,
4.65649543704191E-05,
3.51507318463052E-05,
1.94828078422555E-05,
1.8664318742817E-06,
-1.52295343371269E-05,
-2.95147933879603E-05,
-3.91805966243044E-05,
-4.31240089116464E-05,
-4.10663797013568E-05,
-3.35545527251889E-05,
-2.18498351140942E-05,
-7.72482458218882E-06,
6.80013886700161E-06,
1.97423172153628E-05,
2.94238932117317E-05,
3.46856929282726E-05,
3.50206577332626E-05,
3.06125641894454E-05,
2.22790714648524E-05,
1.13312627646264E-05,
-6.27327506288419E-07,
-1.19320228896534E-05,
-2.10857407116039E-05,
-2.69541356747723E-05,
-2.89021718327769E-05,
-2.68563118997257E-05,
-2.12874084982815E-05,
-1.31204323375135E-05,
-3.58685763507087E-06,
5.95741541329559E-06,
1.42221284529392E-05,
2.01544494085141E-05,
2.30699802626788E-05,
2.27271651042756E-05,
1.93377808802932E-05,
1.35152791159095E-05,
6.17113984502989E-06,
-1.62401633009144E-06,
-8.79384784098326E-06,
-1.44026012984174E-05,
-1.77747436042285E-05,
-1.8572996784738E-05,
-1.68263047333366E-05,
-1.2906537170283E-05,
-7.4597987590294E-06,
-1.30410295953303E-06,
4.69085635836895E-06,
9.72449209096751E-06,
1.3170175777295E-05,
1.46507227131957E-05,
1.40758168023092E-05,
1.16383550577206E-05,
7.77247135539935E-06,
3.08108561011534E-06,
-1.755442935305E-06,
-6.07603986154002E-06,
-9.32751967562066E-06,
-1.11334427268262E-05,
-1.1334957570072E-05,
-9.99966533275195E-06,
-7.39914569264886E-06,
-3.96003616098453E-06,
-1.96892460297949E-07,
3.36292871186793E-06,
6.25163322125318E-06,
8.12088053986182E-06,
8.78177134532773E-06,
8.2206737618549E-06,
6.59019890782765E-06,
4.1780850447611E-06,
1.35960991351478E-06,
-1.45893630544178E-06,
-3.89742603295352E-06,
-5.65185521699453E-06,
-6.53071314121403E-06,
-6.47365455537816E-06,
-5.55106060503894E-06,
-3.94579180761263E-06,
-1.92079953080519E-06,
2.22032466885817E-07,
2.18559179199389E-06,
3.71762397289947E-06,
4.64194862787723E-06,
4.87712700808741E-06,
4.44088091423356E-06,
3.44064312835751E-06,
2.05250581851155E-06,
4.92276761248059E-07,
-1.01681698511848E-06,
-2.27509565413663E-06,
-3.13189826940181E-06,
-3.50245253815809E-06,
-3.37445165567494E-06,
-2.80419521935052E-06,
-1.90360795339674E-06,
-8.20617243789598E-07,
2.83893882261604E-07,
1.25910934981589E-06,
1.98409581556021E-06,
2.38192047628147E-06,
2.4265668494047E-06,
2.14226637087327E-06,
1.59595217530494E-06,
8.84445658410112E-07,
1.18592940073892E-07,
-5.93185436087314E-07,
-1.15958891767196E-06,
-1.51747429669633E-06,
-1.63800882593761E-06,
-1.52750390721205E-06,
-1.22328174524335E-06,
-7.85598524238963E-07,
-2.87116068393308E-07,
1.98370617343691E-07,
6.06289736655381E-07,
8.89353634796607E-07,
1.02239883552017E-06,
1.00362629802479E-06,
8.5241492690151E-07,
6.04357989381113E-07,
3.04510633982239E-07,
1.25050114646284E-19,
-2.66870732007077E-07,
-4.64076997412264E-07,
-5.73244610122679E-07,
-5.90668045320343E-07,
-5.26079730218235E-07,
-3.99597583523033E-07,
-2.37504991269846E-07,
-6.76234050964983E-08,
8.49817716965743E-08,
2.01351459602907E-07,
2.70639034212053E-07
};

