/*

    Condition class, header
    Copyright (C) 1999-2000 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <pth.h>


#ifndef PTHCOND_HH
    #define PTHCOND_HH

    class clPthCond
    {
            pth_cond_t pthcCond;
        public:
            clPthCond() { pth_cond_init(&pthcCond); }
            ~clPthCond() {}
            void Wait(pth_mutex_t *pthmCond)
                { pth_cond_await(&pthcCond, pthmCond, NULL); }
            void Wait(pth_mutex_t *pthmCond, pth_event_t ptheCond)
                { pth_cond_await(&pthcCond, pthmCond, ptheCond); }
            void Notify(int iNotifyAll) 
                { pth_cond_notify(&pthcCond, iNotifyAll); }
    };

#endif

