// -*- C++ -*- template function definitions for apt::Records

#ifndef EPT_CACHE_APT_RECORDS_TCC
#define EPT_CACHE_APT_RECORDS_TCC

#include <ept/cache/apt/records.h>
#include <ept/debdbparser.h>
#include <tagcoll/input/memory.h>

#include <cmath>

namespace ept {
namespace t {
namespace cache {
namespace apt {

template< typename P >
Records< P >::Records( Aggregator &a )
    : m_aggregator( a ), m_records( new pkgRecords( index().aptCache() ) )
{
    m_vector.resize( index().packageCount() );
}

template< typename P >
Records< P >::~Records()
{
}

template< typename P >
const typename Records< P >::Record &Records< P >::record( Version v ) const
{
    /* std::cerr << "grabbing record for " << v.package().name() << " "
       << v.versionString() << std::endl; */
    if (!m_records)
        throw 1; // XXX
    assert( v.package().id() >= 0 );
    if ( m_vector.size() <= static_cast< unsigned >( v.package().id() ) )
        m_vector.resize( v.package().id() + 1 );
    Map &map = m_vector[ v.package().id() ];
    typename Map::iterator i = map.find( v );
    if (i != map.end())
        return i->second;
    pkgCache::VerFileIterator Vf;
    pkgRecords::Parser *parser = 0;
    Vf = index().fileList( v );

    if (Vf.end())
        throw 0; // XXX
    parser = &(m_records->Lookup(Vf));
    Record rec;
    std::string sdsc = parser->ShortDesc();
    std::string dsc = parser->LongDesc();
    int diff = dsc.find( sdsc );
    if ( static_cast< unsigned >( diff ) != string::npos )
        dsc = string( dsc, std::min( diff + sdsc.size() + 1, dsc.size() ) ); // +1 for newline
    rec.shortDescription = sdsc;
    rec.longDescription = dsc;
    rec.maintainer = parser->Maintainer();
    rec.fileName = parser->FileName();
    rec.source = parser->SourcePkg();
    rec.md5sum = parser->MD5Hash();
    map[v] = rec;
    m_vector[v.package().id()] = map;
    return map[v];
}

template< typename P >
std::string Records< P >::aptTagData( Version v )
{
    if (!m_records)
        throw 1; // XXX
    pkgCache::VerFileIterator Vf;
    pkgRecords::Parser *parser = 0;
    Vf = index().fileList( v );
    if (Vf.end())
        throw 0; // XXX
    parser = &(m_records->Lookup(Vf));
    const char *start, *stop;
    parser->GetRec(start, stop);

    // Access the right part of the mmapped buffer
    tagcoll::input::Memory in(parser->FileName(), start, stop-start);
    ept::DebDBParser debdbparser(in);
    // Parse the raw string data and store it in the cache vector
    std::map<string, string> parsed;
    debdbparser.nextRecord(parsed);
    return parsed["Tag"];
}

}
}
}
}

#endif
