/** -*- C++ -*-
	@file predicate/factory.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <ept/predicate/matchers.h>
// #include <ept/predicate/combinators.h>
#include <ept/forward.h>
#include <ept/cache/version.h>

#ifndef APTFRONT_PREDICATE_FACTORY_H
#define APTFRONT_PREDICATE_FACTORY_H

namespace ept {
namespace predicate {

template< typename T >
struct Factory {
    typedef AttributeAdaptor< T, match::Substring > SubstringAdaptor;
    typedef typename T::Tag Tag;

    static SubstringAdaptor name( const std::string &match = "" ) {
        return SubstringAdaptor( &T::name, match );
    }

    static SubstringAdaptor shortDescription( const std::string &match = "" ) {
        return SubstringAdaptor( &T::shortDescription, match );
    }

    static SubstringAdaptor longDescription( const std::string &match = "" ) {
        return SubstringAdaptor( &T::longDescription, match );
    }

    static SubstringAdaptor maintainer( const std::string &match = "" ) {
        return SubstringAdaptor( &T::maintainer, match );
    }

    static SubstringAdaptor sectionSubstring( const std::string &match = "" ) {
        return SubstringAdaptor( &T::section, match );
    }

    static AttributeAdaptor< T, match::TagMatch< Tag >, Tag > tag( const Tag &match = Tag() )
    {
        return AttributeAdaptor< T, match::TagMatch< Tag >, Tag >( &T::tags, match );
    }

    static AttributeAdaptor< T, match::TagMatch< Tag, typename Tag::Set > > tagSet(
        const typename Tag::Set &match = typename Tag::Set() )
    {
        return AttributeAdaptor< T, match::TagMatch< Tag, typename Tag::Set > >( &T::tags, match );
    }

    template< typename P >
    static MemberAdaptor< T > member( P func ) {
        return MemberAdaptor< T >( func );
    }

/* mornfall: from matchers.h
template< typename T >
AttributeAdaptor< T, match::TagExpr, std::string > tagexprMatch( const std::string& match ) {
    return AttributeAdaptor< T, match::TagExpr, std::string >( &T::tags, match, "tags" );
}
*/
/*
template< typename T >
TagexprPredicate< T > tagexprMatch( const std::string& match ) {
    return TagexprPredicate< T >( &T::tags, match, "tags" );
}
*/
};

}
}


#endif
