%define prefix /usr
%define INSTDIR %{prefix}/lib
%define INCLUDEDIR %{prefix}/include
%define DOCDIR %{prefix}/share/gtk-doc/html/

Summary:libgenerics provides meta object services to describe classes, store and restore them.
Name:libgenerics
Version:1.2
Release:0fc6
Source:%{name}-%{version}.tar.gz
BuildRoot:/tmp/%{name}-%{version}
Group:Applications/Base
License:GPL

BuildRequires: gcc >= 4.0.0
BuildRequires: pkgconfig
BuildRequires: libxml2-devel

Requires: libxml2

%description
	Libgenerics is a c++ library that provides object services to analyse class type at runtime, share the definitions between 
	modules and to store on disk or load them into memory without knowing their explicit contents. It's an absolute generic library.

%package devel

Summary: libgenerics provides meta object services to describe classes, store and restore them.
License: GPL
Group: Applications/Base

Requires: libxml2-devel
Requires: %{name} = %{version}

%description devel
	The devel package of libgenerics.

%prep
%setup -q

%build
	make all

%install

	mkdir -p $RPM_BUILD_ROOT/%{INSTDIR}/%{name}-%{version}/
	mkdir -p $RPM_BUILD_ROOT/%{INCLUDEDIR}/%{name}-%{version}/
	mkdir -p $RPM_BUILD_ROOT/%{DOCDIR}/%{name}-%{version}/

	cp -r include/* $RPM_BUILD_ROOT/%{INCLUDEDIR}/%{name}-%{version}/
	cp -r samples $RPM_BUILD_ROOT/%{INSTDIR}/%{name}-%{version}/
	cp -r doc/* $RPM_BUILD_ROOT/%{DOCDIR}/%{name}-%{version}/

	cp %{name}-%{version}.so $RPM_BUILD_ROOT/%{INSTDIR}
	cp %{name}-%{version}.a  $RPM_BUILD_ROOT/%{INSTDIR}

	mkdir -p $RPM_BUILD_ROOT/usr/lib/pkgconfig/
	cat %{name}-%{version}.pc.in | sed -e 's:prefix=/usr/local:prefix=%{prefix}:g' > $RPM_BUILD_ROOT/usr/lib/pkgconfig/%{name}-%{version}.pc

%post
	ldconfig

%postun
	ldconfig

%clean
	rm -rf /tmp/%{name}-%{version}/

%files
	%{INSTDIR}/%{name}-%{version}.so
	%{INSTDIR}/%{name}-%{version}.a

%files devel
	%{INCLUDEDIR}/%{name}-%{version}/
	/usr/lib/pkgconfig/%{name}-%{version}.pc
	%{INSTDIR}/%{name}-%{version}/
	%{DOCDIR}/%{name}-%{version}/

%changelog
	* Wed Sep 28 2006 Jrmie Bernard <gremimail@gmail.com>
	- cstring tolower, toupper, fgets addon
	* Thu Jul 05 2006 Jrmie Bernard <gremimail@gmail.com>
	- classes attribute names normalization, 1 listener instance to n object senders implementation
	* Tue Jun 27 2006 Jrmie Bernard <gremimail@gmail.com>
	- object listener serialization attribute handling addon
	* Thu May 30 2006 Jrmie Bernard <gremimail@gmail.com
	- __XML_SERIALIZE__ macro removal, consequent doc update
	* Wed Dec 09 2005 Jrmie Bernard <gremimail@gmail.com>
	- Serialization tag unsigned long to user friendly characters conversion to enable more readable xml dumps
	* Sat Dec 03 2005 Jrmie Bernard <gremimail@gmail.com>
	- Libgenerics html reference manual added
	* Wed Nov 30 2005 Jrmie Bernard <gremimail@gmail.com>
	- Generic class hierarchy modification, objects and listeners now derive the meta module interface to allow using the meta module
	  importer API on such overloaded definitions
	* Tue Nov 9 2005 Michael Aubertin <maubertin@ares.fr>
	- Correct include path and Suse compat.
	* Mon Nov 7 2005 Michael Aubertin <maubertin@ares.fr>
	- Correct include destination directory.
	* Wed Nov 2 2005 Michael Aubertin <maubertin@ares.fr>
	- Prefix directory independant.
	* Thu Oct 27 2005 Jrmie Bernard <gremimail@gmail.com>
	- Added a simple xml object layer, version inc. from 1.0 to 1.2
	* Sun Oct 22 2005 Jrmie Bernard <gremimail@gmail.com>
	- Added some functions like cut and substitute to the cstring tool class
	* Wed Oct 12 2005 Jrmie Bernard <gremimail@gmail.com>
	- Created version 1.0
