/*******************************************************************************************************************************************
 carchive.c
*******************************************************************************************************************************************/

#include "carchive.h"
#include "cserialized.h"

#include <unistd.h>
#include <sys/stat.h>

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_CAPSULE_METACLASS (CArchive);

//------------------------------------------------------------------------------------------------------------------------------------------
// constrcutor
//------------------------------------------------------------------------------------------------------------------------------------------
CArchive::CArchive 	   (const CString &inFileName, const int inArchiveAccess)
	 :CChunk	   (),
	  m_File	   (NULL),
	  m_ArchiveAccess  (inArchiveAccess),
	  m_ArchiveProcess (ARCHIVEPROCESS_NONE),
	  m_Count	   (0)
{
	if (m_ArchiveAccess & ARCHIVE_READ)
	{
		if ((m_File = ::fopen (inFileName.Get(), "r+b")) != NULL)
		{
			UInt32 inFileSignature = 0L;
			if (!::fread (&inFileSignature, sizeof(UInt32), 1, m_File)) return;
			if (inFileSignature != __classtag(CSerialized)) return;
			UInt32 inDataNumber = 0L;
			if (!::fread (&inDataNumber, sizeof(UInt32), 1, m_File)) return;
			if (inDataNumber == 0L) return;
			TData *inDataList = new TData [inDataNumber];
			if (!::fread (inDataList, sizeof(TData), inDataNumber, m_File)) return;
			m_DataList = NServices::TBuffer <TData> (inDataList, inDataNumber);
			delete [] inDataList;
			struct stat inStat;
			::fstat (::fileno(m_File), &inStat);
			UInt32 inDataLength = inStat.st_size - sizeof(UInt32) - sizeof(UInt32) - sizeof(TData) * inDataNumber;
			if (!CChunk::ReallocateChunk (*this, inDataLength)) return;
			::fread (m_Chunk, sizeof(SInt8), inDataLength, m_File);
		}
	}
	if (m_File == NULL && (m_ArchiveAccess & ARCHIVE_WRITE))
		m_File = ::fopen (inFileName.Get(), "w+b");
}

//------------------------------------------------------------------------------------------------------------------------------------------
// copy constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CArchive::CArchive	   (const CArchive &inArchive)
	 :CChunk	   (inArchive),
	  m_File	   (NULL),
	  m_ArchiveAccess  (0),
	  m_ArchiveProcess (ARCHIVEPROCESS_NONE),
	  m_Count	   (0)
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CArchive::~CArchive ()
{ 
	if (m_File != NULL)
	{
		if (!(m_ArchiveAccess & ARCHIVE_NOFLUSH))
		{	
			Flush ();
		}
		::fclose (m_File);
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// archive access
//------------------------------------------------------------------------------------------------------------------------------------------
int CArchive::GetAccess () const
{
	return m_ArchiveAccess;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// archive process
//------------------------------------------------------------------------------------------------------------------------------------------
TArchiveProcess CArchive::GetProcess () const
{
	return m_ArchiveProcess;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// archive flush
//------------------------------------------------------------------------------------------------------------------------------------------
void CArchive::Flush ()
{
	if (m_File != NULL && (m_ArchiveAccess & ARCHIVE_WRITE))
	{
		::fseek (m_File, 0L, SEEK_SET);
		::fwrite (&__classtag(CSerialized), sizeof(UInt32), 1, m_File);
		UInt32 inDataNumber = m_DataList.GetLength();
		::fwrite (&inDataNumber, sizeof(UInt32), 1, m_File);
		::fwrite (m_DataList.Get(), sizeof(TData), inDataNumber, m_File);
		::fwrite (m_Chunk, sizeof(SInt8), m_Size, m_File);
		::ftruncate (::fileno(m_File), m_Size+sizeof(UInt32)+sizeof(UInt32)+sizeof(TData)*inDataNumber);
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// archive write
//------------------------------------------------------------------------------------------------------------------------------------------
#define WRITEFUNC(typename) CArchive & CArchive::operator << (const typename inValue)						\
{																\
	CChunk::operator << (inValue);												\
	return *this;														\
}

WRITEFUNC (SInt8)
WRITEFUNC (UInt8)
WRITEFUNC (SInt16)
WRITEFUNC (UInt16)
WRITEFUNC (SInt32)
WRITEFUNC (UInt32)
WRITEFUNC (SInt64)
WRITEFUNC (UInt64)
WRITEFUNC (Float32)
WRITEFUNC (Float64)

#undef WRITEFUNC

CArchive & CArchive::operator << (const SInt8 *inBuffer)
{
	CChunk::operator << (inBuffer);
	return *this;
}

CArchive & CArchive::operator << (CSerialized &inSerialized)
{
	m_ArchiveProcess = ARCHIVEPROCESS_STORING;
	m_Count++;
	inSerialized.Serialize (*this);
	m_Count--;
	if (m_Count == 0) m_ArchiveProcess = ARCHIVEPROCESS_NONE;
	return *this;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// archive read
//------------------------------------------------------------------------------------------------------------------------------------------

#define READFUNC(typename) CArchive & CArchive::operator >> (typename &outValue)						\
{																\
	CChunk::operator >> (outValue);												\
	return *this;														\
}

READFUNC (SInt8)
READFUNC (UInt8)
READFUNC (SInt16)
READFUNC (UInt16)
READFUNC (SInt32)
READFUNC (UInt32)
READFUNC (SInt64)
READFUNC (UInt64)
READFUNC (Float32)
READFUNC (Float64)
	
#undef READFUNC

CArchive & CArchive::operator >> (SInt8 *&outBuffer)
{
	CChunk::operator >> (outBuffer);
	return *this;
}

CArchive & CArchive::operator >> (CSerialized &inSerialized)
{
	m_ArchiveProcess = ARCHIVEPROCESS_LOADING;
	m_Count--;
	inSerialized.Serialize (*this);
	m_Count++;
	if (m_Count == 0) m_ArchiveProcess = ARCHIVEPROCESS_NONE;
	return *this;
}

CArchive & operator << (CSerialized &inSerialized, CArchive &ioArchive)
{
	return ioArchive >> inSerialized;
}

CArchive & operator >> (CSerialized &inSerialized, CArchive &ioArchive)
{
	return ioArchive << inSerialized;
}

CArchive & CArchive::operator ++ ()
{
	return static_cast <CArchive &> (CChunk::operator ++ ());
}

CArchive & CArchive::operator ++ (int)
{
	return static_cast <CArchive &> (CChunk::operator ++ (0));
}

CArchive & CArchive::operator -- ()
{
	return static_cast <CArchive &> (CChunk::operator -- ());
}

CArchive & CArchive::operator -- (int)
{
	return static_cast <CArchive &> (CChunk::operator -- (0));
}
