/* $Id: texts.c,v 1.3 2005/05/21 20:40:36 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff. Texts, titles and stuff.

   Copyright (C) 2004 Christoph Egger

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "quartzwmh.h"
#include <ggi/internal/wmh_debug.h>

int GGIwmh_quartz_settitle(ggi_visual *vis,const char *title)
{
	ggi_quartz_priv *priv;
	CFStringRef titleKey;
	CFStringRef windowTitle;
	OSStatus result;

	priv = QUARTZ_PRIV(vis);

	titleKey = CFStringCreateWithCString(NULL, title, kCFStringEncodingASCII);
	windowTitle = CFCopyLocalizedString(titleKey, NULL);
	result = SetWindowTitleWithCFString(priv->theWindow, windowTitle);
	LIB_ASSERT(result == noErr, "Could not set the window title\n");

	CFRelease(titleKey);
	CFRelease(windowTitle);

	return GGI_OK;
}

int GGIwmh_quartz_seticontitle(ggi_visual *vis,const char *title)
{
	return GGI_ENOFUNC;
}

int GGIwmh_quartz_iconify(ggi_visual *vis,int newstate)
{
	ggi_quartz_priv *priv;                                                   
	priv = QUARTZ_PRIV(vis);

	switch(newstate) {
	case GGI_WMH_MAPSTATE_NORMAL:
		ShowWindow(priv->theWindow);
		SelectWindow(priv->theWindow);
		return GGI_OK;

	case GGI_WMH_MAPSTATE_ICON:
		CollapseWindow(priv->theWindow, TRUE);
		return GGI_OK;

	case GGI_WMH_MAPSTATE_WITHDRAWN:
		HideWindow(priv->theWindow);
		return GGI_OK;
	}

	return GGI_ENOMATCH;
}

