/*******************************************************************************************************************************************
 cdemomoduletextview.c

 simple compilation directives :
 c++ -Wno-multichar -O2 -o textview `pkg-config --cflags libgtkol-1.2` cdemomoduletextview.c `pkg-config --libs libgtkol-1.2`

*******************************************************************************************************************************************/

#include "cdemomodule.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// file quit menu item listener declaration
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemQuitListener : public CMenuItemListener
{
	// called when the inSender menu item is clicked
	virtual void OnClick (CObject *inSender);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// edit copy menu item declaration
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemCopyListener : public CMenuItemListener
{
	// called when the inSender menu item is clicked
	virtual void OnClick (CObject *inSender);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// menu item cut listener declaration
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemCutListener : public CMenuItemListener
{
	// called when the inSender menu item is clicked
	virtual void OnClick (CObject *inSender);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// menu item paste listener declaration
//-----------------------------------------------------------------------------------------------------------------------------------------
class CMenuItemPasteListener : public CMenuItemListener
{
	// called when the inSender menu item is clicked
	virtual void OnClick (CObject *inSender);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm : public CForm
{
	// instanciation section
	public :

		// the demo form constructor
		CDemoForm (CApplication *inOwner) : CForm (inOwner), m_TextView (NULL)
		{
			// set the form bounds (center the form over screen with 260x440 dimensions)
			SetBounds  (TBounds ((CApplication::GetScreenSize().w-260)/2, (CApplication::GetScreenSize().h-440)/2, 260, 440));

			// set the form caption
			SetCaption (CString("Text View"));

			// instanciate a vertical box layout under the form and set some properties
			CVBoxLayout *VBoxLayout = new CVBoxLayout (this);
			VBoxLayout -> SetHomogeneous (false);
			VBoxLayout -> SetBoxPack     (BOXPACK_START, false, false, 0);

			// instanciate a menu bar under the layout and set the menu items (the quit menu is associated to a specific
			// listener in order to catch the click interested event, it has no predefined hot key associated)
			CMenuBar  	*MenuBar   = new CMenuBar       (VBoxLayout);
			CMenuItem 	*MenuFile  = new CMenuItem      (MenuBar,  CString("_File"));
			CMenuItemImage	*MenuQuit  = new CMenuItemImage (MenuFile, CString("_Quit"),  _HKNone_,  
									 new CMenuItemQuitListener());
			CMenuItem 	*MenuEdit  = new CMenuItem      (MenuBar,  CString("_Edit"));
			CMenuItemImage	*MenuCopy  = new CMenuItemImage (MenuEdit, CString("_Copy"),  _HKCopy_,  
									 new CMenuItemCopyListener());
			CMenuItemImage	*MenuCut   = new CMenuItemImage (MenuEdit, CString("_Cut"),   _HKCut_,
									 new CMenuItemCutListener());
			CMenuItemImage	*MenuPaste = new CMenuItemImage (MenuEdit, CString("_Paste"), _HKPaste_, 
									 new CMenuItemPasteListener());
			new CImage (MenuQuit,  GTK_STOCK_QUIT);
			new CImage (MenuCopy,  GTK_STOCK_COPY);
			new CImage (MenuCut,   GTK_STOCK_CUT);
			new CImage (MenuPaste, GTK_STOCK_PASTE);

			// prapare the next widget insertion by specifying its layout
			VBoxLayout -> SetBoxPack (BOXPACK_START, true, true, 0);

			// instanciate a scrollview
			CScrollView *ScrollView = new CScrollView (VBoxLayout);

			// instanciate the textview in the scrollview
			m_TextView = new CTextView (ScrollView);

			// for commodity only, the textview class instanciates some text tags that can be directly used, so set some text
			// and some predefined properties (of course, you can add your own with direct call to the gtk API as well)
			m_TextView -> InsertText (CString("The text widget can display text with all kinds of nifty attributes.\n\n"));
			size_t inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("Font styles"), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagScaleXLarge, inLength, -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagWeightHeavy, inLength, -1);
			m_TextView -> InsertText (CString(" for example.\n"), -1);
			m_TextView -> InsertText (CString("You can have "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("bold"), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagWeightUltraBold, inLength, -1);
			m_TextView -> InsertText (CString(", "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("italic"), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagItalic, inLength, -1);
			m_TextView -> InsertText (CString(" or, "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("big"), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagScaleXLarge, inLength, -1);
			m_TextView -> InsertText (CString(" text.\n\n"), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("Colors "), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagScaleXLarge, inLength, -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagWeightHeavy, inLength, -1);
			m_TextView -> InsertText (CString("such as "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("blue foreground "), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagFgDarkBlue, inLength, -1);
			m_TextView -> InsertText (CString("or "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("red background"), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagBgRed, inLength, -1);
			m_TextView -> InsertText (CString(" and many others can be used.\n"), -1);
			m_TextView -> InsertText (CString("\nYou can even insert "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("widgets : "), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagScaleXLarge, inLength, -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagWeightHeavy, inLength, -1);
			CComboBox *ComboBox = new CComboBox (m_TextView);
			new CComboBoxItem (ComboBox, CItemFieldValues (1, new CItemFieldValueString (CString("Item 0"))));
			new CComboBoxItem (ComboBox, CItemFieldValues (1, new CItemFieldValueString (CString("Item 1"))));
			new CComboBoxItem (ComboBox, CItemFieldValues (1, new CItemFieldValueString (CString("Item 2"))));
			m_TextView -> InsertText (CString("\n\nAll of the current text is "), -1);
			inLength = m_TextView -> GetText().GetLength();
			m_TextView -> InsertText (CString("word wrapped"), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagScaleXLarge, inLength, -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagWeightHeavy, inLength, -1);
			m_TextView -> InsertText (CString(", just play with the form size... "), -1);
			m_TextView -> InsertText (CString("If it were not you would have an horizontal scroll bar."), -1);
			m_TextView -> InsertText (CString("\n\nThis demo does not demonstrate all the GtkTextBuffer features; "), -1);
			m_TextView -> InsertText (CString("please refer to gtk for a complete set of tools."), -1);
			m_TextView -> ApplyTag   (CTextView::m_GtkTextTagWrapWord);

			// show the form (CForm is the only gtkol component that is not automatically shown)
			Show ();
		}

	// public direct GUI access
	public :

		CTextView *m_TextView;
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CMenuItemQuitListener::OnClick
//-----------------------------------------------------------------------------------------------------------------------------------------
void CMenuItemQuitListener::OnClick (CObject *inSender)
{
	// request the owner form of the menu item and close it
	static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CMenuItemCopyListener::OnClick
//-----------------------------------------------------------------------------------------------------------------------------------------
void CMenuItemCopyListener::OnClick (CObject *inSender)
{
	// retreive our menu item instance
	CMenuItem *inMenuItem = static_cast <CMenuItem *> (inSender);

	// get its demo form owner
	CDemoForm *inDemoForm = static_cast <CDemoForm *> (inMenuItem -> GetOwner (__metaclass(CForm)));

	// check the textview pointer and request the associated action
	if (inDemoForm -> m_TextView != NULL) inDemoForm -> m_TextView -> Copy ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CMenuItemCutListener::OnClick
//-----------------------------------------------------------------------------------------------------------------------------------------
void CMenuItemCutListener::OnClick (CObject *inSender)
{
	// retreive our menu item instance
	CMenuItem *inMenuItem = static_cast <CMenuItem *> (inSender);

	// get its demo form owner
	CDemoForm *inDemoForm = static_cast <CDemoForm *> (inMenuItem -> GetOwner (__metaclass(CForm)));

	// check the textview pointer and request the associated action
	if (inDemoForm -> m_TextView != NULL) inDemoForm -> m_TextView -> Cut ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CMenuItemPasteListener::OnClick
//-----------------------------------------------------------------------------------------------------------------------------------------
void CMenuItemPasteListener::OnClick (CObject *inSender)
{
	// retreive our menu item instance
	CMenuItem *inMenuItem = static_cast <CMenuItem *> (inSender);

	// get its demo form owner
	CDemoForm *inDemoForm = static_cast <CDemoForm *> (inMenuItem -> GetOwner (__metaclass(CForm)));

	// check the textview pointer and request the associated action
	if (inDemoForm -> m_TextView != NULL) inDemoForm -> m_TextView -> Paste ();
}

/*******************************************************************************************************************************************
********************************************************************************************************************************************
 The purpose of the following part is only to dynamically link the previous demo definition to this gui demo core; it is really not the 
 purpose of this sample code. It is shown only as part of the global comprehension of the demo core mechanism itself.
********************************************************************************************************************************************
*******************************************************************************************************************************************/

// demo module constant description declaration
const static TDemoModuleDescription DEMO_MODULE_DESCRIPTION = 
{ 
	CString ("Text View"), 
	CString ("This demo module only shows a piece of the whole text view powerfull gtk layer. It uses some predefined\n") +
		 "gtkol text attributes to show how to work with and does not restrict any personnal addon in anyway.",
	DEMO_MODULES_PATH + "textview.cpp",
	NULL
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoModuleTextView definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoModuleTextView : public CDemoModule
{
	public :
		
		// constructor
		CDemoModuleTextView () : m_Form (NULL) { }

		// give the demo module description
		virtual TDemoModuleDescription GetDescription () const { return DEMO_MODULE_DESCRIPTION; }

		// run the encapsulated demo module
		virtual void Run (CApplication *inOwner) { if (m_Form == NULL) m_Form = new CDemoForm (inOwner); else m_Form -> Show(); }

		// stop the demo
		virtual void Stop () { if (m_Form != NULL) m_Form -> Close(); }

	protected :

		// the encapsulated demo module form
		CDemoForm *m_Form;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// classtag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('dotw', CDemoModuleTextView, CDemoModule);

// metaclass code resolution
RESOLVE_DYNAMIC_METACLASS (CDemoModuleTextView);

// demo module export declaration
DECLARE_METAMODULE_EXPORT (CDemoModuleTextView);

