/*******************************************************************************************************************************************
 cpaned.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CContainer
		      |--CLayout
			 |--CPaned

 A paned widget draws a separator between its two handled children widgets and a small handle that the user can drag to adjust the 
 division. It does not draw any relief around the children or around the separator. Often, it is useful to put each child inside a frame so
 that the gutter appears as a ridge.
*******************************************************************************************************************************************/

#ifndef __CPANED_H__
#define __CPANED_H__

#include "clayout.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// paned xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cpaned position="SInt32">
//    ...
// </cpaned>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_PANED_ELEMENT	("cpaned");
static CString XML_PANED_ATTR_POSITION	("position");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CPaned class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CPaned : public CLayout
{
	// instanciation section
	public :

		CPaned			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CPaned		() =0;

	// protected widget redefinitons
	protected :

		// gtk widget initialization handling
		virtual void		PerformWidgetInitialize		();

	// protected container special handling
	protected :

		// those two functions handle the paned specific container behaviour when adding or removing a child widget
		virtual void		PerformContainerAdd		(CWidget *inChild);
		virtual void		PerformContainerRemove		(CWidget *inChild);

	// CContainer redefinition
	public :
		
		// get the container children number handling left (2 children max)
		virtual SInt16		GetGtkChildrenNumberLeft	() const;

	// paned specific functions
	public :

		// divider position
		virtual void		SetPosition			(const SInt32 inPosition);
		SInt32			GetPosition			() const;

	// CSerialized redefinition
	public :

		// paned xml serialization handling
		virtual void		Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE;

	// protected section
	protected :

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('pned', CPaned, CLayout);

#endif
