/***************************************************************************
 $RCSfile$
 -------------------
 cvs         : $Id: crypt_l.h 985 2006-02-10 03:17:04Z aquamaniac $
 begin       : Thu Nov 06 2003
 copyright   : (C) 2003 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef GWENHYWFAR_CRYPT_L_H
#define GWENHYWFAR_CRYPT_L_H


#include <gwenhywfar/crypt.h>

GWENHYWFAR_API
  GWEN_ERRORCODE GWEN_Crypt_ModuleInit();

GWENHYWFAR_API
  GWEN_ERRORCODE GWEN_Crypt_ModuleFini();


/** @name Functions expected in implementation
 *
 */
/*@{*/
/**
 * This function is expected to register all it's crypto service
 * providers. It is called when the GWEN_Crypt module is initialized.
 */
GWENHYWFAR_API
  GWEN_ERRORCODE GWEN_CryptImpl_Init();

/**
 * This function is called when the GWEN_Crypt module is deinitialized.
 * It can be used to release allocated data. It MUST NOT unregister any
 * crypt key type, this is done automatically.
 */
GWENHYWFAR_API
  GWEN_ERRORCODE GWEN_CryptImpl_Fini();
/*@}*/


/* always exports the public key */
int GWEN_Crypt_KeyToDb(const GWEN_CRYPTKEY *key, GWEN_DB_NODE *db);


#endif /* GWENHYWFAR_CRYPT_L_H */



