/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  asyncqueue.cc - A GAsyncQueue C++ wrapper interface.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "asyncqueue.h"
#include "timeval.h"

using namespace Inti;

/*  G::AsyncQueue
 */

G::AsyncQueue::AsyncQueue()
: queue_(g_async_queue_new()), locked_(false)
{
}

G::AsyncQueue::~AsyncQueue()
{
}

int
G::AsyncQueue::length() const
{
	return locked_ ? g_async_queue_length_unlocked(queue_) : g_async_queue_length(queue_);
}

void
G::AsyncQueue::ref()
{
	if (locked_)
		g_async_queue_ref_unlocked(queue_);
	else
		g_async_queue_ref(queue_);
}

void
G::AsyncQueue::unref()
{
	if (locked_)
		g_async_queue_unref_and_unlock(queue_);
	else
		g_async_queue_unref(queue_);
}

void
G::AsyncQueue::lock()
{
	g_async_queue_lock(queue_);
	locked_ = true;
}

void
G::AsyncQueue::unlock()
{
	g_async_queue_unlock(queue_);
	locked_ = false;
}

void
G::AsyncQueue::push(void *data)
{
	if (locked_)
		g_async_queue_push_unlocked(queue_, data);
	else
		g_async_queue_push(queue_, data);
}

void*
G::AsyncQueue::pop()
{
	return  locked_ ? g_async_queue_pop_unlocked(queue_) : g_async_queue_pop(queue_);
}

void*
G::AsyncQueue::try_pop()
{
	return locked_ ? g_async_queue_try_pop_unlocked(queue_) : g_async_queue_try_pop(queue_);
}

void*
G::AsyncQueue::timed_pop(TimeVal *end_time)
{
	return locked_ ? g_async_queue_timed_pop_unlocked(queue_, *end_time) : g_async_queue_timed_pop(queue_, *end_time);
}

