/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
//! @file inti/glib/quark.h
//! @brief GQuark C++ interface.
//!
//! Quarks provide a 2-way association between a string and a unique integer identifier.

#ifndef INTI_G_QUARK_H
#define INTI_G_QUARK_H

#ifndef INTI_INTEGER_OBJECT_H
#include <inti/integerobject.h>
#endif

#ifndef INTI_UTF_STRING_H
#include <inti/utf-string.h>
#endif

#ifndef __GLIB_GOBJECT_H__
#include <glib-object.h>
#endif

namespace Inti {

namespace G {

//! @class Quark quark.h inti/glib/quark.h
//! @brief A GQuark C++ wrapper interface
//!
//! Quarks are associations between strings and integer identifiers. Given either the
//! string or the Quark identifier it is possible to retrieve the other. Quarks are used
//! to get and set object properties and used data pointers.

class Quark : public IntegerObject<GQuark>
{
public:
//! @name Constructors
//! @{

	Quark(const char *str);
	//!< Construct a Quark from a string
	//!< @param str A string.
	//!<
	//!< <BR>Wraps the GQuark identifying the given string. If the string does not currently
	//!< have an associated GQuark, a new GQuark is created, using a copy of the string.

	Quark(const String& str);
	//!< Construct a Quark from a String
	//!< @param str A String.
	//!<
	//!< <BR>Wraps the GQuark identifying the given string. If the string does not currently
	//!< have an associated GQuark, a new GQuark is created, using a copy of the string.
	
	Quark(GQuark quark);
	//!< Construct a quark from an existing GQuark.
	//!< @param quark A GQuark.

	Quark(const Quark& src);
	//!< Copy Constructor.
	//!< @param src The source Quark.

	Quark& operator=(const Quark& src);
	//!< Assignment operator.
	//!< @param src The source Quark.

//! @}
//! @name Accessors
//! @{

	operator String() const;
	//!< Conversion operator; returns the string associated with the quark
	
//! @}

	static Quark try_string(const char *str);
	//!< Gets the quark associated with the given string.
	//!< @param str A string.
	//!< @return The quark, or null if the string has no associated quark.
};

} // namespace G

} // namespace Inti

#endif // INTI_G_QUARK_H


	
