/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/gtk/accessible.h
//! @brief A GtkAccessible C++ wrapper interface.

#ifndef INTI_GTK_ACCESSIBLE_H
#define INTI_GTK_ACCESSIBLE_H

#ifndef INTI_ATK_OBJECT_H
#include <inti/atk/object.h>
#endif

#ifndef __GTK_ACCESSIBLE_H__
#include <gtk/gtkaccessible.h>
#endif

namespace Inti {

namespace Gtk {

class AccessibleClass;

//! @class Accessible accessible.h inti/gtk/accessible.h
//! @brief A GtkAccessible C++ wrapper class.

class Accessible : public Atk::Object
{
	friend class G::Object;
	friend class AccessibleClass;

	Accessible(const Accessible&);
	Accessible& operator=(const Accessible&);

protected:
//! @name Constructors
//! @{

	explicit Accessible(GtkAccessible *accessible, bool reference = true);
	//!< Construct a new Accessible from an existing GtkAccessible.
	//!< @param accessible A pointer to a GtkAccessible.
	//!< @param reference Set false if the initial reference count is floating, set true if it's not.
	//!<
	//!< <BR>The <EM>accessible</EM> can be a newly created GtkAccessible or an existing
	//!< GtkAccessible. (see G::Object::Object).

//! @}
//  Override this do_ method when you want to change the default behaviour of the GtkAccessible.

	virtual void do_connect_widget_destroyed();

public:
//! @name Constructors
//! @{

	virtual ~Accessible();
	//!< Destructor

//! @}
//! @name Accessors
//! @{

	GtkAccessible* gtk_accessible() const { return (GtkAccessible*)instance; }
	//!< Get a pointer to the GtkAccessible structure.

	GtkAccessibleClass* gtk_accessible_class() const;
	//!< Get a pointer to the GtkAccessibleClass structure.

	operator GtkAccessible* () const;
	//!< Conversion operator; safely converts an Accessible to a GtkAccessible pointer.

//! @}
//! @name Methods
//! @{

	void connect_widget_destroyed();
	//!< This method specifies the callback function to be called when the widget corresponding
	//!< to a GtkAccessible is destroyed.
	
//! @}
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_ACCESSIBLE_H

