/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  item.cc - GtkItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "item.h"
#include "private/item_p.h"

using namespace Inti;

/*  Gtk::Item
 */

Gtk::Item::Item(GtkItem *item, bool reference)
: Bin((GtkBin*)item, reference)
{
}

Gtk::Item::Item()
: Bin((GtkBin*)BinClass::create())
{
}

Gtk::Item::~Item()
{
}

GtkItemClass*
Gtk::Item::gtk_item_class() const 
{ 
	return get_class<GtkItemClass>(); 
}
	
Gtk::Item::operator GtkItem* () const 
{ 
	return this ? gtk_item() : 0;
}
	
void
Gtk::Item::select()
{
	gtk_item_select(gtk_item());
}

void
Gtk::Item::deselect()
{
	gtk_item_deselect(gtk_item());
}

void
Gtk::Item::toggle()
{
	gtk_item_toggle(gtk_item());
}

/*  Gtk::ItemClass
 */

void
Gtk::ItemClass::init(GtkItemClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
	g_class->select = &select_proxy;
	g_class->deselect = &deselect_proxy;
	g_class->toggle = &toggle_proxy;
}

GType
Gtk::ItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ITEM, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ItemClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::ItemClass::select_proxy(GtkItem *item)
{
	Item *tmp_item = G::Object::pointer<Item>(item);
	if (tmp_item)
		tmp_item->on_select();
	else
	{
		GtkItemClass *g_class = G::TypeInstance::class_peek_parent<GtkItemClass>(GTK_ITEM_GET_CLASS(item));
		if (g_class->select)
			g_class->select(item);
	}
}

void
Gtk::ItemClass::deselect_proxy(GtkItem *item)
{
	Item *tmp_item = G::Object::pointer<Item>(item);
	if (tmp_item)
		tmp_item->on_deselect();
	else
	{
		GtkItemClass *g_class = G::TypeInstance::class_peek_parent<GtkItemClass>(GTK_ITEM_GET_CLASS(item));
		if (g_class->deselect)
			g_class->deselect(item);
	}
}

void
Gtk::ItemClass::toggle_proxy(GtkItem *item)
{
	Item *tmp_item = G::Object::pointer<Item>(item);
	if (tmp_item)
		tmp_item->on_toggle();
	else
	{
		GtkItemClass *g_class = G::TypeInstance::class_peek_parent<GtkItemClass>(GTK_ITEM_GET_CLASS(item));
		if (g_class->toggle)
			g_class->toggle(item);
	}
}

/*  Signal handlers
 */

void
Gtk::Item::on_select()
{
	GtkItemClass *g_class = class_peek_parent<GtkItemClass>(gtk_item_class());
	if (g_class->select)
		g_class->select(gtk_item());
}

void
Gtk::Item::on_deselect()
{
	GtkItemClass *g_class = class_peek_parent<GtkItemClass>(gtk_item_class());
	if (g_class->deselect)
		g_class->deselect(gtk_item());
}

void
Gtk::Item::on_toggle()
{
	GtkItemClass *g_class = class_peek_parent<GtkItemClass>(gtk_item_class());
	if (g_class->toggle)
		g_class->toggle(gtk_item());
}

/*  Signals
 */

const Gtk::Item::SelectSignalType Gtk::Item::select_signal("select");

const Gtk::Item::DeselectSignalType Gtk::Item::deselect_signal("deselect");

const Gtk::Item::ToggleSignalType Gtk::Item::toggle_signal("toggle");

