/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  settings.cc - GtkSettings C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gtk/gtktypeutils.h>
#include "settings.h"
#include "../gdk/screen.h"

using namespace Inti;

Gtk::Settings::Settings(GtkSettings *settings, bool reference) 
: G::Object((GObject*)settings, reference)
{
}
	
Gtk::Settings::~Settings()
{
}
	
Gtk::Settings*
Gtk::Settings::get(const Gdk::Screen *screen)
{
	GdkScreen *tmp_screen = screen ? screen->gdk_screen() : gdk_screen_get_default();
	return G::Object::wrap<Settings>(gtk_settings_get_for_screen(tmp_screen));
}

GtkSettingsClass* 
Gtk::Settings::gtk_settings_class() const 
{
	return get_class<GtkSettingsClass>(); 
}
	
Gtk::Settings::operator GtkSettings* () const 
{ 
	return this ? gtk_settings() : 0; 
}
	
/*  Properties
 */

const Gtk::Settings::GtkDoubleClickTimePropertyType Gtk::Settings::gtk_double_click_time_property("gtk-double-click-time");

const Gtk::Settings::GtkCursorBlinkPropertyType Gtk::Settings::gtk_cursor_blink_property("gtk-cursor-blink");

const Gtk::Settings::GtkCursorBlinkTimePropertyType Gtk::Settings::gtk_cursor_blink_time_property("gtk-cursor-blink-time");

const Gtk::Settings::GtkSplitCursorPropertyType Gtk::Settings::gtk_split_cursor_property("gtk-split-cursor");

const Gtk::Settings::GtkThemeNamePropertyType Gtk::Settings::gtk_theme_name_property("gtk-theme-name");

const Gtk::Settings::GtkKeyThemeNamePropertyType Gtk::Settings::gtk_key_theme_name_property("gtk-key-theme-name");

const Gtk::Settings::GtkMenuBarAccelPropertyType Gtk::Settings::gtk_menu_bar_accel_property("gtk-menu-bar-accel");

const Gtk::Settings::GtkDndDragThresholdPropertyType Gtk::Settings::gtk_dnd_drag_threshold_property("gtk-dnd-drag-threshold");

const Gtk::Settings::GtkFontNamePropertyType Gtk::Settings::gtk_font_name_property("gtk-font-name");

const Gtk::Settings::GtkIconSizesPropertyType Gtk::Settings::gtk_icon_sizes_property("gtk-icon-sizes");

