#include "mbbtri.h"

#define BT_PROP_LEN (8)
#define BT_PROP_MASK ((1U << BT_PROP_LEN) - 1U)
#define BT_MASKLEN_MAX (24)

#define BT_OFF_MINMAX (1U + 2U)

#define BT_PROP_INVALID ((BT_MASKLEN_MAX + 1) * BT_OFF_MINMAX * mb_bt_nkinds)

#define BT_DEC_PROP_KIND(enc) (((enc) & BT_PROP_MASK) % mb_bt_nkinds)
#define BT_DEC_PROP_OFF(enc) ((((enc) & BT_PROP_MASK) / mb_bt_nkinds) % BT_OFF_MINMAX)
#define BT_DEC_PROP_MASKLEN(enc) ((((enc) & BT_PROP_MASK) / mb_bt_nkinds) / BT_OFF_MINMAX)

#define BT_OFFMASK(len) ((1U << (BT_MASKLEN_MAX - (len))) - 1U)
#define BT_KEYMASK(len) (((1U << (len)) - 1U) << (BT_MASKLEN_MAX - (len)))

mb_bt_result_t
mb_bt_search(unsigned int orig_key, unsigned int *node, unsigned int *p_value)
{
  unsigned int valuemask;
  mb_bt_result_t res;
  int i, off;
  unsigned int key = orig_key << BT_PROP_LEN;

descend:
  for (res = mb_bt_failure, off = i = 0 ;; ++i)
    if ((node[i] & BT_PROP_MASK) < BT_PROP_INVALID) {
      int masklen = BT_DEC_PROP_MASKLEN(node[i]);
      unsigned int mask = BT_KEYMASK(masklen) << BT_PROP_LEN;

      if ((key & mask) == (node[i] & mask)) {
	res = BT_DEC_PROP_KIND(node[i]);
	node = &node[2 + off];

	if (res == mb_bt_node)
	  goto descend;

	valuemask = BT_OFFMASK(masklen);
	break;
      }

      if (i) goto end;
      off = ((node[i] >> BT_PROP_LEN) & BT_OFFMASK(masklen)) * BT_OFF_MINMAX + BT_DEC_PROP_OFF(node[i]);
    }
    else if (i)
      goto end;

  if (p_value)
    switch (res) {
    case mb_bt_1:
      *p_value = *node;
      break;
    case mb_bt_n:
      *p_value = *node + (orig_key & valuemask);
    default:
      break;
    }

end:
  return res;
}
