/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.eps;

import de.erichseifert.vectorgraphics2d.GraphicsState;
import de.erichseifert.vectorgraphics2d.SizedDocument;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.commands.CreateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DisposeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawImageCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DrawStringCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.FillShapeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.RotateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.ScaleCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetClipCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetColorCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetCompositeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetFontCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetPaintCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetStrokeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.ShearCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.TransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.TranslateCommand;
import de.erichseifert.vectorgraphics2d.util.ASCII85EncodeStream;
import de.erichseifert.vectorgraphics2d.util.AlphaToMaskOp;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.FlateEncodeStream;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import de.erichseifert.vectorgraphics2d.util.ImageDataStream;
import de.erichseifert.vectorgraphics2d.util.LineWrapOutputStream;
import de.erichseifert.vectorgraphics2d.util.PageSize;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EPSDocument
extends SizedDocument {
    private static final double UNITS_PER_MM = 2.834645669291339;
    private static final String CHARSET = "ISO-8859-1";
    private static final String EOL = "\n";
    private static final int MAX_LINE_WIDTH = 255;
    private static final Pattern ELEMENT_SEPARATION_PATTERN = Pattern.compile("(.{1,255})(\\s+|$)");
    private static final Map<Integer, Integer> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final String FONT_LATIN1_SUFFIX = "Lat";
    private final List<String> elements = new LinkedList<String>();

    public EPSDocument(CommandSequence commandSequence, PageSize pageSize) {
        super(pageSize, true);
        this.addHeader();
        for (Command command : commandSequence) {
            this.handle(command);
        }
    }

    private void addHeader() {
        double d = this.getPageSize().getX() * 2.834645669291339;
        double d2 = this.getPageSize().getY() * 2.834645669291339;
        double d3 = this.getPageSize().getWidth() * 2.834645669291339;
        double d4 = this.getPageSize().getHeight() * 2.834645669291339;
        this.elements.addAll(Arrays.asList("%!PS-Adobe-3.0 EPSF-3.0", "%%BoundingBox: " + (int)Math.floor(d) + " " + (int)Math.floor(d2) + " " + (int)Math.ceil(d + d3) + " " + (int)Math.ceil(d2 + d4), "%%HiResBoundingBox: " + d + " " + d2 + " " + (d + d3) + " " + (d2 + d4), "%%LanguageLevel: 3", "%%Pages: 1", "%%EndComments", "%%Page: 1 1", "/M /moveto load def", "/L /lineto load def", "/C /curveto load def", "/Z /closepath load def", "/RL /rlineto load def", "/rgb /setrgbcolor load def", "/cmyk /setcmykcolor load def", "/rect { /height exch def /width exch def /y exch def /x exch def x y M width 0 RL 0 height RL width neg 0 RL } bind def", "/ellipse { /endangle exch def /startangle exch def /ry exch def /rx exch def /y exch def /x exch def /savematrix matrix currentmatrix def x y translate rx ry scale 0 0 1 startangle endangle arcn savematrix setmatrix } bind def", "/imgdict { /datastream exch def /hasdata exch def /decodeScale exch def /bits exch def /bands exch def /imgheight exch def /imgwidth exch def << /ImageType 1 /Width imgwidth /Height imgheight /BitsPerComponent bits /Decode [bands {0 decodeScale} repeat] /ImageMatrix [imgwidth 0 0 imgheight 0 0] hasdata { /DataSource datastream } if >> } bind def", "/latinize { /fontName exch def /fontNameNew exch def fontName findfont 0 dict copy begin /Encoding ISOLatin1Encoding def fontNameNew /FontName def currentdict end dup /FID undef fontNameNew exch definefont pop } bind def", EPSDocument.getOutput(GraphicsState.DEFAULT_FONT), "gsave", "clipsave", "/DeviceRGB setcolorspace", "0 " + d4 + " translate", "2.834645669291339 -2.834645669291339 scale", "/basematrix matrix currentmatrix def"));
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, CHARSET);
        for (String string : this.elements) {
            if (string == null) continue;
            Matcher matcher = ELEMENT_SEPARATION_PATTERN.matcher(string);
            boolean bl = false;
            while (matcher.find()) {
                bl = true;
                String string2 = matcher.group();
                outputStreamWriter.write(string2, 0, string2.length());
                outputStreamWriter.append(EOL);
            }
            if (bl) continue;
            System.err.println("Unable to divide eps element into lines: " + string);
        }
        outputStreamWriter.append("%%EOF");
        outputStreamWriter.flush();
    }

    public void handle(Command<?> command) {
        if (command instanceof SetClipCommand) {
            SetClipCommand setClipCommand = (SetClipCommand)command;
            Shape shape = (Shape)setClipCommand.getValue();
            this.elements.add("cliprestore");
            if (shape != null) {
                this.elements.add(EPSDocument.getOutput(shape) + " clip");
            }
        } else if (command instanceof SetColorCommand) {
            SetColorCommand setColorCommand = (SetColorCommand)command;
            this.elements.add(EPSDocument.getOutput((Color)setColorCommand.getValue()));
        } else if (command instanceof SetCompositeCommand) {
            SetCompositeCommand setCompositeCommand = (SetCompositeCommand)command;
            this.elements.add("% composite not yet implemented: " + setCompositeCommand.getValue());
        } else if (command instanceof SetFontCommand) {
            SetFontCommand setFontCommand = (SetFontCommand)command;
            this.elements.add(EPSDocument.getOutput((Font)setFontCommand.getValue()));
        } else if (command instanceof SetPaintCommand) {
            SetPaintCommand setPaintCommand = (SetPaintCommand)command;
            this.elements.add("% paint not yet implemented: " + setPaintCommand.getValue());
        } else if (command instanceof SetStrokeCommand) {
            SetStrokeCommand setStrokeCommand = (SetStrokeCommand)command;
            this.elements.add(EPSDocument.getOutput((Stroke)setStrokeCommand.getValue()));
        } else if (command instanceof SetTransformCommand) {
            SetTransformCommand setTransformCommand = (SetTransformCommand)command;
            StringBuilder stringBuilder = new StringBuilder();
            double[] dArray = new double[6];
            ((AffineTransform)setTransformCommand.getValue()).getMatrix(dArray);
            stringBuilder.append("basematrix setmatrix [").append(DataUtils.join(" ", dArray)).append("] concat");
            this.elements.add(stringBuilder.toString());
        } else if (command instanceof RotateCommand) {
            boolean bl;
            RotateCommand rotateCommand = (RotateCommand)command;
            StringBuilder stringBuilder = new StringBuilder();
            double d = rotateCommand.getCenterX();
            double d2 = rotateCommand.getCenterY();
            boolean bl2 = bl = d != 0.0 || d2 != 0.0;
            if (bl) {
                stringBuilder.append(d).append(" ").append(d2).append(" translate ");
            }
            stringBuilder.append(Math.toDegrees(rotateCommand.getTheta())).append(" rotate");
            if (bl) {
                stringBuilder.append(" ");
                stringBuilder.append(-d).append(" ").append(-d2).append(" translate");
            }
            this.elements.add(stringBuilder.toString());
        } else if (command instanceof ScaleCommand) {
            ScaleCommand scaleCommand = (ScaleCommand)command;
            this.elements.add(DataUtils.format(scaleCommand.getScaleX()) + " " + DataUtils.format(scaleCommand.getScaleY()) + " scale");
        } else if (command instanceof ShearCommand) {
            ShearCommand shearCommand = (ShearCommand)command;
            this.elements.add("[1 " + DataUtils.format(shearCommand.getShearY()) + " " + DataUtils.format(shearCommand.getShearX()) + " 1 0 0] concat");
        } else if (command instanceof TransformCommand) {
            TransformCommand transformCommand = (TransformCommand)command;
            StringBuilder stringBuilder = new StringBuilder();
            double[] dArray = new double[6];
            ((AffineTransform)transformCommand.getValue()).getMatrix(dArray);
            stringBuilder.append("[").append(DataUtils.join(" ", dArray)).append("] concat");
            this.elements.add(stringBuilder.toString());
        } else if (command instanceof TranslateCommand) {
            TranslateCommand translateCommand = (TranslateCommand)command;
            this.elements.add(String.valueOf(translateCommand.getDeltaX()) + " " + translateCommand.getDeltaY() + " translate");
        } else if (command instanceof DrawImageCommand) {
            DrawImageCommand drawImageCommand = (DrawImageCommand)command;
            String string = EPSDocument.getOutput((Image)drawImageCommand.getValue(), drawImageCommand.getImageWidth(), drawImageCommand.getImageHeight(), drawImageCommand.getX(), drawImageCommand.getY(), drawImageCommand.getWidth(), drawImageCommand.getHeight());
            this.elements.add(string);
        } else if (command instanceof DrawShapeCommand) {
            DrawShapeCommand drawShapeCommand = (DrawShapeCommand)command;
            this.elements.add(EPSDocument.getOutput((Shape)drawShapeCommand.getValue()) + " stroke");
        } else if (command instanceof DrawStringCommand) {
            DrawStringCommand drawStringCommand = (DrawStringCommand)command;
            this.elements.add(EPSDocument.getOutput((String)drawStringCommand.getValue(), drawStringCommand.getX(), drawStringCommand.getY()));
        } else if (command instanceof FillShapeCommand) {
            FillShapeCommand fillShapeCommand = (FillShapeCommand)command;
            this.elements.add(EPSDocument.getOutput((Shape)fillShapeCommand.getValue()) + " fill");
        } else if (command instanceof CreateCommand) {
            this.elements.add("gsave");
        } else if (command instanceof DisposeCommand) {
            this.elements.add("grestore");
        }
    }

    private static String getOutput(Color color) {
        if (color.getColorSpace().getType() == 9) {
            float[] fArray = color.getComponents(null);
            return String.format((Locale)null, "%f %f %f %f cmyk", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
        }
        return String.format((Locale)null, "%f %f %f rgb", Float.valueOf((float)color.getRed() / 255.0f), Float.valueOf((float)color.getGreen() / 255.0f), Float.valueOf((float)color.getBlue() / 255.0f));
    }

    private static String getOutput(Shape shape) {
        StringBuilder stringBuilder;
        block10: {
            block13: {
                double d;
                double d2;
                Arc2D arc2D;
                block14: {
                    block12: {
                        block11: {
                            block9: {
                                stringBuilder = new StringBuilder();
                                stringBuilder.append("newpath ");
                                if (!(shape instanceof Line2D)) break block9;
                                Line2D line2D = (Line2D)shape;
                                stringBuilder.append(line2D.getX1()).append(" ").append(line2D.getY1()).append(" M ").append(line2D.getX2()).append(" ").append(line2D.getY2()).append(" L");
                                break block10;
                            }
                            if (!(shape instanceof Rectangle2D)) break block11;
                            Rectangle2D rectangle2D = (Rectangle2D)shape;
                            stringBuilder.append(rectangle2D.getX()).append(" ").append(rectangle2D.getY()).append(" ").append(rectangle2D.getWidth()).append(" ").append(rectangle2D.getHeight()).append(" rect Z");
                            break block10;
                        }
                        if (!(shape instanceof Ellipse2D)) break block12;
                        Ellipse2D ellipse2D = (Ellipse2D)shape;
                        double d3 = ellipse2D.getX() + ellipse2D.getWidth() / 2.0;
                        double d4 = ellipse2D.getY() + ellipse2D.getHeight() / 2.0;
                        double d5 = ellipse2D.getWidth() / 2.0;
                        double d6 = ellipse2D.getHeight() / 2.0;
                        stringBuilder.append(d3).append(" ").append(d4).append(" ").append(d5).append(" ").append(d6).append(" ").append(360.0).append(" ").append(0.0).append(" ellipse Z");
                        break block10;
                    }
                    if (!(shape instanceof Arc2D)) break block13;
                    arc2D = (Arc2D)shape;
                    d2 = arc2D.getX() + arc2D.getWidth() / 2.0;
                    d = arc2D.getY() + arc2D.getHeight() / 2.0;
                    double d7 = arc2D.getWidth() / 2.0;
                    double d8 = arc2D.getHeight() / 2.0;
                    double d9 = -arc2D.getAngleStart();
                    double d10 = -(arc2D.getAngleStart() + arc2D.getAngleExtent());
                    stringBuilder.append(d2).append(" ").append(d).append(" ").append(d7).append(" ").append(d8).append(" ").append(d9).append(" ").append(d10).append(" ellipse");
                    if (arc2D.getArcType() != 1) break block14;
                    stringBuilder.append(" Z");
                    break block10;
                }
                if (arc2D.getArcType() != 2) break block10;
                stringBuilder.append(" ").append(d2).append(" ").append(d).append(" L Z");
                break block10;
            }
            PathIterator pathIterator = shape.getPathIterator(null);
            double[] dArray = new double[6];
            double[] dArray2 = new double[2];
            int n = 0;
            while (!pathIterator.isDone()) {
                if (n > 0) {
                    stringBuilder.append(" ");
                }
                int n2 = pathIterator.currentSegment(dArray);
                switch (n2) {
                    case 0: {
                        stringBuilder.append(dArray[0]).append(" ").append(dArray[1]).append(" M");
                        dArray2[0] = dArray[0];
                        dArray2[1] = dArray[1];
                        break;
                    }
                    case 1: {
                        stringBuilder.append(dArray[0]).append(" ").append(dArray[1]).append(" L");
                        dArray2[0] = dArray[0];
                        dArray2[1] = dArray[1];
                        break;
                    }
                    case 3: {
                        stringBuilder.append(dArray[0]).append(" ").append(dArray[1]).append(" ").append(dArray[2]).append(" ").append(dArray[3]).append(" ").append(dArray[4]).append(" ").append(dArray[5]).append(" C");
                        dArray2[0] = dArray[4];
                        dArray2[1] = dArray[5];
                        break;
                    }
                    case 2: {
                        double d = dArray2[0] + 0.6666666666666666 * (dArray[0] - dArray2[0]);
                        double d11 = dArray2[1] + 0.6666666666666666 * (dArray[1] - dArray2[1]);
                        double d12 = dArray[0] + 0.3333333333333333 * (dArray[2] - dArray[0]);
                        double d13 = dArray[1] + 0.3333333333333333 * (dArray[3] - dArray[1]);
                        double d14 = dArray[2];
                        double d15 = dArray[3];
                        stringBuilder.append(d).append(" ").append(d11).append(" ").append(d12).append(" ").append(d13).append(" ").append(d14).append(" ").append(d15).append(" C");
                        dArray2[0] = d14;
                        dArray2[1] = d15;
                        break;
                    }
                    case 4: {
                        stringBuilder.append("Z");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown path operation.");
                    }
                }
                ++n;
                pathIterator.next();
            }
        }
        return stringBuilder.toString();
    }

    private static String getOutput(Image image, int n, int n2, double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedImage bufferedImage = GraphicsUtils.toBufferedImage(image);
        int n3 = bufferedImage.getSampleModel().getNumBands();
        int n4 = DataUtils.max(bufferedImage.getSampleModel().getSampleSize());
        n4 = (int)(Math.ceil((double)n4 / 8.0) * 8.0);
        if (n3 > 3) {
            n3 = 3;
        }
        stringBuilder.append("gsave").append(EOL);
        if (d != 0.0 || d2 != 0.0) {
            stringBuilder.append(d).append(" ").append(d2).append(" translate").append(EOL);
        }
        if (d3 != 1.0 || d4 != 1.0) {
            stringBuilder.append(d3).append(" ").append(d4).append(" scale").append(EOL);
        }
        int n5 = 1;
        if (bufferedImage.getColorModel().hasAlpha()) {
            stringBuilder.append("<< /ImageType 3 /InterleaveType 1 ").append("/MaskDict ").append(n).append(" ").append(n2).append(" ").append(1).append(" ").append(n4).append(" ").append(n5).append(" ").append(false).append(" ").append(0).append(" imgdict ").append("/DataDict ").append(n).append(" ").append(n2).append(" ").append(n3).append(" ").append(n4).append(" ").append(n5).append(" ").append(true).append(" currentfile /ASCII85Decode filter ").append("<< /BitsPerComponent ").append(n4).append(" >> ").append("/FlateDecode filter ").append("imgdict ").append(">> image").append(EOL);
            bufferedImage = new AlphaToMaskOp(true).filter(bufferedImage, null);
            EPSDocument.output(bufferedImage, stringBuilder);
        } else {
            if (n3 == 1) {
                stringBuilder.append("/DeviceGray setcolorspace").append(EOL);
            }
            if (bufferedImage.getType() == 12) {
                n5 = 255;
            }
            stringBuilder.append(n).append(" ").append(n2).append(" ").append(n3).append(" ").append(n4).append(" ").append(n5).append(" ").append(true).append(" currentfile /ASCII85Decode filter ").append("<< /BitsPerComponent ").append(n4).append(" >> ").append("/FlateDecode filter ").append("imgdict ").append("image").append(EOL);
            EPSDocument.output(bufferedImage, stringBuilder);
        }
        stringBuilder.append("grestore");
        return stringBuilder.toString();
    }

    private static void output(BufferedImage bufferedImage, StringBuilder stringBuilder) {
        ImageDataStream imageDataStream = new ImageDataStream(bufferedImage, ImageDataStream.Interleaving.SAMPLE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FlateEncodeStream flateEncodeStream = new FlateEncodeStream(new ASCII85EncodeStream(new LineWrapOutputStream(byteArrayOutputStream, 80)));
        try {
            DataUtils.transfer(imageDataStream, flateEncodeStream, 1024);
            ((OutputStream)flateEncodeStream).close();
            String string = byteArrayOutputStream.toString(CHARSET);
            stringBuilder.append(string).append(EOL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String getOutput(String string, double d, double d2) {
        return "gsave 1 -1 scale " + d + " " + -d2 + " M " + EPSDocument.getOutput(string) + " show " + "grestore";
    }

    private static StringBuilder getOutput(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        string = string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("[\r\n]", "");
        stringBuilder.append("(").append(string).append(")");
        return stringBuilder;
    }

    private static String getOutput(Stroke stroke) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            stringBuilder.append(basicStroke.getLineWidth()).append(" setlinewidth ").append(STROKE_LINEJOIN.get(basicStroke.getLineJoin())).append(" setlinejoin ").append(STROKE_ENDCAPS.get(basicStroke.getEndCap())).append(" setlinecap ").append("[").append(DataUtils.join(" ", basicStroke.getDashArray())).append("] ").append(basicStroke.getDashPhase()).append(" setdash");
        } else {
            stringBuilder.append("% Custom strokes aren't supported at the moment");
        }
        return stringBuilder.toString();
    }

    private static String getOutput(Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        font = GraphicsUtils.getPhysicalFont(font);
        String string = font.getPSName();
        String string2 = string + FONT_LATIN1_SUFFIX;
        stringBuilder.append("/").append(string2).append(" ").append("/").append(font.getPSName()).append(" latinize ");
        stringBuilder.append("/").append(string2).append(" ").append(font.getSize2D()).append(" selectfont");
        return stringBuilder.toString();
    }
}

