#ifndef __NJB__ERROR__H
#define __NJB__ERROR__H

#include <stdio.h>
#include "libnjb.h"
#include "njbusb.h"

#define MAX_ERRLEN	128
#define MAX_ERRORS	16

void njb_error_add (const char *sub, int err);
void njb_error_add2 (const char *sub, const char *prefix, int err);
void njb_error_add3 (const char *sub, const char *prefix, const 
	char *suffix, int err);
void njb_error_clear (void);
void njb_error_status (const char *sub, unsigned char code);


#define NJB_ERROR(a) njb_error_add(subroutinename,a)
#define NJB_ERROR2(a,b) njb_error_add2(subroutinename,a,b)
#define NJB_ERROR3(a,b,c) njb_error_add3(subroutinename,a,b,c)
#define NJB_STATUS(a) njb_error_status(subroutinename,a)

#define NJB_RERROR(a,b) njb_error_add(a,b)

#endif

