#include "osl/container/ptypeOPositionVector.h"
#include "osl/eval/pieceEval.h"
#include <algorithm>

namespace osl
{
  struct PtypeOPositionLessThan
  {
    bool operator()(const std::pair<PtypeO,Position>& l,
		    const std::pair<PtypeO,Position>& r)
    {
      const int vall = abs(eval::Ptype_Eval_Table.captureValue(l.first));
      const int valr = abs(eval::Ptype_Eval_Table.captureValue(r.first));
      if (vall != valr)
	return vall < valr;
      return l.second.uintValue() < r.second.uintValue();
    }
  };

  void container::PtypeOPositionVector::sort()
  {
    std::sort(begin(),end(),PtypeOPositionLessThan());
  }

}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
