/* numSimpleEffect.cc
 */
#include "osl/effect/numSimpleEffect.h"

void osl::effect::
NumSimpleEffectTable::init(const SimpleState& state)
{
  std::fill(effects.begin(), effects.end(),NumBitmapEffect());
  for(int num=0;num<40;num++){
    if (state.isOnBoard(num)){
      Piece p=state.getPieceOf(num);
#if 0
      doEffect<NumBitmapEffect::Add,false>(state,p);
#else
      doEffect<NumBitmapEffect::Add,true>(state,p);
#endif
    }
  }
}

bool osl::effect::operator==(const NumSimpleEffectTable& et1,const NumSimpleEffectTable& et2)
{
  for(int y=1;y<=9;y++)
    for(int x=9;x>0;x--){
      Position pos(x,y);
      if (!(et1.getEffect(pos)==et2.getEffect(pos))) return false;
    }
  if (! (et1.effected_mask == et2.effected_mask))
    return false;
  if(!(et1.mobilityTable==et2.mobilityTable)) return false;
  if(!(et1.effectedNumTable==et2.effectedNumTable)) return false;
  // intentionally ignore history dependent members: changed_effects, changed_effect_pieces, effected_changed_mask
  return true;
}

#ifndef MINIMAL
std::ostream& osl::effect::operator<<(std::ostream& os,const NumSimpleEffectTable& effectTable)
{
  os << "Effect" << std::endl;
  for(int y=1;y<=9;y++){
    for(int x=9;x>0;x--){
      Position pos(x,y);
      os << effectTable.getEffect(pos) << " ";
    }
    os << std::endl;
  }
  os << "Effect" << std::endl;
  for(int y=1;y<=9;y++){
    for(int x=9;x>0;x--){
      Position pos(x,y);
      os << effectTable.getEffect(pos) << " ";
    }
    os << std::endl;
  }
  return os;
}
#endif
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
