/* checkmate.cc
 */
#include "osl/rating/feature/checkmate.h"
#include "osl/apply_move/applyMove.h"
#include "osl/effect_util/neighboring8Direct.h"
#include "osl/neighboring8.h"

struct osl::rating::Threatmate::Helper
{
  bool *result;
  NumEffectState *state;
  void operator()(Position) 
  {
    if (state->inCheck(state->getTurn())
	|| state->inCheck(alt(state->getTurn()))) {
      result = false;
      return;
    }
    state->changeTurn();
    *result = ImmediateCheckmate::hasCheckmateMove(state->getTurn(), *state);
    state->changeTurn();
  }
};

bool osl::rating::
Threatmate::knight2Step(const NumEffectState& state, Move move, Position king) 
{
  if (move.ptype() != KNIGHT)
    return false;
  const int y = king.y() + playerToMul(state.getTurn())*4;
  if (y != move.to().y())
    return false;
  const int x = move.to().x();
  return (x == king.x() || abs(king.x() - x) == 2);
}
bool osl::rating::
Threatmate::captureForKnightCheck(const NumEffectState& state, Move move, Position king)
{
  const Player defender = alt(state.getTurn());
  const CArray<Position,2> knight_position = {{
      Board_Table.nextPosition(defender, king, UUR),
      Board_Table.nextPosition(defender, king, UUL)
    }};
  const Piece captured = state.getPieceOnBoard(move.to());
  assert(captured.isPiece());
  for (int i=0; i<2; ++i) {
    const Position kp = knight_position[i];
    const Piece p = state.getPieceAt(kp);
    if (state.hasEffectNotBy(defender, captured, kp))
      continue;
    if (p.isEmpty()
	&& (unpromote(move.capturePtype()) == KNIGHT
	    || state.hasPieceOnStand<KNIGHT>(state.getTurn())))
      return true;
    if (p.canMoveOn(state.getTurn())
	&& state.hasEffectByPtypeStrict<KNIGHT>(state.getTurn(), kp))
      return true;
  }
  return false;
}

bool osl::rating::Threatmate::isCandidate(const NumEffectState& state, Move move) 
{
  const Player defender = alt(state.getTurn());
  const Position king = state.getKingPosition(defender);
  if (Neighboring8Direct::hasEffectOrAdditional(state, move.ptypeO(), move.to(), king)
      || Neighboring8::isNeighboring8(move.to(), king)
      || state.selectLong(move.to(), alt(state.getTurn())).any() // todo: refinement
      || (! move.isDrop() && state.selectLong(move.from(), state.getTurn()).any()) // todo: refinement
    )
    return true;
  if (move.capturePtype() != PTYPE_EMPTY
      && Neighboring8Direct::hasEffectOrAdditional(state, move.capturePtypeO(), move.to(), king))
    return true;

  const King8Info info(state.king8Info(defender));
  if (move.capturePtype() != PTYPE_EMPTY
      && (info.dropCandidate()
	  || (info.liberty() == 0 && captureForKnightCheck(state, move, king))))
    return true;
  if (state.inCheck()
      && (info.dropCandidate() || info.moveCandidate2() 
	  || /* only when hand knight or knight effect */info.liberty() == 0))
    return true;
  if (info.liberty() == 0
      && (knight2Step(state, move, king)
	  || (! move.isDrop()
	      && ((state.hasPieceOnStand<KNIGHT>(state.getTurn())
		   && state.hasEffectFromTo(newPtypeO(state.getTurn(),KNIGHT), move.from(), king))
		  || state.hasEffectByPtypeStrict<KNIGHT>(state.getTurn(), move.from())))))
    return true;
  return false;
}

bool osl::rating::Threatmate::match(const NumEffectState& cstate, Move move, 
				    const RatingEnv&) const
{
  NumEffectState& state = const_cast<NumEffectState&>(cstate);
  if (! isCandidate(cstate, move))
    return false;
  bool result = false;
  Helper helper = { &result, &state };
  ApplyMoveOfTurn::doUndoMove(state, move, helper);
#ifdef OSL_DEBUG
  if (result && ! isCandidate(cstate, move))
    std::cerr << cstate << move << "\n", assert(0);
#endif
  return result;
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
