/* effect5x3.t.cc
 */
#include "osl/progress/effect5x3d.h"
#include "consistencyTest.h"
#include "osl/state/numEffectState.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/oslConfig.h"
#include <fstream>
#include <string>
#include <iostream>

#include <cppunit/TestCase.h>

class ProgressEffect5x3dTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(ProgressEffect5x3dTest);
  CPPUNIT_TEST(testConsistentUpdate);
  CPPUNIT_TEST(testMakeProgress);
  CPPUNIT_TEST_SUITE_END();
public:
  void testLoad();
  void testConsistentUpdate();
  void testMakeProgress();
};

CPPUNIT_TEST_SUITE_REGISTRATION(ProgressEffect5x3dTest);

using namespace osl;
using namespace osl::progress;

void ProgressEffect5x3dTest::testConsistentUpdate()
{
  consistencyTestUpdate<Effect5x3d>();
}

static int slowMakeProgress(Player defense, const NumEffectState& state,
				  Square king)
{  
  const Square center = Centering5x3::adjustCenter(king);

  const int min_x = center.x() - 2;
  const int max_x = center.x() + 2;
  const int min_y = center.y() - 1;
  const int max_y = center.y() + 1;


  // 利き
  int sum_effect = 0;

  for (int x=min_x; x<=max_x; ++x)
    {
      for (int y=min_y; y<=max_y; ++y)
	{
	  const Square target(x,y);
	  sum_effect += state.countEffect(defense, target) * 16;
	  sum_effect -= (state.countEffect(defense, target) *
			 std::abs(king.x() - x));
	}
    }
  return sum_effect / 2;
}

void ProgressEffect5x3dTest::testMakeProgress()
{
  using namespace osl;

  std::ifstream ifs(OslConfig::testCsaFile("FILES"));
  CPPUNIT_ASSERT(ifs);
  std::string file_name;
  for (int i=0;i<(OslConfig::inUnitTestShort() ? 10 : 200) && (ifs >> file_name) ; i++)
  {
    if (file_name == "") 
      break;
    file_name = OslConfig::testCsaFile(file_name);

    const Record rec=CsaFile(file_name).getRecord();
    const vector<osl::Move> moves=rec.getMoves();

    NumEffectState state(rec.getInitialState());
    
    for (unsigned int i=0; i<moves.size(); i++){
      const Move m = moves[i];
      state.makeMove(m);
      const Square bk=state.kingSquare(BLACK);
      const Square wk=state.kingSquare(WHITE);
      int w0=osl::progress::Effect5x3d::makeProgress(WHITE,state,wk);
      int w1=slowMakeProgress(WHITE,state,wk);
      CPPUNIT_ASSERT_EQUAL(w0,w1);
      int b0=osl::progress::Effect5x3d::makeProgress(BLACK,state,bk);
      int b1=slowMakeProgress(BLACK,state,bk);
      CPPUNIT_ASSERT_EQUAL(b0,b1);
    }
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
