//**************************************************************************
/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
/*! \file TePGUtils.h
    This file contains a database driver to access PostGIS extension.
 */

/**
  *@author Gilberto Ribeiro de Queiroz - gribeiro@dpi.inpe.br
  */

/**
  *@description Este arquivo contm rotinas teis que desenvolvi para converso 
  *             entre os tipos de dados do PostGIS e da TerraLib. Estas funes
  *             so parsers simples.
  */

#ifndef  __TERRALIB_INTERNAL_TePOSTGRESQLUTILS_H
#define  __TERRALIB_INTERNAL_TePOSTGRESQLUTILS_H

#include "TeGeometry.h"

#define COORDS_DELIM		','

#define COORD_DELIM			' '

#define LINES_DELIM		','

#define LDELIM_POINT		'('
#define RDELIM_POINT		')'

#define LDELIM_LINESTRING	'('
#define RDELIM_LINESTRING	')'

#define LDELIM_POLYGON		'('
#define RDELIM_POLYGON		')'

#define LDELIM_BOX			'('
#define RDELIM_BOX			')'

// DELIMITADORES PARA TIPOS GEOMTRICOS DO POSTGRESQL
#define LDELIM_PGGEOMPOLYGON       '('
#define RDELIM_PGGEOMPOLYGON       ')'

#define PGGEOMPOLYGON_COORDS_DELIM ','

/*
 * Codificadores e decodificadores de tipos geomtricos do PostgreSQL.
 * Essas funes so para o driver sem extenso espacial.
 *
 */

//! Decodifica uma coordenada no formato polgono dos tipos geomtricos do PostgreSQL: (x1, y1)
TeCoord2D PgGeomPolygonCoordDecode(char *str, char* *s);

//! Transaforma a linha l em um polgono texto strPolygon
void Te2PgGeomPolygon(const TeLine2D& l, string& strPolygon);

//! Transaforma um polgono texto strPolygon em uma linha
TeLine2D PgGeomPolygon2Te(char* strPolygon);

/*
 * Codificadores e decodificadores PostGIS - Texto
 * 
 */
TeCoord2D PGCoord_decode(char *str, char* *s);

string PGCoord_encode(const TeCoord2D& c);

TePoint PGPoint_decode(char *str);

string PGPoint_encode(const TePoint& p);

string PGNode_encode(const TeNode& p);

TeLine2D PGLine_decode(char *str, char* *sd);

TeLine2D PGLinestring_decode(char *str);

TePolygon PGPolygon_decode(char *str);

TeBox PGBox_decode(char *str);

string PGBox_encode(TeBox& b);

void PGConcatLineString(const TeLine2D& l, string& concatString);

TeBox PGBoxFromPolygon(char *str);

string PGMakePolygon(const TeBox& box);


#endif	// __TERRALIB_INTERNAL_TePOSTGRESQLUTILS_H

