/*  tilp - link program for TI calculators
 *  Copyright (C) 1999-2001  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This file include some dependant OS headers files.
  There are few things because the GLIb is used finally.
*/

#ifndef __TI68K_TILIBS__
#define __TI68K_TILIBS__

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef HAVE_TILP_TYPEDEFS_H
# include <tilp/cabl_int.h>
# include <tilp/calc_int.h>
# include <tilp/defsxx.h>
# include <tilp/calc_err.h> // to use ERR_VOID_FUNCTION
#elif defined(__WIN32__)
# include "cabl_int.h"
# include "calc_int.h"
# include "defsxx.h"
# include "calc_err.h"
#else
# include "cabl/cabl_int.h"
# include "calc/calc_int.h"
# include "calc/defsxx.h"
# include "calc/calc_err.h"
#endif

#endif

