/*  tiffep - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_HFILES__
#define __TIFFEP_HFILES__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "str.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef __WIN32__
# include <process.h>   // for getpid()
#elif defined(__LINUX__)
# include <unistd.h>
#endif
#include <glib.h>

#include "export.h"  // symbol export macros
#include "macros.h"  // useful macros
#include "tiffep_ver.h" // TiFFEP version number
#include "tiffep_paths.h"   // some file paths
#include "intl.h"    // i18n support
#include "verbose.h" // DISPLAY function

#include "types.h"     // some type definitions
#include "defsxx.h"    // calculator definitions
#include "com_defs.h"  // Unix/Win32 common type definitions
#include "com_types.h" // common TI calculator var types
#include "commands.h"
#include "errcodes.h"  // error codes & messages
#include "tiffep_err.h"     // error function
#include "messages.h"
#include "perror.h"    // Win32 only
#include "shm.h"       // Shared Memory support (Linux/Win32)
#include "sock.h"      // Socket support (Linux/Win32)
#include "calc_defs.h" // some constant definition
#include "reg_file.h"  // registry functions
#include "ti_files.h"  // structure & functions for handling TI file
#include "ti_vars.h"   // structure & functions for handling TI variables
#include "trans.h"     // translation of variable names
#include "interface.h" // the interface of the library
#include "misc_fncts.h"      // some miscellaneous functions


#endif
