/* libtinymail-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Tny", lower_case_cprefix = "tny_")]
namespace Tny {
	[CCode (cprefix = "TNY_ACCOUNT_", cheader_filename = "tny.h")]
	public enum AccountSignal {
		CONNECTION_STATUS_CHANGED,
		CHANGED,
		LAST_SIGNAL,
	}
	[CCode (cprefix = "TNY_ACCOUNT_TYPE_", cheader_filename = "tny.h")]
	public enum AccountType {
		STORE,
		TRANSPORT,
	}
	[CCode (cprefix = "TNY_ALERT_TYPE_", cheader_filename = "tny.h")]
	public enum AlertType {
		INFO,
		WARNING,
		ERROR,
	}
	[CCode (cprefix = "TNY_CONNECTION_STATUS_", cheader_filename = "tny.h")]
	public enum ConnectionStatus {
		DISCONNECTED,
		DISCONNECTED_BROKEN,
		CONNECTED_BROKEN,
		CONNECTED,
		RECONNECTING,
		INIT,
	}
	[CCode (cprefix = "TNY_", cheader_filename = "tny.h")]
	public enum Error {
		ERROR_UNSPEC,
		FOLDER_ERROR_SYNC,
		FOLDER_ERROR_REMOVE_MSG,
		FOLDER_ERROR_REMOVE_MSGS,
		FOLDER_ERROR_ADD_MSG,
		FOLDER_ERROR_REFRESH,
		FOLDER_ERROR_GET_MSG,
		FOLDER_ERROR_TRANSFER_MSGS,
		FOLDER_ERROR_SET_NAME,
		FOLDER_ERROR_COPY,
		FOLDER_STORE_ERROR_REMOVE_FOLDER,
		FOLDER_STORE_ERROR_GET_FOLDERS,
		FOLDER_STORE_ERROR_CREATE_FOLDER,
		TRANSPORT_ACCOUNT_ERROR_SEND,
		TRANSPORT_ACCOUNT_ERROR_SEND_HOST_LOOKUP_FAILED,
		TRANSPORT_ACCOUNT_ERROR_SEND_SERVICE_UNAVAILABLE,
		TRANSPORT_ACCOUNT_ERROR_SEND_AUTHENTICATION_NOT_SUPPORTED,
		ACCOUNT_ERROR_TRY_CONNECT_SEND_USER_CANCEL,
		ACCOUNT_ERROR_TRY_CONNECT,
		ACCOUNT_ERROR_TRY_CONNECT_HOST_LOOKUP_FAILED,
		ACCOUNT_ERROR_TRY_CONNECT_SERVICE_UNAVAILABLE,
		ACCOUNT_ERROR_TRY_CONNECT_AUTHENTICATION_NOT_SUPPORTED,
		ACCOUNT_ERROR_TRY_CONNECT_CERTIFICATE,
		ACCOUNT_ERROR_TRY_CONNECT_USER_CANCEL,
		ACCOUNT_STORE_ERROR_UNKNOWN_ALERT,
		SEND_QUEUE_ERROR_ADD,
		ACCOUNT_STORE_ERROR_CANCEL_ALERT,
		ACCOUNT_ERROR_GET_SUPPORTED_AUTH,
	}
	[CCode (cprefix = "TNY_", cheader_filename = "tny.h")]
	public enum ErrorDomain {
		FOLDER_ERROR,
		FOLDER_STORE_ERROR,
		TRANSPORT_ACCOUNT_ERROR,
		ACCOUNT_ERROR,
		ACCOUNT_STORE_ERROR,
		SEND_QUEUE_ERROR,
	}
	[CCode (cprefix = "TNY_FOLDER_", cheader_filename = "tny.h")]
	public enum FolderSignal {
		FOLDER_INSERTED,
		FOLDERS_RELOADED,
		LAST_SIGNAL,
	}
	[CCode (cprefix = "TNY_FOLDER_TYPE_", cheader_filename = "tny.h")]
	public enum FolderType {
		UNKNOWN,
		NORMAL,
		INBOX,
		OUTBOX,
		TRASH,
		JUNK,
		SENT,
		ROOT,
		NOTES,
		DRAFTS,
		CONTACTS,
		CALENDAR,
		ARCHIVE,
		MERGE,
	}
	[CCode (cprefix = "TNY_ACCOUNT_STORE_", cheader_filename = "tny.h")]
	public enum GetAccountsRequestType {
		TRANSPORT_ACCOUNTS,
		STORE_ACCOUNTS,
		BOTH,
	}
	[CCode (cprefix = "TNY_", cheader_filename = "tny.h")]
	public enum StatusCode {
		FOLDER_STATUS_CODE_REFRESH,
		FOLDER_STATUS_CODE_GET_MSG,
		GET_MSG_QUEUE_STATUS_GET_MSG,
		FOLDER_STATUS_CODE_XFER_MSGS,
		FOLDER_STATUS_CODE_COPY_FOLDER,
		GET_SUPPORTED_SECURE_AUTH_STATUS_GET_SECURE_AUTH,
		FOLDER_STATUS_CODE_SYNC,
	}
	[CCode (cprefix = "TNY_", cheader_filename = "tny.h")]
	public enum StatusDomain {
		FOLDER_STATUS,
		GET_MSG_QUEUE_STATUS,
		GET_SUPPORTED_SECURE_AUTH_STATUS,
	}
	[CCode (cprefix = "TNY_FOLDER_CAPS_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderCaps {
		WRITABLE,
		PUSHEMAIL,
	}
	[CCode (cprefix = "TNY_FOLDER_CHANGE_CHANGED_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderChangeChanged {
		ALL_COUNT,
		UNREAD_COUNT,
		ADDED_HEADERS,
		EXPUNGED_HEADERS,
		FOLDER_RENAME,
		MSG_RECEIVED,
	}
	[CCode (cprefix = "TNY_FOLDER_STORE_CHANGE_CHANGED_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderStoreChangeChanged {
		CREATED_FOLDERS,
		REMOVED_FOLDERS,
	}
	[CCode (cprefix = "TNY_FOLDER_STORE_QUERY_OPTION_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderStoreQueryOption {
		SUBSCRIBED,
		UNSUBSCRIBED,
		MATCH_ON_NAME,
		MATCH_ON_ID,
		PATTERN_IS_CASE_INSENSITIVE,
		PATTERN_IS_REGEX,
	}
	[CCode (cprefix = "TNY_HEADER_FLAG_", cheader_filename = "tny.h")]
	[Flags]
	public enum HeaderFlags {
		ANSWERED,
		DELETED,
		DRAFT,
		FLAGGED,
		SEEN,
		ATTACHMENTS,
		CACHED,
		PARTIAL,
		EXPUNGED,
		HIGH_PRIORITY,
		NORMAL_PRIORITY,
		LOW_PRIORITY,
		SUSPENDED,
	}
	[CCode (copy_function = "tny_status_copy", cheader_filename = "tny.h")]
	public class Status {
		public GLib.Quark domain;
		public int code;
		public weak string message;
		public uint position;
		public uint of_total;
		public weak Tny.Status copy ();
		public double get_fraction ();
		public bool matches (GLib.Quark domain, int code);
		public Status (GLib.Quark domain, int code, uint position, uint of_total, string format);
		public Status.literal (GLib.Quark domain, int code, uint position, uint of_total, string message);
		public void set_fraction (double fraction);
	}
	[CCode (cheader_filename = "tny.h")]
	public class CombinedAccount : GLib.Object, Tny.Account, Tny.FolderStore, Tny.StoreAccount, Tny.TransportAccount {
		public weak Tny.StoreAccount get_store_account ();
		public weak Tny.TransportAccount get_transport_account ();
		public CombinedAccount (Tny.TransportAccount ta, Tny.StoreAccount sa);
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderChange : GLib.Object {
		public void add_added_header (Tny.Header header);
		public void add_expunged_header (Tny.Header header);
		public void get_added_headers (Tny.List headers);
		public Tny.FolderChangeChanged get_changed ();
		public void get_expunged_headers (Tny.List headers);
		public weak Tny.Folder get_folder ();
		public uint get_new_all_count ();
		public uint get_new_unread_count ();
		public weak Tny.Msg get_received_msg ();
		public weak string get_rename (string oldname);
		public FolderChange (Tny.Folder folder);
		public void reset ();
		public void set_new_all_count (uint new_all_count);
		public void set_new_unread_count (uint new_unread_count);
		public void set_received_msg (Tny.Msg msg);
		public void set_rename (string newname);
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderMonitor : GLib.Object, Tny.FolderObserver {
		public void add_list (Tny.List list);
		public FolderMonitor (Tny.Folder folder);
		public void poke_status ();
		public void remove_list (Tny.List list);
		public void start ();
		public void stop ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStats : GLib.Object {
		public uint get_all_count ();
		public weak Tny.Folder get_folder ();
		public ulong get_local_size ();
		public uint get_unread_count ();
		public FolderStats (Tny.Folder folder);
		public void set_local_size (ulong local_size);
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStoreChange : GLib.Object {
		public void add_created_folder (Tny.Folder folder);
		public void add_removed_folder (Tny.Folder folder);
		public Tny.FolderStoreChangeChanged get_changed ();
		public void get_created_folders (Tny.List folders);
		public weak Tny.FolderStore get_folder_store ();
		public void get_removed_folders (Tny.List folders);
		public FolderStoreChange (Tny.FolderStore folderstore);
		public void reset ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStoreQuery : GLib.Object {
		public weak Tny.List items;
		public void add_item (string pattern, Tny.FolderStoreQueryOption options);
		public weak Tny.List get_items ();
		public FolderStoreQuery ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStoreQueryItem : GLib.Object {
		public Tny.FolderStoreQueryOption options;
		public pointer regex;
		public weak string pattern;
		public Tny.FolderStoreQueryOption get_options ();
		public weak string get_pattern ();
		public pointer get_regex ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FsStream : GLib.Object, Tny.Stream {
		public FsStream (int fd);
		public void set_fd (int fd);
	}
	[CCode (cheader_filename = "tny.h")]
	public class MergeFolder : GLib.Object, Tny.Folder, Tny.FolderObserver {
		public void add_folder (Tny.Folder folder);
		public void get_folders (Tny.List list);
		public MergeFolder (string folder_name);
		public MergeFolder.with_ui_locker (string folder_name, Tny.Lockable ui_locker);
		public void remove_folder (Tny.Folder folder);
		public void set_folder_type (Tny.FolderType folder_type);
		public void set_ui_locker (Tny.Lockable ui_locker);
	}
	[CCode (cheader_filename = "tny.h")]
	public class NoopLockable : GLib.Object, Tny.Lockable {
		public NoopLockable ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class Pair : GLib.Object {
		public weak string get_name ();
		public weak string get_value ();
		public Pair (string name, string value);
		public void set_name (string name);
		public void set_value (string value);
	}
	[CCode (cheader_filename = "tny.h")]
	public class SimpleList : GLib.Object, Tny.List {
		public SimpleList ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Account : GLib.Object {
		public void cancel ();
		public Tny.AccountType get_account_type ();
		public weak Tny.ConnectionPolicy get_connection_policy ();
		public Tny.ConnectionStatus get_connection_status ();
		public Tny.ForgetPassFunc get_forget_pass_func ();
		public weak string get_hostname ();
		public weak string get_id ();
		public weak string get_name ();
		public Tny.GetPassFunc get_pass_func ();
		public uint get_port ();
		public weak string get_proto ();
		public weak string get_secure_auth_mech ();
		public weak string get_url_string ();
		public weak string get_user ();
		public bool is_ready ();
		public bool matches_url_string (string url_string);
		public void set_connection_policy (Tny.ConnectionPolicy policy);
		public void set_forget_pass_func (Tny.ForgetPassFunc forget_pass_func);
		public void set_hostname (string host);
		public void set_id (string id);
		public void set_name (string name);
		public void set_pass_func (Tny.GetPassFunc get_pass_func);
		public void set_port (uint port);
		public void set_proto (string proto);
		public void set_secure_auth_mech (string mech);
		public void set_url_string (string url_string);
		public void set_user (string user);
		public void start_operation (Tny.StatusDomain domain, Tny.StatusCode code, Tny.StatusCallback status_callback, pointer status_user_data);
		public void stop_operation (bool cancelled);
		public signal void changed ();
		public signal void connection_status_changed (int status);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface AccountStore : GLib.Object {
		public bool alert (Tny.Account account, Tny.AlertType type, bool question) throws GLib.Error;
		public weak Tny.Account find_account (string url_string);
		public void get_accounts (Tny.List list, Tny.GetAccountsRequestType types);
		public weak string get_cache_dir ();
		public weak Tny.Device get_device ();
		public signal void connecting_started ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface ConnectionPolicy {
		public void on_connect (Tny.Account account);
		public void on_connection_broken (Tny.Account account);
		public void on_disconnect (Tny.Account account);
		public void set_current (Tny.Account account, Tny.Folder folder);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Device : GLib.Object {
		public void force_offline ();
		public void force_online ();
		public bool is_online ();
		public void reset ();
		public signal void connection_changed (bool online);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Folder : GLib.Object {
		public void add_msg (Tny.Msg msg) throws GLib.Error;
		public void add_msg_async (Tny.Msg msg, Tny.FolderCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public void add_observer (Tny.FolderObserver observer);
		public weak Tny.Folder copy (Tny.FolderStore into, string new_name, bool del) throws GLib.Error;
		public void copy_async (Tny.FolderStore into, string new_name, bool del, Tny.CopyFolderCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public weak Tny.Msg find_msg (string url_string) throws GLib.Error;
		public weak Tny.Account get_account ();
		public uint get_all_count ();
		public Tny.FolderCaps get_caps ();
		public weak Tny.FolderStore get_folder_store ();
		public Tny.FolderType get_folder_type ();
		public void get_headers (Tny.List headers, bool refresh) throws GLib.Error;
		public void get_headers_async (Tny.List headers, bool refresh, Tny.GetHeadersCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public weak string get_id ();
		public uint get_local_size ();
		public weak Tny.Msg get_msg (Tny.Header header) throws GLib.Error;
		public void get_msg_async (Tny.Header header, Tny.GetMsgCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public weak Tny.MsgReceiveStrategy get_msg_receive_strategy ();
		public weak Tny.MsgRemoveStrategy get_msg_remove_strategy ();
		public weak string get_name ();
		public weak Tny.FolderStats get_stats ();
		public uint get_unread_count ();
		public weak string get_url_string ();
		public bool is_subscribed ();
		public void poke_status ();
		public void refresh () throws GLib.Error;
		public void refresh_async (Tny.FolderCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public void remove_msg (Tny.Header header) throws GLib.Error;
		public void remove_msgs (Tny.List headers) throws GLib.Error;
		public void remove_observer (Tny.FolderObserver observer);
		public void set_msg_receive_strategy (Tny.MsgReceiveStrategy st);
		public void set_msg_remove_strategy (Tny.MsgRemoveStrategy st);
		public void sync (bool expunge) throws GLib.Error;
		public void sync_async (bool expunge, Tny.FolderCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public void transfer_msgs (Tny.List header_list, Tny.Folder folder_dst, bool delete_originals) throws GLib.Error;
		public void transfer_msgs_async (Tny.List header_list, Tny.Folder folder_dst, bool delete_originals, Tny.TransferMsgsCallback callback, Tny.StatusCallback status_callback, pointer user_data);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface FolderObserver {
		public void update (Tny.FolderChange change);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface FolderStore {
		public void add_observer (Tny.FolderStoreObserver observer);
		public weak Tny.Folder create_folder (string name) throws GLib.Error;
		public void create_folder_async (string name, Tny.CreateFolderCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public void get_folders (Tny.List list, Tny.FolderStoreQuery query) throws GLib.Error;
		public void get_folders_async (Tny.List list, Tny.FolderStoreQuery query, Tny.GetFoldersCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public void remove_folder (Tny.Folder folder) throws GLib.Error;
		public void remove_observer (Tny.FolderStoreObserver observer);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface FolderStoreObserver {
		public void update (Tny.FolderStoreChange change);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Header : GLib.Object {
		public weak string get_bcc ();
		public weak string get_cc ();
		public ulong get_date_received ();
		public ulong get_date_sent ();
		public Tny.HeaderFlags get_flags ();
		public weak Tny.Folder get_folder ();
		public weak string get_from ();
		public weak string get_message_id ();
		public uint get_message_size ();
		public Tny.HeaderFlags get_priority ();
		public weak string get_replyto ();
		public weak string get_subject ();
		public weak string get_to ();
		public weak string get_uid ();
		public void set_bcc (string bcc);
		public void set_cc (string cc);
		public void set_flag (Tny.HeaderFlags mask);
		public void set_from (string from);
		public void set_priority (Tny.HeaderFlags priority);
		public void set_replyto (string to);
		public void set_subject (string subject);
		public void set_to (string to);
		public void unset_flag (Tny.HeaderFlags mask);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Iterator {
		public void first ();
		public weak GLib.Object get_current ();
		public weak Tny.List get_list ();
		public abstract bool is_done ();
		public void next ();
		public void nth (uint nth);
		public void prev ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface List {
		public void append (GLib.Object item);
		public weak Tny.List copy ();
		public weak Tny.Iterator create_iterator ();
		public void @foreach (GLib.Func func, pointer user_data);
		public uint get_length ();
		public void prepend (GLib.Object item);
		public void remove (GLib.Object item);
		public void remove_matches (Tny.ListMatcher matcher, pointer match_data);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Lockable {
		public void @lock ();
		public void unlock ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface MimePart {
		public int add_part (Tny.MimePart part);
		public int @construct (Tny.Stream stream, string mime_type, string transfer_encoding);
		public bool content_type_is (string type);
		public long decode_to_stream (Tny.Stream stream) throws GLib.Error;
		public void decode_to_stream_async (Tny.Stream stream, Tny.MimePartCallback callback, Tny.StatusCallback status_callback, pointer user_data);
		public void del_part (Tny.MimePart part);
		public weak string get_content_id ();
		public weak string get_content_location ();
		public weak string get_content_type ();
		public weak string get_description ();
		public weak string get_filename ();
		public void get_header_pairs (Tny.List list);
		public void get_parts (Tny.List list);
		public weak Tny.Stream get_stream ();
		public weak string get_transfer_encoding ();
		public bool is_attachment ();
		public bool is_purged ();
		public void set_content_id (string content_id);
		public void set_content_location (string content_location);
		public void set_content_type (string contenttype);
		public void set_description (string description);
		public void set_filename (string filename);
		public void set_header_pair (string name, string value);
		public void set_purged ();
		public long write_to_stream (Tny.Stream stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Msg : Tny.MimePart, GLib.Object {
		public weak Tny.Folder get_folder ();
		public weak Tny.Header get_header ();
		public weak string get_url_string ();
		public void rewrite_cache ();
		public void uncache_attachments ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface MsgReceiveStrategy {
		public weak Tny.Msg perform_get_msg (Tny.Folder folder, Tny.Header header) throws GLib.Error;
	}
	[CCode (cheader_filename = "tny.h")]
	public interface MsgRemoveStrategy {
		public void perform_remove (Tny.Folder folder, Tny.Header header) throws GLib.Error;
	}
	[CCode (cheader_filename = "tny.h")]
	public interface PasswordGetter {
		public void forget_password (string aid);
		public weak string get_password (string aid, string prompt, bool cancel);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface SendQueue : GLib.Object {
		public void add (Tny.Msg msg) throws GLib.Error;
		public void cancel (bool remove) throws GLib.Error;
		public weak Tny.Folder get_outbox ();
		public weak Tny.Folder get_sentbox ();
		public signal void error_happened (Tny.Header header, Tny.Msg msg, pointer err);
		public signal void msg_sending (Tny.Header header, Tny.Msg msg, uint nth, uint total);
		public signal void msg_sent (Tny.Header header, Tny.Msg msg, uint nth, uint total);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface StoreAccount : Tny.Account, Tny.FolderStore, GLib.Object {
		public void delete_cache ();
		public weak Tny.Folder find_folder (string url_string) throws GLib.Error;
		public void subscribe (Tny.Folder folder);
		public void unsubscribe (Tny.Folder folder);
		public signal void subscription_changed (Tny.Folder folder);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Stream {
		public int close ();
		public int flush ();
		public bool is_eos ();
		public long read (string buffer, ulong n);
		public int reset ();
		public long write (string buffer, ulong n);
		public long write_to_stream (Tny.Stream output);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface TransportAccount : Tny.Account, GLib.Object {
		public void send (Tny.Msg msg) throws GLib.Error;
	}
	public static delegate void CopyFolderCallback (Tny.Folder self, bool cancelled, Tny.FolderStore into, Tny.Folder new_folder, GLib.Error err, pointer user_data);
	public static delegate void CreateFolderCallback (Tny.FolderStore self, bool cancelled, Tny.Folder new_folder, GLib.Error err, pointer user_data);
	public static delegate void FolderCallback (Tny.Folder self, bool cancelled, GLib.Error err, pointer user_data);
	public static delegate void ForgetPassFunc (Tny.Account self);
	public static delegate void GetFoldersCallback (Tny.FolderStore self, bool cancelled, Tny.List list, GLib.Error err, pointer user_data);
	public static delegate void GetHeadersCallback (Tny.Folder self, bool cancelled, Tny.List headers, GLib.Error err, pointer user_data);
	public static delegate void GetMsgCallback (Tny.Folder folder, bool cancelled, Tny.Msg msg, GLib.Error err, pointer user_data);
	public static delegate weak string GetPassFunc (Tny.Account self, string prompt, bool cancel);
	public static delegate bool ListMatcher (Tny.List list, GLib.Object item, pointer match_data);
	public static delegate void MimePartCallback (Tny.MimePart self, bool cancelled, Tny.Stream stream, GLib.Error err, pointer user_data);
	public static delegate void SendQueueAddCallback (Tny.SendQueue self, bool cancelled, Tny.Msg msg, GLib.Error err, pointer user_data);
	public static delegate void StatusCallback (GLib.Object self, Tny.Status status, pointer user_data);
	public static delegate void TransferMsgsCallback (Tny.Folder folder, bool cancelled, GLib.Error err, pointer user_data);
	public const int HEADER_FLAG_PRIORITY_MASK;
	public const int PRIORITY_LOWER_THAN_GTK_REDRAWS;
	public static void clear_status (out weak Tny.Status status);
	public static void marshal_VOID__OBJECT_OBJECT_INT_INT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, pointer invocation_hint, pointer marshal_data);
	public static void marshal_VOID__OBJECT_OBJECT_POINTER (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, pointer invocation_hint, pointer marshal_data);
	public static void set_status (out weak Tny.Status status, GLib.Quark domain, int code, uint position, uint of_total, string format);
}
