// -*- c++ -*-
// Generated by gmmproc 2.39.4 -- DO NOT MODIFY!
#ifndef _WNCKMM_WINDOW_H
#define _WNCKMM_WINDOW_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/** This file is part of wnckmm

    Copyright (c) 2013 Povilas Kanapickas  <povilas@radix.lt>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gdkmm/pixbuf.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _WnckWindow WnckWindow;
typedef struct _WnckWindowClass WnckWindowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{ class Window_Class; } // namespace Wnck
namespace Wnck
{

/** @addtogroup wnckmmEnums wnckmm Enums and Flags */

/** 
 * 
 * @ingroup wnckmmEnums
 */
enum WindowType
{
  WINDOW_NORMAL,
  WINDOW_DESKTOP,
  WINDOW_DOCK,
  WINDOW_DIALOG,
  WINDOW_TOOLBAR,
  WINDOW_MENU,
  WINDOW_UTILITY,
  WINDOW_SPLASHSCREEN
};

} // namespace Wnck


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Wnck::WindowType> : public Glib::Value_Enum<Wnck::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{

/** 
 * 
 * @ingroup wnckmmEnums
 * @par Bitwise operators:
 * <tt>%WindowState operator|(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator&(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator^(WindowState, WindowState)</tt><br>
 * <tt>%WindowState operator~(WindowState)</tt><br>
 * <tt>%WindowState& operator|=(WindowState&, WindowState)</tt><br>
 * <tt>%WindowState& operator&=(WindowState&, WindowState)</tt><br>
 * <tt>%WindowState& operator^=(WindowState&, WindowState)</tt><br>
 */
enum WindowState
{
  WINDOW_STATE_MINIMIZED = 1 << 0,
  WINDOW_STATE_MAXIMIZED_HORIZONTALLY = 1 << 1,
  WINDOW_STATE_MAXIMIZED_VERTICALLY = 1 << 2,
  WINDOW_STATE_SHADED = 1 << 3,
  WINDOW_STATE_SKIP_PAGER = 1 << 4,
  WINDOW_STATE_SKIP_TASKLIST = 1 << 5,
  WINDOW_STATE_STICKY = 1 << 6,
  WINDOW_STATE_HIDDEN = 1 << 7,
  WINDOW_STATE_FULLSCREEN = 1 << 8,
  WINDOW_STATE_DEMANDS_ATTENTION = 1 << 9,
  WINDOW_STATE_URGENT = 1 << 10,
  WINDOW_STATE_ABOVE = 1 << 11,
  WINDOW_STATE_BELOW = 1 << 12
};

/** @ingroup wnckmmEnums */
inline WindowState operator|(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowState operator&(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowState operator^(WindowState lhs, WindowState rhs)
  { return static_cast<WindowState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowState operator~(WindowState flags)
  { return static_cast<WindowState>(~static_cast<unsigned>(flags)); }

/** @ingroup wnckmmEnums */
inline WindowState& operator|=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup wnckmmEnums */
inline WindowState& operator&=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup wnckmmEnums */
inline WindowState& operator^=(WindowState& lhs, WindowState rhs)
  { return (lhs = static_cast<WindowState>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Wnck


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Wnck::WindowState> : public Glib::Value_Flags<Wnck::WindowState>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{

/** 
 * 
 * @ingroup wnckmmEnums
 * @par Bitwise operators:
 * <tt>%WindowActions operator|(WindowActions, WindowActions)</tt><br>
 * <tt>%WindowActions operator&(WindowActions, WindowActions)</tt><br>
 * <tt>%WindowActions operator^(WindowActions, WindowActions)</tt><br>
 * <tt>%WindowActions operator~(WindowActions)</tt><br>
 * <tt>%WindowActions& operator|=(WindowActions&, WindowActions)</tt><br>
 * <tt>%WindowActions& operator&=(WindowActions&, WindowActions)</tt><br>
 * <tt>%WindowActions& operator^=(WindowActions&, WindowActions)</tt><br>
 */
enum WindowActions
{
  WINDOW_ACTION_MOVE = 1 << 0,
  WINDOW_ACTION_RESIZE = 1 << 1,
  WINDOW_ACTION_SHADE = 1 << 2,
  WINDOW_ACTION_STICK = 1 << 3,
  WINDOW_ACTION_MAXIMIZE_HORIZONTALLY = 1 << 4,
  WINDOW_ACTION_MAXIMIZE_VERTICALLY = 1 << 5,
  WINDOW_ACTION_CHANGE_WORKSPACE = 1 << 6,
  WINDOW_ACTION_CLOSE = 1 << 7,
  WINDOW_ACTION_UNMAXIMIZE_HORIZONTALLY = 1 << 8,
  WINDOW_ACTION_UNMAXIMIZE_VERTICALLY = 1 << 9,
  WINDOW_ACTION_UNSHADE = 1 << 10,
  WINDOW_ACTION_UNSTICK = 1 << 11,
  WINDOW_ACTION_MINIMIZE = 1 << 12,
  WINDOW_ACTION_UNMINIMIZE = 1 << 13,
  WINDOW_ACTION_MAXIMIZE = 1 << 14,
  WINDOW_ACTION_UNMAXIMIZE = 1 << 15,
  WINDOW_ACTION_FULLSCREEN = 1 << 16,
  WINDOW_ACTION_ABOVE = 1 << 17,
  WINDOW_ACTION_BELOW = 1 << 18
};

/** @ingroup wnckmmEnums */
inline WindowActions operator|(WindowActions lhs, WindowActions rhs)
  { return static_cast<WindowActions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowActions operator&(WindowActions lhs, WindowActions rhs)
  { return static_cast<WindowActions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowActions operator^(WindowActions lhs, WindowActions rhs)
  { return static_cast<WindowActions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowActions operator~(WindowActions flags)
  { return static_cast<WindowActions>(~static_cast<unsigned>(flags)); }

/** @ingroup wnckmmEnums */
inline WindowActions& operator|=(WindowActions& lhs, WindowActions rhs)
  { return (lhs = static_cast<WindowActions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup wnckmmEnums */
inline WindowActions& operator&=(WindowActions& lhs, WindowActions rhs)
  { return (lhs = static_cast<WindowActions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup wnckmmEnums */
inline WindowActions& operator^=(WindowActions& lhs, WindowActions rhs)
  { return (lhs = static_cast<WindowActions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Wnck


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Wnck::WindowActions> : public Glib::Value_Flags<Wnck::WindowActions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{

/** 
 * 
 * @ingroup wnckmmEnums
 */
enum WindowGravity
{
  WINDOW_GRAVITY_CURRENT,
  WINDOW_GRAVITY_NORTHWEST,
  WINDOW_GRAVITY_NORTH,
  WINDOW_GRAVITY_NORTHEAST,
  WINDOW_GRAVITY_WEST,
  WINDOW_GRAVITY_CENTER,
  WINDOW_GRAVITY_EAST,
  WINDOW_GRAVITY_SOUTHWEST,
  WINDOW_GRAVITY_SOUTH,
  WINDOW_GRAVITY_SOUTHEAST,
  WINDOW_GRAVITY_STATIC
};

} // namespace Wnck


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Wnck::WindowGravity> : public Glib::Value_Enum<Wnck::WindowGravity>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{

/** 
 * 
 * @ingroup wnckmmEnums
 * @par Bitwise operators:
 * <tt>%WindowMoveResizeMask operator|(WindowMoveResizeMask, WindowMoveResizeMask)</tt><br>
 * <tt>%WindowMoveResizeMask operator&(WindowMoveResizeMask, WindowMoveResizeMask)</tt><br>
 * <tt>%WindowMoveResizeMask operator^(WindowMoveResizeMask, WindowMoveResizeMask)</tt><br>
 * <tt>%WindowMoveResizeMask operator~(WindowMoveResizeMask)</tt><br>
 * <tt>%WindowMoveResizeMask& operator|=(WindowMoveResizeMask&, WindowMoveResizeMask)</tt><br>
 * <tt>%WindowMoveResizeMask& operator&=(WindowMoveResizeMask&, WindowMoveResizeMask)</tt><br>
 * <tt>%WindowMoveResizeMask& operator^=(WindowMoveResizeMask&, WindowMoveResizeMask)</tt><br>
 */
enum WindowMoveResizeMask
{
  WINDOW_CHANGE_X = 1 << 0,
  WINDOW_CHANGE_Y = 1 << 1,
  WINDOW_CHANGE_WIDTH = 1 << 2,
  WINDOW_CHANGE_HEIGHT = 1 << 3
};

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask operator|(WindowMoveResizeMask lhs, WindowMoveResizeMask rhs)
  { return static_cast<WindowMoveResizeMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask operator&(WindowMoveResizeMask lhs, WindowMoveResizeMask rhs)
  { return static_cast<WindowMoveResizeMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask operator^(WindowMoveResizeMask lhs, WindowMoveResizeMask rhs)
  { return static_cast<WindowMoveResizeMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask operator~(WindowMoveResizeMask flags)
  { return static_cast<WindowMoveResizeMask>(~static_cast<unsigned>(flags)); }

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask& operator|=(WindowMoveResizeMask& lhs, WindowMoveResizeMask rhs)
  { return (lhs = static_cast<WindowMoveResizeMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask& operator&=(WindowMoveResizeMask& lhs, WindowMoveResizeMask rhs)
  { return (lhs = static_cast<WindowMoveResizeMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup wnckmmEnums */
inline WindowMoveResizeMask& operator^=(WindowMoveResizeMask& lhs, WindowMoveResizeMask rhs)
  { return (lhs = static_cast<WindowMoveResizeMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Wnck


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Wnck::WindowMoveResizeMask> : public Glib::Value_Flags<Wnck::WindowMoveResizeMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Wnck
{


class Screen;
class Application;
class ClassGroup;
class Workspace;
/** This represents a workspace.
 */

class Window : public Glib::Object
{
    
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Window CppObjectType;
  typedef Window_Class CppClassType;
  typedef WnckWindow BaseObjectType;
  typedef WnckWindowClass BaseClassType;

private:
  friend class Window_Class;
  static CppClassType window_class_;

private:
  // noncopyable
  Window(const Window&);
  Window& operator=(const Window&);

protected:
  explicit Window(const Glib::ConstructParams& construct_params);
  explicit Window(WnckWindow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Window();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  WnckWindow*       gobj()       { return reinterpret_cast<WnckWindow*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const WnckWindow* gobj() const { return reinterpret_cast<WnckWindow*>(gobject_); }

private:


protected:
    Window();

public:
    
  static Window* get_for_xid(gulong xid);
    
  Screen* get_screen() const;
    
  bool has_name() const;
    
  std::string get_name() const;
    
  bool has_icon_name() const;
    
  std::string get_icon_name() const;
    
  bool is_icon_fallback() const;
    // TODO: is pixbuf const?;
    
  Glib::RefPtr<Gdk::Pixbuf> get_icon() const;
    // TODO: is pixbuf const?;
    
  Glib::RefPtr<Gdk::Pixbuf> get_mini_icon() const;
    
  Application* get_application() const;
    
  Window* get_transient() const;
    
  gulong get_group_leader() const;
    
  gulong get_xid() const;
    
  ClassGroup* get_class_group() const;
    
  std::string get_session_id() const;
    
  std::string get_session_id_utf8() const;
    
  int get_pid() const;

    
  int get_sort_order() const;
    
  void set_sort_order(int order);

    
  WindowType get_window_type() const;
    
  void set_window_type(WindowType order);

    
  WindowState get_state() const;
    
  bool is_minimized() const;
    
  bool is_maximized_horizontally() const;
    
  bool is_maximized_vertically() const;
    
  bool is_maximized() const;
    
  bool is_shaded() const;
    
  bool is_pinned() const;
    
  bool is_sticky() const;
    
  bool is_above() const;
    
  bool is_below() const;
    
  bool is_skip_pager() const;
    
  bool is_skip_tasklist() const;
    
  bool is_fullscreen() const;
    
  bool is_needs_attention() const;
    
  bool is_needs_attention_or_transient() const;

    
  WindowActions get_actions() const;
    
  void minimize();
    
  void unminimize(guint32 timestamp);

    
  void maximize();
    
  void unmaximize();
    
  void maximize_vertically();
    
  void unmaximize_vertically();
    
  void maximize_horizontally();
    
  void unmaximize_horizontally();

    
  void shade();
    
  void unshade();

    
  void pin();
    
  void unpin();

    
  void stick();
    
  void unstick();

    
  void make_above();
    
  void unmake_above();

    
  void make_below();
    
  void unmake_below();

    
  void set_skip_pager(bool skip =  true);
    
  void set_skip_tasklist(bool skip =  true);
    
  void set_fullscreen(bool fullscreen =  true);

    
  void close(guint32 timestamp);

    
  Workspace* get_workspace() const;
    
  bool is_on_workspace(const Workspace* workspace) const;
    
  bool is_visible_on_workspace(const Workspace* workspace) const;
    
  void move_to_workspace(const Workspace* workspace);

    
  bool is_in_viewport(const Workspace* workspace) const;

    
  void activate(guint32 timestamp);
    
  bool is_active() const;
    
  bool is_most_recently_activated() const;

    
  void activate_transient(guint32 timestamp);
    
  bool is_transient_most_recently_activated() const;

    
  void set_icon_geometry(int x, int y, int width, int height);
    // TODO: documentation
    void set_icon_geometry(const Gdk::Rectangle& geom);

    // TODO: documentation
    Gdk::Rectangle get_client_geometry() const;
    

    // TODO: documentation
    Gdk::Rectangle get_geometry() const;
    

  void set_geometry(WindowGravity gravity, WindowMoveResizeMask geometry_mask, int x, int y, int width, int height);

    void set_geometry(WindowGravity gravity, WindowMoveResizeMask geometry_mask,
                      const Gdk::Rectangle& geom);

    
  void keyboard_move();
    
  void keyboard_size();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%actions_changed(WindowActions changed_mask, WindowActions new_state)</tt>
   *
   */

  Glib::SignalProxy2< void,WindowActions,WindowActions > signal_actions_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%geometry_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_geometry_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%state_changed(WindowState changed_mask, WindowState new_state)</tt>
   *
   */

  Glib::SignalProxy2< void,WindowState,WindowState > signal_state_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%workspace_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_workspace_changed();


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%icon_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_icon_changed();

    
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%name_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_name_changed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_actions_changed().
  virtual void on_actions_changed(WindowActions changed_mask, WindowActions new_state);
  /// This is a default handler for the signal signal_geometry_changed().
  virtual void on_geometry_changed();
  /// This is a default handler for the signal signal_state_changed().
  virtual void on_state_changed(WindowState changed_mask, WindowState new_state);
  /// This is a default handler for the signal signal_workspace_changed().
  virtual void on_workspace_changed();
  /// This is a default handler for the signal signal_icon_changed().
  virtual void on_icon_changed();
  /// This is a default handler for the signal signal_name_changed().
  virtual void on_name_changed();


};

} //namespace Wnck


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Wnck::Window
   */
  Wnck::Window* wrap(WnckWindow* object, bool take_copy = false);
}


#endif /* _WNCKMM_WINDOW_H */

