/*
 * UFC-crypt: ultra fast crypt(3) implementation
 *
 * Copyright (C) 1991, 92, 93, 96, 97, 98, 2000, 2002 Free Software Foundation, Inc.
 *
 * The GNU C Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The GNU C Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the GNU C Library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 *
 * @(#)crypt.h	1.5 12/20/96
 *
 */

#ifndef _XCRYPT_H
#define _XCRYPT_H	1

#include <features.h>

__BEGIN_DECLS

/* Encrypt at most 8 characters from KEY using salt to perturb DES.  */
extern char *xcrypt (__const char *__key, __const char *__salt) __THROW;
#define crypt xcrypt

/* Setup DES tables according KEY.  */
extern void setkey (__const char *__key) __THROW;

/* Encrypt data in BLOCK in place if EDFLAG is zero; otherwise decrypt
   block in place.  */
extern void encrypt (char *__block, int __edflag) __THROW;

/* Reentrant versions of the functions above.  The additional argument
   points to a structure where the results are placed in.  */
struct crypt_data
  {
    char keysched[16 * 8];
    char sb0[32768];
    char sb1[32768];
    char sb2[32768];
    char sb3[32768];
    /* end-of-aligment-critical-data */
    char crypt_3_buf[14];
    char current_salt[2];
    long int current_saltbits;
    int  direction, initialized;
  };

extern char *xcrypt_r (__const char *__key, __const char *__salt,
		       struct crypt_data * __restrict __data) __THROW;
#define crypt_r xcrypt_r


extern void setkey_r (__const char *__key,
		       struct crypt_data * __restrict __data) __THROW;

extern void encrypt_r (char *__block, int __edflag,
			struct crypt_data * __restrict __data) __THROW;

extern char *xcrypt_rn (__const char *key, __const char *setting,
			void *data, int size) __THROW;
#define crypt_rn xcrypt_rn

extern char *xcrypt_ra (__const char *key, __const char *setting,
			void **data, int *size) __THROW;
#define crypt_ra xcrypt_ra

extern char *xcrypt_gensalt (__const char *prefix, unsigned long count,
			     __const char *input, int size) __THROW;
#define crypt_gensalt xcrypt_gensalt

extern char *xcrypt_gensalt_rn (__const char *prefix, unsigned long count,
				__const char *input, int size, char *output,
				int output_size) __THROW;
#define crypt_gensalt_rn xcrypt_gensalt_rn

extern char *xcrypt_gensalt_ra (__const char *prefix, unsigned long count,
			        __const char *input, int size) __THROW;
#define crypt_gensalt_ra xcrypt_gensalt_ra

extern char *bigcrypt (__const char *key, __const char *salt) __THROW;

/* Allow the programmer not to define the MD5 prototypes.  */
#ifndef XCRYPT_NO_MD5_PROTOTYPES

#include <stdio.h>

/* The following contortions are an attempt to use the C preprocessor
   to determine an unsigned integral type that is 32 bits wide.  An
   alternative approach is to use autoconf's AC_CHECK_SIZEOF macro, but
   doing that would require that the configure script compile and *run*
   the resulting executable.  Locally running cross-compiled executables
   is usually not possible.  */

#include <stdint.h>
typedef uint32_t md5_uint32;
typedef uintptr_t md5_uintptr;

/* Structure to save state of computation between the single steps.  */
struct md5_ctx
{
  md5_uint32 A;
  md5_uint32 B;
  md5_uint32 C;
  md5_uint32 D;

  md5_uint32 total[2];
  md5_uint32 buflen;
  char buffer[128] __attribute__ ((__aligned__ (__alignof__ (md5_uint32))));
};

/*
 * The following three functions are build up the low level used in
 * the functions `md5_stream' and `md5_buffer'.
 */

/* Initialize structure containing state of computation.
   (RFC 1321, 3.3: Step 3)  */
extern void md5_init_ctx (struct md5_ctx *ctx) __THROW;

/* Starting with the result of former calls of this function (or the
   initialization function update the context for the next LEN bytes
   starting at BUFFER.
   It is necessary that LEN is a multiple of 64!!! */
extern void md5_process_block (__const void *buffer, size_t len,
			       struct md5_ctx *ctx) __THROW;

/* Starting with the result of former calls of this function (or the
   initialization function update the context for the next LEN bytes
   starting at BUFFER.
   It is NOT required that LEN is a multiple of 64.  */
extern void md5_process_bytes (__const void *buffer, size_t len,
			       struct md5_ctx *ctx) __THROW;

/* Process the remaining bytes in the buffer and put result from CTX
   in first 16 bytes following RESBUF.  The result is always in little
   endian byte order, so that a byte-wise output yields to the wanted
   ASCII representation of the message digest.

   IMPORTANT: On some systems it is required that RESBUF is correctly
   aligned for a 32 bits value.  */
extern void *md5_finish_ctx (struct md5_ctx *ctx, void *resbuf) __THROW;


/* Put result from CTX in first 16 bytes following RESBUF.  The result is
   always in little endian byte order, so that a byte-wise output yields
   to the wanted ASCII representation of the message digest.

   IMPORTANT: On some systems it is required that RESBUF is correctly
   aligned for a 32 bits value.  */
extern void *md5_read_ctx (__const struct md5_ctx *ctx,
			   void *resbuf) __THROW;


/* Compute MD5 message digest for bytes read from STREAM.  The
   resulting message digest number will be written into the 16 bytes
   beginning at RESBLOCK.  */
extern int md5_stream (FILE *stream, void *resblock) __THROW;

/* Compute MD5 message digest for LEN bytes beginning at BUFFER.  The
   result is always in little endian byte order, so that a byte-wise
   output yields to the wanted ASCII representation of the message
   digest.  */
extern void *md5_buffer (__const char *buffer, size_t len,
			 void *resblock) __THROW;

/* md5_crypt function.  */
extern char *md5_crypt_r (__const char *key, __const char *salt,
			  char *buffer, int buflen) __THROW;
extern char *md5_crypt (__const char *key, __const char *salt) __THROW;

#endif /* XCRYPT_NO_MD5_PROTOTYPES */

/* Allow the programmer not to define the SHA1 prototypes.  */
#ifndef XCRYPT_NO_SHA1_PROTOTYPES

#include <stdint.h>

typedef struct {
  uint32_t state[5];
  uint32_t count[2];
  unsigned char buffer[64];
} SHA1_CTX;

extern void SHA1Transform (uint32_t state[5],
			   unsigned char buffer[64]) __THROW;
extern void SHA1Init (SHA1_CTX *context) __THROW;
extern void SHA1Update (SHA1_CTX *context, __const unsigned char *data,
			unsigned int len) __THROW;
extern void SHA1Final (unsigned char digest[20], SHA1_CTX *context) __THROW;

/* sha_crypt function. salt argument is ignored.  */
extern char *sha_crypt_r (__const char *key, __const char *salt,
                          char *buffer, int buflen) __THROW;
extern char *sha_crypt (__const char *key, __const char *salt) __THROW;

#endif /* XCRYPT_NO_SHA1_PROTOTYPES */

__END_DECLS

#endif	/* xcrypt.h */
